/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.parser;

import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.UIPropertyValueParser;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BorderParser
implements UIPropertyValueParser {
    public Object parse(UIPage uIPage, String string, ClassLoader classLoader) {
        return this.parse(string);
    }

    private Border parse(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block25: for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            switch (n) {
                case 44: {
                    if (n2 == 0) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        continue block25;
                    }
                    stringBuffer.append((char)n);
                    continue block25;
                }
                case 40: {
                    ++n2;
                    stringBuffer.append((char)n);
                    continue block25;
                }
                case 41: {
                    --n2;
                    stringBuffer.append((char)n);
                    continue block25;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        arrayList.add(stringBuffer.toString());
        String[] stringArray = arrayList.toArray(new String[0]);
        if ("empty".equalsIgnoreCase(stringArray[0])) {
            if (stringArray.length == 1) {
                return BorderFactory.createEmptyBorder();
            }
            if (stringArray.length != 5) {
                throw new IllegalArgumentException("Empty border needs 0 or 4 numbers.");
            }
            return BorderFactory.createEmptyBorder(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]));
        }
        if ("bevel".equalsIgnoreCase(stringArray[0])) {
            Border border = null;
            if (stringArray.length < 2) {
                throw new IllegalArgumentException("Bevel border needs at least 1 parameter.");
            }
            int n3 = 0;
            if ("lowered".equalsIgnoreCase(stringArray[1])) {
                n3 = 1;
            } else if ("raised".equalsIgnoreCase(stringArray[1])) {
                n3 = 0;
            } else {
                throw new IllegalArgumentException("Bevel border type is unknown.");
            }
            switch (stringArray.length) {
                case 2: {
                    border = BorderFactory.createBevelBorder(n3);
                    break;
                }
                case 4: {
                    border = BorderFactory.createBevelBorder(n3, Color.decode(stringArray[2]), Color.decode(stringArray[3]));
                    break;
                }
                case 6: {
                    border = BorderFactory.createBevelBorder(n3, Color.decode(stringArray[2]), Color.decode(stringArray[3]), Color.decode(stringArray[4]), Color.decode(stringArray[5]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The number of parameters for bevel border must be 1, 3, or 5.");
                }
            }
            return border;
        }
        if ("etched".equalsIgnoreCase(stringArray[0])) {
            Border border = null;
            if (stringArray.length < 2) {
                throw new IllegalArgumentException("Etched border needs at least 1 parameter.");
            }
            int n4 = 0;
            if ("lowered".equalsIgnoreCase(stringArray[1])) {
                n4 = 1;
            } else if ("raised".equalsIgnoreCase(stringArray[1])) {
                n4 = 0;
            } else {
                throw new IllegalArgumentException("Etched border type is unknown.");
            }
            switch (stringArray.length) {
                case 2: {
                    border = BorderFactory.createEtchedBorder(n4);
                    break;
                }
                case 4: {
                    border = BorderFactory.createEtchedBorder(n4, Color.decode(stringArray[2]), Color.decode(stringArray[3]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The number of parameters for etched border must be 1 or 3.");
                }
            }
            return border;
        }
        if ("line".equalsIgnoreCase(stringArray[0])) {
            Border border;
            switch (stringArray.length) {
                case 2: {
                    border = BorderFactory.createLineBorder(Color.decode(stringArray[1]));
                    break;
                }
                case 3: {
                    border = BorderFactory.createLineBorder(Color.decode(stringArray[1]), Integer.parseInt(stringArray[2]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The number of parameters for line border must be 2 or 3.");
                }
            }
            return border;
        }
        if ("compound".equalsIgnoreCase(stringArray[0])) {
            if (stringArray.length != 3) {
                throw new IllegalArgumentException("Compound border must have two parameters.");
            }
            if (!(stringArray[1].startsWith("(") && stringArray[1].endsWith(")") && stringArray[2].startsWith("(") && stringArray[2].endsWith(")"))) {
                throw new IllegalArgumentException("Two border definitions must be bracketed.");
            }
            return BorderFactory.createCompoundBorder(this.parse(stringArray[1].substring(1, stringArray[1].length() - 1)), this.parse(stringArray[2].substring(1, stringArray[2].length() - 1)));
        }
        if ("titled".equalsIgnoreCase(stringArray[0])) {
            TitledBorder titledBorder;
            if (stringArray.length < 2) {
                throw new IllegalArgumentException("Titled border must have at least two parameters.");
            }
            if (!(stringArray.length <= 2 || stringArray[1].startsWith("(") && stringArray[1].endsWith(")"))) {
                throw new IllegalArgumentException("Nested border definition must be bracketed.");
            }
            n = 0;
            int n5 = 0;
            if (stringArray.length >= 5) {
                if ("left".equalsIgnoreCase(stringArray[3])) {
                    n = 1;
                } else if ("center".equalsIgnoreCase(stringArray[3])) {
                    n = 2;
                } else if ("right".equalsIgnoreCase(stringArray[3])) {
                    n = 3;
                } else if ("leading".equalsIgnoreCase(stringArray[3])) {
                    n = 4;
                } else if ("trailing".equalsIgnoreCase(stringArray[3])) {
                    n = 5;
                } else if ("default_justification".equalsIgnoreCase(stringArray[3])) {
                    n = 0;
                } else {
                    throw new IllegalArgumentException("Titled border has an invalid justification.");
                }
                if ("above_top".equalsIgnoreCase(stringArray[4])) {
                    n5 = 1;
                } else if ("top".equalsIgnoreCase(stringArray[4])) {
                    n5 = 2;
                } else if ("below_top".equalsIgnoreCase(stringArray[4])) {
                    n5 = 3;
                } else if ("above_bottom".equalsIgnoreCase(stringArray[4])) {
                    n5 = 4;
                } else if ("bottom".equalsIgnoreCase(stringArray[4])) {
                    n5 = 5;
                } else if ("below_bottom".equalsIgnoreCase(stringArray[4])) {
                    n5 = 6;
                } else if ("default_position".equalsIgnoreCase(stringArray[4])) {
                    n5 = 0;
                } else {
                    throw new IllegalArgumentException("Titled border has an invalid position.");
                }
            }
            switch (stringArray.length) {
                case 2: {
                    if (stringArray[1].startsWith("(") && stringArray[1].endsWith(")")) {
                        titledBorder = BorderFactory.createTitledBorder(this.parse(stringArray[1].substring(1, stringArray[1].length() - 1)));
                        break;
                    }
                    titledBorder = BorderFactory.createTitledBorder(stringArray[1]);
                    break;
                }
                case 3: {
                    titledBorder = BorderFactory.createTitledBorder(this.parse(stringArray[1].substring(1, stringArray[1].length() - 1)), stringArray[2]);
                    break;
                }
                case 5: {
                    titledBorder = BorderFactory.createTitledBorder(this.parse(stringArray[1].substring(1, stringArray[1].length() - 1)), stringArray[2], n, n5);
                    break;
                }
                case 6: {
                    titledBorder = BorderFactory.createTitledBorder(this.parse(stringArray[1].substring(1, stringArray[1].length() - 1)), stringArray[2], n, n5, Font.decode(stringArray[5]));
                    break;
                }
                case 7: {
                    titledBorder = BorderFactory.createTitledBorder(this.parse(stringArray[1].substring(1, stringArray[1].length() - 1)), stringArray[2], n, n5, Font.decode(stringArray[5]), Color.decode(stringArray[6]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Titled border must have 1, 2, 4, 5, or 6 parameters.");
                }
            }
            return titledBorder;
        }
        throw new IllegalArgumentException("Unknown border type.");
    }
}

