/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.impl.component;

import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIComponentException;
import com.topcoder.client.ui.UIEventListener;
import java.awt.GridBagConstraints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class UIAbstractComponent
implements UIComponent {
    private Object component;
    private UIComponent parent;
    private boolean created = false;
    protected List propertyOrder = new ArrayList();
    protected Map properties = new HashMap();
    protected List children = new ArrayList();
    protected List constraints = new ArrayList();

    protected abstract Object createComponent();

    protected void initialize() throws UIComponentException {
        this.component = this.createComponent();
        this.created = true;
    }

    public void create() throws UIComponentException {
        if (this.created) {
            return;
        }
        this.initialize();
        Iterator iterator = this.propertyOrder.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.setPropertyImpl(string, this.properties.get(string));
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.addChildImpl((UIComponent)this.children.get(i), (GridBagConstraints)this.constraints.get(i));
        }
        this.propertyOrder = null;
        this.properties = null;
        this.children = null;
        this.constraints = null;
    }

    public void destroy() {
        if (this.created) {
            this.destroyImpl();
        }
    }

    protected void destroyImpl() {
    }

    public void addChild(UIComponent uIComponent, GridBagConstraints gridBagConstraints) throws UIComponentException {
        uIComponent.setParent(this);
        if (!this.created) {
            this.children.add(uIComponent);
            this.constraints.add(gridBagConstraints);
        } else {
            this.addChildImpl(uIComponent, gridBagConstraints);
        }
    }

    protected abstract void addChildImpl(UIComponent var1, GridBagConstraints var2) throws UIComponentException;

    public void setProperty(String string, Object object) throws UIComponentException {
        if (!this.created) {
            this.properties.put(string.toLowerCase(), object);
            this.propertyOrder.add(string.toLowerCase());
        } else {
            try {
                this.setPropertyImpl(string, object);
            }
            catch (ClassCastException classCastException) {
                throw new UIComponentException("The property value class is not valid for property '" + string + "'.", classCastException);
            }
        }
    }

    protected void setPropertyImpl(String string, Object object) throws UIComponentException {
        throw new UIComponentException("The property '" + string + "' is not writeable.");
    }

    public Object getProperty(String string) throws UIComponentException {
        if (!this.created) {
            this.create();
        }
        return this.getPropertyImpl(string);
    }

    protected Object getPropertyImpl(String string) throws UIComponentException {
        throw new UIComponentException("The property '" + string + "' is not readable.");
    }

    public void addEventListener(String string, UIEventListener uIEventListener) throws UIComponentException {
        if (!this.created) {
            this.create();
        }
        try {
            this.addEventListenerImpl(string, uIEventListener);
        }
        catch (ClassCastException classCastException) {
            throw new UIComponentException("The event listener class is not valid for event '" + string + "'.", classCastException);
        }
    }

    protected void addEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        throw new UIComponentException("The event '" + string + "' does not exist.");
    }

    public void removeEventListener(String string, UIEventListener uIEventListener) throws UIComponentException {
        if (!this.created) {
            this.create();
        }
        try {
            this.removeEventListenerImpl(string, uIEventListener);
        }
        catch (ClassCastException classCastException) {
            throw new UIComponentException("The event listener class is not valid for event '" + string + "'.", classCastException);
        }
    }

    protected void removeEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        throw new UIComponentException("The event '" + string + "' does not exist.");
    }

    public Object performAction(String string) throws UIComponentException {
        return this.performAction(string, null);
    }

    protected void assertNull(String string, Object[] objectArray) throws UIComponentException {
        if (objectArray != null) {
            throw new UIComponentException("The action '" + string + "' must have no argument.");
        }
    }

    protected void assertArgs(String string, Object[] objectArray, Class[] classArray) throws UIComponentException {
        if (objectArray == null || objectArray.length != classArray.length) {
            throw new UIComponentException("The action '" + string + "' must have " + classArray.length + " argument(s).");
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (objectArray[i] == null || classArray[i].isInstance(objectArray[i])) continue;
            throw new UIComponentException("The " + (i + 1) + " argument of the action '" + string + "' must be " + classArray[i] + ".");
        }
    }

    public Object performAction(String string, Object[] objectArray) throws UIComponentException {
        if (objectArray != null && objectArray.length == 0) {
            objectArray = null;
        }
        if (!this.created) {
            this.create();
        }
        try {
            return this.performActionImpl(string, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            throw new UIComponentException("One argument of action " + string + " cannot be null.", nullPointerException);
        }
    }

    protected Object performActionImpl(String string, Object[] objectArray) throws UIComponentException {
        if ("clone".equalsIgnoreCase(string) && this.component instanceof Serializable) {
            Object object;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this.component);
                objectOutputStream.close();
                CustomObjectInputStream customObjectInputStream = new CustomObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), this.component.getClass().getClassLoader());
                object = customObjectInputStream.readObject();
                customObjectInputStream.close();
            }
            catch (IOException iOException) {
                throw new UIComponentException("I/O error occurred.", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UIComponentException("The class cannot be found.", classNotFoundException);
            }
            return object;
        }
        throw new UIComponentException("The action '" + string + "' cannot be performed.");
    }

    public Object getEventSource() {
        if (!this.created) {
            this.create();
        }
        return this.component;
    }

    public void setParent(UIComponent uIComponent) {
        this.parent = uIComponent;
    }

    public UIComponent getParent() {
        return this.parent;
    }

    private static class CustomObjectInputStream
    extends ObjectInputStream {
        private ClassLoader loader;

        public CustomObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
            super(inputStream);
            this.loader = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(objectStreamClass.getName(), false, this.loader);
            }
            catch (Exception exception) {
                return super.resolveClass(objectStreamClass);
            }
        }
    }
}

