/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ElementRenderer;
import com.topcoder.shared.problem.TestCase;

public class LongTestCaseRenderer
extends BaseRenderer
implements ElementRenderer {
    private TestCase testCase;

    public LongTestCaseRenderer() {
        this.testCase = null;
    }

    public LongTestCaseRenderer(TestCase testCase) {
        this.testCase = testCase;
    }

    public void setElement(Element element) throws Exception {
        this.testCase = (TestCase)element;
    }

    public String toHTML(Language language) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<table>");
        stringBuffer.append("<tr><td>");
        stringBuffer.append("<pre>");
        String string = this.testCase.getOutput();
        stringBuffer.append(string.substring(1, string.length() - 1));
        stringBuffer.append("</pre>");
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>");
        if (this.testCase.getAnnotation() != null) {
            stringBuffer.append("<table>");
            stringBuffer.append("<tr><td colspan=\"2\">");
            stringBuffer.append(super.getRenderer(this.testCase.getAnnotation()).toHTML(language));
            stringBuffer.append("</td></tr>");
            stringBuffer.append("</table>");
        }
        stringBuffer.append("</td></tr>");
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    public String toPlainText(Language language) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.testCase.getOutput());
        if (this.testCase.getAnnotation() != null) {
            stringBuffer.append("\n\n");
            stringBuffer.append(super.getRenderer(this.testCase.getAnnotation()).toPlainText(language));
        }
        return stringBuffer.toString();
    }
}

