/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.netClient;

import com.topcoder.client.netClient.Client;
import com.topcoder.client.netClient.ResponseWaiterManager;
import com.topcoder.netCommon.contestantMessages.response.EndSyncResponse;
import com.topcoder.netCommon.contestantMessages.response.KeepAliveInitializationDataResponse;
import com.topcoder.netCommon.contestantMessages.response.StartSyncResponse;
import com.topcoder.netCommon.contestantMessages.response.UnsynchronizeResponse;

public class NetMessageProcessor {
    private Client client;
    private ResponseWaiterManager waiterManager;

    public NetMessageProcessor(Client client, ResponseWaiterManager responseWaiterManager) {
        this.client = client;
        this.waiterManager = responseWaiterManager;
    }

    public boolean processIncomingMessage(Object object) {
        if (object instanceof UnsynchronizeResponse) {
            this.waiterManager.unblock(((UnsynchronizeResponse)object).getID());
        } else if (object instanceof StartSyncResponse) {
            this.waiterManager.startOfSyncResponse(((StartSyncResponse)object).getRequestId());
        } else if (object instanceof EndSyncResponse) {
            this.waiterManager.endOfSyncResponse(((EndSyncResponse)object).getRequestId());
        } else if (object instanceof KeepAliveInitializationDataResponse) {
            KeepAliveInitializationDataResponse keepAliveInitializationDataResponse = (KeepAliveInitializationDataResponse)object;
            this.client.updateKeepAliveParameters(keepAliveInitializationDataResponse.getTimeout(), keepAliveInitializationDataResponse.getHttpTimeout());
        } else {
            return false;
        }
        return true;
    }
}

