/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.netClient;

import com.topcoder.client.contestant.message.MessageProcessor;
import com.topcoder.client.netClient.Client;
import com.topcoder.client.netClient.NetMessageProcessor;
import com.topcoder.netCommon.contestantMessages.response.BaseResponse;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class ContestResponseHandler
extends Thread {
    private final Client client;
    private NetMessageProcessor netProcessor;
    private final MessageProcessor gui;
    private final DispatchThread dispatchThread = new DispatchThread();
    private volatile boolean keepGoing = true;

    ContestResponseHandler(Client client, NetMessageProcessor netMessageProcessor, MessageProcessor messageProcessor) {
        super("ContestResponseHandler");
        this.client = client;
        this.netProcessor = netMessageProcessor;
        this.gui = messageProcessor;
    }

    public void run() {
        boolean bl = false;
        while (this.keepGoing) {
            try {
                Object object = this.client.readObject();
                this.dispatchThread.processNewResponses(object);
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (SocketException socketException) {
                this.debug("connection lost:", socketException);
                bl = true;
                break;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                streamCorruptedException.printStackTrace();
            }
            catch (EOFException eOFException) {
                this.debug("connection lost:", eOFException);
                bl = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                if (iOException.getMessage() != null && (iOException.getMessage().toLowerCase().indexOf("stream closed") > -1 || iOException.getMessage().toLowerCase().indexOf("stream is closed") > -1 || iOException.getMessage().toLowerCase().indexOf("premature eof") > -1)) {
                    this.debug("connection lost:", iOException);
                    bl = true;
                    break;
                }
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.keepGoing && bl) {
            this.gui.lostConnection();
        }
    }

    void close() {
        this.keepGoing = false;
        this.dispatchThread.stopRunning();
    }

    void debug(String string, Object object) {
    }

    private class DispatchThread
    extends Thread {
        private final Object lock = new Object();
        private final List responseQueue = Collections.synchronizedList(new ArrayList());
        private boolean keepGoing = true;

        private DispatchThread() {
            super("DispatchThread");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                while (this.keepGoing) {
                    if (this.responseQueue.size() == 0) {
                        try {
                            this.lock.wait(1000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    while (this.responseQueue.size() > 0) {
                        try {
                            Object e = this.responseQueue.remove(0);
                            if (e instanceof List) {
                                List list = (List)e;
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    this.processResponse(iterator.next());
                                }
                                continue;
                            }
                            this.processResponse(e);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        }

        private void processResponse(Object object) {
            ContestResponseHandler.this.debug("received: ", object);
            if (!ContestResponseHandler.this.netProcessor.processIncomingMessage(object)) {
                ContestResponseHandler.this.gui.receive((BaseResponse)object);
            }
        }

        private void processNewResponses(Object object) {
            this.responseQueue.add(object);
            this.notifyIt();
        }

        private void stopRunning() {
            this.keepGoing = false;
            this.notifyIt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIt() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }
}

