/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.impl.CoderComponentImpl;
import com.topcoder.client.contestant.impl.CoderImpl;
import com.topcoder.client.contestant.impl.LongCoderComponentImpl;
import com.topcoder.client.contestant.impl.ProblemComponentModelImpl;
import com.topcoder.client.contestant.message.Requester;
import com.topcoder.client.contestant.view.AssignmentView;
import com.topcoder.client.contestant.view.ChallengeView;
import com.topcoder.client.contestant.view.ChatView;
import com.topcoder.client.contestant.view.CodingView;
import com.topcoder.client.contestant.view.EventService;
import com.topcoder.client.contestant.view.LeaderListener;
import com.topcoder.client.contestant.view.RoomView;
import com.topcoder.client.contestant.view.UserListListener;
import com.topcoder.netCommon.contest.ContestConstants;
import com.topcoder.netCommon.contestantMessages.response.data.CoderComponentItem;
import com.topcoder.netCommon.contestantMessages.response.data.CoderItem;
import com.topcoder.netCommon.contestantMessages.response.data.LeaderboardItem;
import com.topcoder.netCommon.contestantMessages.response.data.LongCoderComponentItem;
import com.topcoder.netCommon.contestantMessages.response.data.LongCoderItem;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import com.topcoder.shared.problem.DataType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

class RoomModelImpl
implements RoomModel {
    private EventService eventService;
    private RoomView currentRoomView;
    private RoomView watchView;
    private RoundModel roundModel;
    protected Requester requester;
    private Long roomID;
    private Integer roomType;
    private Integer roomNumber;
    private String name = "";
    private String status = "";
    private LeaderboardItem leader;
    private Integer divisionID;
    private CoderImpl[] coders;
    private Set users = new HashSet();
    private Vector leaderListeners = new Vector();
    private Vector challengeViews = new Vector();
    private Vector userListViews = new Vector();
    private Vector chatViews = new Vector();
    private Vector codingViews = new Vector();
    private Vector assignmentViews = new Vector();
    private Vector availableListViews = new Vector();
    private Vector memberListViews = new Vector();

    public RoomView getCurrentRoomView() {
        return this.currentRoomView;
    }

    public RoomView getWatchView() {
        return this.watchView;
    }

    public boolean hasWatchView() {
        return this.watchView != null;
    }

    protected RoomModelImpl(RoundModel roundModel, Requester requester, long l, int n, EventService eventService) {
        this.roundModel = roundModel;
        this.requester = requester;
        this.roomID = new Long(l);
        this.roomType = new Integer(n);
        this.eventService = eventService;
    }

    public void setCurrentRoomView(RoomView roomView) {
        this.currentRoomView = roomView;
        roomView.setModel(this);
    }

    public void unsetCurrentRoomView() {
        this.currentRoomView = null;
        if (this.watchView == null && this.challengeViews.size() == 0) {
            this.freeResources();
        }
    }

    public void setWatchView(RoomView roomView) {
        this.watchView = roomView;
        roomView.setModel(this);
    }

    public void unsetWatchView() {
        this.watchView = null;
        if (this.currentRoomView == null && this.challengeViews.size() == 0) {
            this.freeResources();
        }
    }

    private void freeResources() {
        this.coders = null;
        this.users.clear();
    }

    public Long getRoomID() {
        return this.roomID;
    }

    public Integer getType() {
        return this.roomType;
    }

    public Integer getRoomNumber() {
        return this.roomNumber;
    }

    void setRoomNumber(int n) {
        this.roomNumber = new Integer(n);
    }

    public Integer getDivisionID() {
        return this.divisionID;
    }

    void setDivisionID(int n) {
        this.divisionID = new Integer(n);
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    void setName(String string) {
        this.name = string;
    }

    void setStatus(String string) {
        this.status = string;
    }

    public boolean hasLeader() {
        return this.leader != null;
    }

    public LeaderboardItem getLeader() {
        return this.leader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeaderListener(LeaderListener leaderListener) {
        Vector vector = this.leaderListeners;
        synchronized (vector) {
            if (!this.leaderListeners.contains(leaderListener)) {
                this.leaderListeners.add(leaderListener);
            }
        }
    }

    public void removeLeaderListener(LeaderListener leaderListener) {
        this.leaderListeners.remove(leaderListener);
    }

    void setLeader(LeaderboardItem leaderboardItem) {
        this.leader = leaderboardItem;
        this.notifyLeaderListeners();
    }

    private void notifyLeaderListeners() {
        this.eventService.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Vector vector = RoomModelImpl.this.leaderListeners;
                synchronized (vector) {
                    Iterator iterator = RoomModelImpl.this.leaderListeners.iterator();
                    while (iterator.hasNext()) {
                        LeaderListener leaderListener = (LeaderListener)iterator.next();
                        leaderListener.updateLeader(RoomModelImpl.this);
                    }
                }
            }
        });
    }

    void enter() {
        this.requester.requestEnter(-1L);
    }

    public RoundModel getRoundModel() {
        return this.roundModel;
    }

    public boolean hasRoundModel() {
        return this.roundModel != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChallengeView(ChallengeView challengeView) {
        Vector vector = this.challengeViews;
        synchronized (vector) {
            this.challengeViews.add(challengeView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChallengeView(ChallengeView challengeView) {
        Vector vector = this.challengeViews;
        synchronized (vector) {
            this.challengeViews.remove(challengeView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyChallengeViews() {
        Vector vector = this.challengeViews;
        synchronized (vector) {
            Iterator iterator = this.challengeViews.iterator();
            while (iterator.hasNext()) {
                ((ChallengeView)iterator.next()).updateChallengeTable(this);
            }
        }
    }

    public void addUserListView(UserListListener userListListener) {
        this.userListViews.add(userListListener);
    }

    public void removeUserListView(UserListListener userListListener) {
        this.userListViews.remove(userListListener);
    }

    public synchronized UserListItem[] getUsers() {
        return this.getUsersArray();
    }

    private UserListItem[] getUsersArray() {
        return this.users.toArray(new UserListItem[this.users.size()]);
    }

    synchronized void setUserList(UserListItem[] userListItemArray) {
        this.users.clear();
        for (int i = 0; i < userListItemArray.length; ++i) {
            this.users.add(userListItemArray[i]);
        }
        Iterator iterator = this.userListViews.iterator();
        while (iterator.hasNext()) {
            ((UserListListener)iterator.next()).updateUserList(userListItemArray);
        }
    }

    synchronized void addToUserList(UserListItem userListItem) {
        this.users.add(userListItem);
        Iterator iterator = this.userListViews.iterator();
        while (iterator.hasNext()) {
            ((UserListListener)iterator.next()).updateUserList(this.getUsersArray());
        }
    }

    void removeFromUserList(UserListItem userListItem) {
        if (this.users.contains(userListItem)) {
            this.users.remove(userListItem);
            Iterator iterator = this.userListViews.iterator();
            while (iterator.hasNext()) {
                ((UserListListener)iterator.next()).updateUserList(this.getUsersArray());
            }
        }
    }

    public void addChatView(ChatView chatView) {
        this.chatViews.add(chatView);
    }

    public void removeChatView(ChatView chatView) {
        this.chatViews.remove(chatView);
    }

    void updateChatRoom(String string, int n, String string2, int n2) {
        Iterator iterator = this.chatViews.iterator();
        while (iterator.hasNext()) {
            ((ChatView)iterator.next()).updateChat(string, n, string2, n2);
        }
    }

    void updateChatRoom(int n, String string, int n2) {
        Iterator iterator = this.chatViews.iterator();
        while (iterator.hasNext()) {
            ((ChatView)iterator.next()).updateChat(n, string, n2);
        }
    }

    public void addCodingView(CodingView codingView) {
        this.codingViews.add(codingView);
    }

    public void removeCodingView(CodingView codingView) {
        this.codingViews.remove(codingView);
    }

    void updateTestInfo(DataType[] dataTypeArray, int n) {
        Iterator iterator = this.codingViews.iterator();
        while (iterator.hasNext()) {
            ((CodingView)iterator.next()).setTestInfo(dataTypeArray, n);
        }
    }

    public void addAssignmentView(AssignmentView assignmentView) {
        this.assignmentViews.add(assignmentView);
    }

    public void removeAssignmentView(AssignmentView assignmentView) {
        this.assignmentViews.remove(assignmentView);
    }

    void addToAvailableList(UserListItem[] userListItemArray) {
    }

    void addToAvailableList(UserListItem userListItem) {
    }

    void removeFromAvailableList(UserListItem userListItem) {
    }

    void addToMemberList(UserListItem[] userListItemArray) {
    }

    void addToMemberList(UserListItem userListItem) {
    }

    void removeFromMemberList(UserListItem userListItem) {
    }

    public boolean hasCoders() {
        return this.coders != null;
    }

    public Coder[] getCoders() {
        return this.coders;
    }

    private synchronized CoderComponentImpl[] createComponents(CoderComponentItem[] coderComponentItemArray, Coder coder) {
        CoderComponentImpl[] coderComponentImplArray = new CoderComponentImpl[coderComponentItemArray.length];
        for (int i = 0; i < coderComponentItemArray.length; ++i) {
            CoderComponentItem coderComponentItem = coderComponentItemArray[i];
            coderComponentImplArray[i] = this.roundModel.getRoundType().isLongRound() ? this.newLongCoderComponent(coder, coderComponentItem) : new CoderComponentImpl((ProblemComponentModelImpl)this.roundModel.getComponent(this.divisionID, coderComponentItem.getComponentID()), coderComponentItem.getLanguage(), coderComponentItem.getPoints(), coderComponentItem.getStatus(), coder, coderComponentItem.getPassedSystemTest(), this.eventService);
        }
        return coderComponentImplArray;
    }

    private LongCoderComponentImpl newLongCoderComponent(Coder coder, CoderComponentItem coderComponentItem) {
        if (coderComponentItem instanceof LongCoderComponentItem) {
            LongCoderComponentItem longCoderComponentItem = (LongCoderComponentItem)coderComponentItem;
            return new LongCoderComponentImpl((ProblemComponentModelImpl)this.roundModel.getComponent(this.divisionID, longCoderComponentItem.getComponentID()), longCoderComponentItem.getLanguage(), longCoderComponentItem.getPoints(), longCoderComponentItem.getStatus(), coder, this.eventService, longCoderComponentItem.getSubmissionCount(), longCoderComponentItem.getLastSubmissionTime(), longCoderComponentItem.getExampleSubmissionCount(), longCoderComponentItem.getExampleLastSubmissionTime(), longCoderComponentItem.getExampleLastLanguage());
        }
        return new LongCoderComponentImpl((ProblemComponentModelImpl)this.roundModel.getComponent(this.divisionID, coderComponentItem.getComponentID()), coderComponentItem.getLanguage(), coderComponentItem.getPoints(), coderComponentItem.getStatus(), coder, this.eventService);
    }

    synchronized void updateChallengeTable(CoderItem[] coderItemArray) {
        CoderImpl[] coderImplArray = new CoderImpl[coderItemArray.length];
        for (int i = 0; i < coderItemArray.length; ++i) {
            CoderItem coderItem = coderItemArray[i];
            if (this.isAssigned(coderItem.getUserName())) {
                CoderImpl coderImpl = this.getCoderImpl(coderItem.getUserName());
                CoderComponentItem[] coderComponentItemArray = coderItem.getComponents();
                for (int j = 0; j < coderComponentItemArray.length; ++j) {
                    CoderComponentItem coderComponentItem = coderComponentItemArray[j];
                    coderImpl.updateComponentFromTable(coderComponentItem);
                }
                coderImpl.setScoreFromTable(coderItem.getTotalPoints());
                coderImplArray[i] = coderImpl;
            } else {
                coderImplArray[i] = this.createCoder(coderItem, coderItem.getComponents());
            }
            if (!(coderItem instanceof LongCoderItem)) continue;
            coderImplArray[i].setFinalScore(((LongCoderItem)coderItem).getFinalPoints());
        }
        this.coders = coderImplArray;
        if (ContestConstants.isPracticeRoomType(this.roomType)) {
            this.updatePracticeRoomLeader();
        }
        this.notifyChallengeViews();
    }

    private CoderImpl createCoder(CoderItem coderItem, CoderComponentItem[] coderComponentItemArray) {
        CoderImpl coderImpl = new CoderImpl(coderItem.getUserName(), coderItem.getUserRating(), coderItem.getTotalPoints(), coderItem.getUserType(), coderItem.getMemberNames());
        CoderComponentImpl[] coderComponentImplArray = this.createComponents(coderComponentItemArray, coderImpl);
        coderImpl.setComponents(coderComponentImplArray);
        return coderImpl;
    }

    synchronized void updateCoderComponent(String string, CoderComponentItem coderComponentItem) {
        CoderImpl coderImpl = this.getCoderImpl(string);
        coderImpl.updateComponent(coderComponentItem);
        if (ContestConstants.isPracticeRoomType(this.roomType)) {
            this.updatePracticeRoomLeader();
        }
    }

    public Coder getCoder(String string) {
        return this.getCoderImpl(string);
    }

    synchronized CoderImpl getCoderImpl(String string) {
        if (this.coders == null) {
            return null;
        }
        for (int i = 0; i < this.coders.length; ++i) {
            CoderImpl coderImpl = this.coders[i];
            if (!coderImpl.getHandle().equals(string)) continue;
            return coderImpl;
        }
        return null;
    }

    synchronized void updateCoderPoints(String string, double d) {
        CoderImpl coderImpl = this.getCoderImpl(string);
        coderImpl.setScore(d);
        if (ContestConstants.isPracticeRoomType(this.roomType)) {
            this.updatePracticeRoomLeader();
        }
    }

    private synchronized void updatePracticeRoomLeader() {
        if (this.hasCoders() && this.coders.length > 0) {
            CoderImpl[] coderImplArray = (CoderImpl[])this.coders.clone();
            Arrays.sort(coderImplArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Coder coder = (Coder)object;
                    Coder coder2 = (Coder)object2;
                    if (coder.getScore().equals(coder2.getScore())) {
                        return -coder.getRating().compareTo(coder2.getRating());
                    }
                    return -coder.getScore().compareTo(coder2.getScore());
                }
            });
            CoderImpl coderImpl = coderImplArray[0];
            this.setLeader(new LeaderboardItem(this.roomID, coderImpl.getHandle(), coderImpl.getRating(), 1, coderImpl.getScore(), false));
        }
    }

    public synchronized boolean isAssigned(String string) {
        if (this.hasCoders()) {
            for (int i = 0; i < this.coders.length; ++i) {
                CoderImpl coderImpl = this.coders[i];
                if (coderImpl.getHandle().equals(string)) {
                    return true;
                }
                if (coderImpl.getMemberNames() == null || !coderImpl.getMemberNames().contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPracticeRoom() {
        return ContestConstants.isPracticeRoomType(this.roomType);
    }
}

