/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.BroadcastManager;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.InterceptorManager;
import com.topcoder.client.contestant.LoginException;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoomViewManagerManager;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.RoundViewManager;
import com.topcoder.client.contestant.TimeOutException;
import com.topcoder.client.contestant.impl.AutoDetectConnectionTask;
import com.topcoder.client.contestant.impl.ConnectionType;
import com.topcoder.client.contestant.impl.LoggingInterceptor;
import com.topcoder.client.contestant.impl.MessageProcessorImpl;
import com.topcoder.client.contestant.impl.RequesterImpl;
import com.topcoder.client.contestant.impl.ResponseProcessorImpl;
import com.topcoder.client.contestant.impl.RoomModelImpl;
import com.topcoder.client.contestant.impl.RoundModelImpl;
import com.topcoder.client.contestant.message.MessageProcessor;
import com.topcoder.client.contestant.message.Requester;
import com.topcoder.client.contestant.message.ResponseProcessor;
import com.topcoder.client.contestant.view.ContestantView;
import com.topcoder.client.contestant.view.EventService;
import com.topcoder.client.contestant.view.HeartbeatListener;
import com.topcoder.client.contestant.view.MenuView;
import com.topcoder.client.contestant.view.RoomViewManager;
import com.topcoder.client.contestant.view.TeamListView;
import com.topcoder.client.contestant.view.UserListListener;
import com.topcoder.netCommon.contest.ComponentAssignmentData;
import com.topcoder.netCommon.contestantMessages.UserInfo;
import com.topcoder.netCommon.contestantMessages.response.data.CategoryData;
import com.topcoder.netCommon.contestantMessages.response.data.RoomData;
import com.topcoder.netCommon.contestantMessages.response.data.RoundData;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ContestantImpl
implements Contestant {
    private ComponentAssignmentData componentAssignmentData;
    private EventService eventService;
    private Requester requester;
    private ResponseProcessor responseProcessor;
    private MessageProcessor messageProcessor = null;
    private ContestantView view;
    private UserListListener activeUsersView;
    private UserListListener registeredUsersView;
    private UserListListener hsRegisteredUsersView;
    private UserListListener mmRegisteredUsersView;
    private MenuView menuView;
    private final BroadcastManager broadcastManager = new BroadcastManager(this);
    private final RoundViewManager roundViewManager = new RoundViewManager(this);
    private UserInfo userInfo = new UserInfo();
    private TeamListView teamListView;
    private CategoryData[] roundCategories;
    private final Map activeRoundsMap = new HashMap();
    private final Map practiceRoundsMap = new HashMap();
    private final List activeRoundsList = new LinkedList();
    private final List practiceRoundsList = new LinkedList();
    private final Map roomMap = new HashMap();
    private final InterceptorManager interceptorManager = new InterceptorManager();
    private final RoomViewManagerManager roomViewManagerManager = new RoomViewManagerManager();
    private final int TICK_DELAY = 500;
    private final List heartbeatListeners = new LinkedList();
    private boolean verified = false;
    private final Thread heartbeatThread = new Thread(){
        private long prevTick = -1L;
        private long prevSynch = -1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setName("Heartbeat");
            while (true) {
                List list = ContestantImpl.this.heartbeatListeners;
                synchronized (list) {
                    Iterator iterator = ContestantImpl.this.heartbeatListeners.iterator();
                    while (iterator.hasNext()) {
                        WeakReference weakReference = (WeakReference)iterator.next();
                        HeartbeatListener heartbeatListener = (HeartbeatListener)weakReference.get();
                        if (heartbeatListener == null) {
                            iterator.remove();
                            continue;
                        }
                        try {
                            heartbeatListener.tick();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                try {
                    long l = System.currentTimeMillis();
                    long l2 = l - this.prevTick;
                    if (l2 < 0L || l2 > 1000L) {
                        if (Math.abs(l - this.prevSynch) > 15000L) {
                            ContestantImpl.this.getRequester().requestSynchTime(ContestantImpl.this.getConnectionID());
                            this.prevSynch = l;
                        } else {
                            1.sleep(500L);
                        }
                    } else if (l2 > 500L) {
                        1.sleep(Math.max(0L, 1000L - l2));
                    } else {
                        1.sleep(500L);
                    }
                    this.prevTick = l;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    };
    private final Object serverTimeLock = new Object();
    private long serverTimeOffset;
    private long connectionID = 0L;
    private String hashCode = "";
    private boolean loggedIn = false;
    private ConnectionType connectionType = null;
    private String tunnelLocation;
    private boolean goThroughProxy = false;
    private ReconnectThread reconnectThread = null;
    private Object reconnectThreadMutex = new Object();
    private String currentAppletVersion = "";
    private String[] valid = new String[]{"com.topcoder.client.", "java.", "javax."};
    private byte[] verifyCode;
    private boolean verifySuccess = false;
    private RoomModelImpl currentRoom;
    private AutoDetectConnectionTask autoConnectTask;
    static /* synthetic */ Class class$java$lang$Thread;

    public Requester getRequester() {
        return this.requester;
    }

    public ContestantView getView() {
        return this.view;
    }

    public UserListListener getActiveUsersView() {
        return this.activeUsersView;
    }

    public MenuView getMenuView() {
        return this.menuView;
    }

    public TeamListView getTeamListView() {
        return this.teamListView;
    }

    public UserListListener getRegisteredUsersView() {
        return this.registeredUsersView;
    }

    public UserListListener getHSRegisteredUsersView() {
        return this.hsRegisteredUsersView;
    }

    public UserListListener getLongRoundRegisteredUsersView() {
        return this.mmRegisteredUsersView;
    }

    public RoundViewManager getRoundViewManager() {
        return this.roundViewManager;
    }

    void setConnectionID(long l) {
        this.connectionID = l;
    }

    void setHashCode(String string) {
        this.hashCode = string;
        this.endReconnectAttempt();
    }

    public long getConnectionID() {
        return this.connectionID;
    }

    public String getHashCode() {
        return this.hashCode;
    }

    void setLoggedIn(boolean bl) {
        this.loggedIn = bl;
    }

    public ContestantImpl() {
        if (Boolean.getBoolean("com.topcoder.message.LoggingInterceptor")) {
            this.interceptorManager.addInterceptor(new LoggingInterceptor());
        }
    }

    public void init(String string, int n, String string2, ContestantView contestantView, UserListListener userListListener, UserListListener userListListener2, UserListListener userListListener3, UserListListener userListListener4, TeamListView teamListView, UserListListener userListListener5, UserListListener userListListener6, MenuView menuView, RoomViewManager roomViewManager, EventService eventService, String string3) {
        this.eventService = eventService;
        this.view = contestantView;
        this.teamListView = teamListView;
        this.menuView = menuView;
        this.activeUsersView = userListListener;
        this.registeredUsersView = userListListener2;
        this.hsRegisteredUsersView = userListListener3;
        this.mmRegisteredUsersView = userListListener4;
        this.roomViewManagerManager.addListener(roomViewManager);
        this.requester = new RequesterImpl();
        this.requester.setInterceptorManager(this.interceptorManager);
        this.responseProcessor = new ResponseProcessorImpl(this);
        this.processTunnelLocation(string2);
        this.messageProcessor = new MessageProcessorImpl(string, n, this.tunnelLocation, this.view, this.responseProcessor, string3, this.interceptorManager);
        this.serverTimeOffset = 0L;
        this.heartbeatThread.setDaemon(true);
        this.heartbeatThread.start();
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    private void processTunnelLocation(String string) {
        this.tunnelLocation = string;
        char[] cArray = this.tunnelLocation.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '~') {
                cArray[i] = 61;
            }
            if (cArray[i] != '+') continue;
            cArray[i] = 38;
        }
        this.tunnelLocation = new String(cArray);
    }

    public void setConnectionType(ConnectionType connectionType) {
        if (this.connectionType != null) {
            this.connectionType.unselect();
        }
        this.connectionType = connectionType;
        connectionType.select();
    }

    public void setGoThroughProxy(boolean bl) {
        this.goThroughProxy = bl;
    }

    public void loginWithBadgeId(String string, String string2, String string3) throws LoginException {
        this.login(string, string2, null, string3);
    }

    public void login(String string, char[] cArray, String string2) throws LoginException {
        this.login(string.trim(), new String(cArray).trim(), string2, null);
    }

    private void login(String string, String string2, String string3, String string4) throws LoginException {
        this.login(string, string2, string3, string4, null, null, null, "", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReconnectAttempt() {
        Object object = this.reconnectThreadMutex;
        synchronized (object) {
            if (this.reconnectThread == null) {
                this.reconnectThread = new ReconnectThread();
                this.reconnectThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReconnectAttempt() {
        Object object = this.reconnectThreadMutex;
        synchronized (object) {
            if (this.reconnectThread != null) {
                this.reconnectThread.stopRunning();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReconnectThread() {
        Object object = this.reconnectThreadMutex;
        synchronized (object) {
            this.reconnectThread = null;
        }
    }

    public String getCurrentAppletVersion() {
        return this.executeGetCurrentAppletVersion(this.connectionType);
    }

    String executeGetCurrentAppletVersion(ConnectionType connectionType) {
        if (this.openConnection(connectionType)) {
            this.requester.setClient(this.messageProcessor.getClient());
            try {
                this.requester.requestCurrentAppletVersion();
            }
            catch (Exception exception) {
                return "";
            }
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (this.isValid(stackTraceElementArray[i].getClassName())) continue;
                throw new RuntimeException("Integrity Check Failed: " + stackTraceElementArray[i].getClassName());
            }
            return this.currentAppletVersion;
        }
        return "";
    }

    boolean openConnection(ConnectionType connectionType) {
        return this.messageProcessor.openConnection(connectionType.isTunneled(), this.goThroughProxy);
    }

    public ConnectionType autoDetectConnectionType(Contestant.StatusListener statusListener) {
        this.autoConnectTask = new AutoDetectConnectionTask(this, statusListener);
        ConnectionType connectionType = this.autoConnectTask.autoDetect();
        if (connectionType != null) {
            this.setConnectionType(connectionType);
        }
        this.autoConnectTask = null;
        return connectionType;
    }

    public void cancelAutoDetectConnectionType() {
        AutoDetectConnectionTask autoDetectConnectionTask = this.autoConnectTask;
        if (autoDetectConnectionTask != null) {
            autoDetectConnectionTask.cancel();
        }
        this.autoConnectTask = null;
    }

    private boolean isValid(String string) {
        for (int i = 0; i < this.valid.length; ++i) {
            if (!string.startsWith(this.valid[i])) continue;
            return true;
        }
        return false;
    }

    public void setVerifyCode(byte[] byArray) {
        this.verifyCode = byArray;
    }

    public void setVerifyResult(boolean bl) {
        this.verifySuccess = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws LoginException {
        if (this.openConnection(this.connectionType)) {
            this.requester.setClient(this.messageProcessor.getClient());
            this.userInfo.setHandle(string);
            try {
                if (!this.verified) {
                    GenericDeclaration genericDeclaration;
                    Object object;
                    this.verified = true;
                    this.requester.requestVerify();
                    int n = 0;
                    if (this.verifyCode != null) {
                        object = new MemoryClassLoader(this.getClass().getClassLoader());
                        genericDeclaration = ((MemoryClassLoader)object).loadClass("com.topcoder.temporary.Verify", this.verifyCode);
                        try {
                            n = (Integer)((Class)genericDeclaration).getMethod("verify", null).invoke(null, null);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            this.requester.requestErrorReport(exception);
                        }
                        finally {
                            long l;
                            object = null;
                            genericDeclaration = null;
                            long l2 = Runtime.getRuntime().freeMemory();
                            do {
                                Thread.yield();
                                l = l2;
                                Runtime.getRuntime().gc();
                            } while ((l2 = Runtime.getRuntime().freeMemory()) > l);
                        }
                    }
                    this.requester.requestVerifyResult(n);
                    if (!this.verifySuccess) {
                        object = class$java$lang$Thread == null ? (class$java$lang$Thread = ContestantImpl.class$("java.lang.Thread")) : class$java$lang$Thread;
                        try {
                            genericDeclaration = ((Class)object).getMethod("getAllStackTraces", null);
                            Map map = (Map)((Method)genericDeclaration).invoke(null, null);
                            byte[] byArray = new byte[]{48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -79, 83, 120, -20, -4, 101, 40, 47, -7, 86, 32, -72, 54, -95, -18, -114, -77, 109, -116, 29, -17, 57, 64, -30, -94, 80, 34, -60, 97, 104, 69, -40, -120, -109, -27, -41, -62, -97, -70, -83, 66, -31, -54, -81, -44, -73, -40, -75, -2, 2, -128, -80, 38, 109, -83, -79, 8, -22, 39, -50, -8, 116, 96, 115, -64, -15, -28, 82, 95, 20, 109, -55, -110, -100, -93, -59, -125, -23, 32, -121, 39, -104, -68, -124, -27, -57, 103, -30, 105, 98, 54, 105, -98, 50, -15, -66, -90, -20, 69, -118, -63, -37, -118, 88, 47, 59, 91, -127, -17, -105, -122, 20, -35, -36, 4, 7, -52, 124, -60, 22, 30, -112, -109, -56, 118, 80, 28, -67, 2, 3, 1, 0, 1};
                            boolean bl = false;
                            Iterator iterator = map.entrySet().iterator();
                            block13: while (iterator.hasNext() && !bl) {
                                Map.Entry entry = iterator.next();
                                Thread thread = (Thread)entry.getKey();
                                StackTraceElement[] stackTraceElementArray = (StackTraceElement[])entry.getValue();
                                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                                    Class<?> clazz;
                                    try {
                                        clazz = Class.forName(stackTraceElementArray[i].getClassName(), false, thread.getContextClassLoader());
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        continue;
                                    }
                                    if (clazz.getProtectionDomain() == null || clazz.getProtectionDomain().getCodeSource() == null || clazz.getSigners() != null && Arrays.equals(byArray, ((Certificate)clazz.getSigners()[0]).getPublicKey().getEncoded())) continue;
                                    Exception exception = new Exception();
                                    exception.setStackTrace(stackTraceElementArray);
                                    this.requester.requestErrorReport(exception);
                                    bl = true;
                                    continue block13;
                                }
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            this.requester.requestErrorReport(new Exception());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.view.loadPlugins();
                }
                String string10 = string3 == null || string3.length() == 0 ? null : string3;
                this.requester.requestLogin(string, string2, string10, string4, string5, string6, string7, string8, string9);
            }
            catch (TimeOutException timeOutException) {
                timeOutException.printStackTrace();
                throw new LoginException("Your login request timed out.");
            }
        }
        throw new LoginException("A connection to the server could not be established.");
    }

    public void logoff() {
        this.view.loggingOff();
        if (this.loggedIn) {
            this.requester.requestLogoff();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.reset();
    }

    public void reset() {
        this.loggedIn = false;
        this.endReconnectAttempt();
        this.roundViewManager.clearRoundList();
        this.broadcastManager.clearBroadcasts();
        this.closeConnection();
        this.userInfo.clear();
        this.activeRoundsList.clear();
        this.activeRoundsMap.clear();
        this.practiceRoundsList.clear();
        this.practiceRoundsMap.clear();
        this.clearRooms();
    }

    public String getCurrentUser() {
        if (this.userInfo != null) {
            return this.userInfo.getHandle();
        }
        return "";
    }

    public String getCurrentTeam() {
        if (this.userInfo != null) {
            return this.userInfo.getTeam();
        }
        return "";
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public BroadcastManager getBroadcastManager() {
        return this.broadcastManager;
    }

    void closeConnection() {
        this.messageProcessor.closeConnection();
        this.requester.setClient(null);
    }

    RoomModelImpl getCurrentRoomImpl() {
        return this.currentRoom;
    }

    public RoomModel getCurrentRoom() {
        return this.currentRoom;
    }

    public void reconnectFailed() {
        this.messageProcessor.closeConnection();
        this.endReconnectAttempt();
    }

    public void move(int n, long l) throws TimeOutException {
        if (n == 7) {
            this.requester.requestEnterRound(l);
        } else {
            this.requester.requestMove(n, l);
        }
    }

    public RoomModel watch(long l) throws TimeOutException {
        this.requester.requestWatch(l);
        RoomModel roomModel = this.getRoom(l);
        return roomModel;
    }

    RoundModelImpl getRoundModel(long l) {
        Long l2 = new Long(l);
        if (this.activeRoundsMap.containsKey(l2)) {
            return (RoundModelImpl)this.activeRoundsMap.get(l2);
        }
        if (this.practiceRoundsMap.containsKey(l2)) {
            return (RoundModelImpl)this.practiceRoundsMap.get(l2);
        }
        throw new IllegalArgumentException("Invalid roundID: " + l);
    }

    public RoundModel getRound(long l) {
        return this.getRoundModel(l);
    }

    void roomInfo(int n, long l, String string, String string2) {
        RoomModelImpl roomModelImpl = (RoomModelImpl)this.getRoom(l);
        if (string.length() > 0) {
            roomModelImpl.setName(string);
        }
        if (string2.length() > 0) {
            roomModelImpl.setStatus(string2);
        }
        if (n != 6) {
            this.currentRoom = roomModelImpl;
            this.roomViewManagerManager.setCurrentRoom(roomModelImpl);
            roomModelImpl.enter();
        }
    }

    public void unwatch(long l) {
        this.requester.requestUnwatch(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeartbeatListener(HeartbeatListener heartbeatListener) {
        List list = this.heartbeatListeners;
        synchronized (list) {
            this.removeHeartbeatListener(heartbeatListener);
            this.heartbeatListeners.add(new WeakReference<HeartbeatListener>(heartbeatListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeartbeatListener(HeartbeatListener heartbeatListener) {
        if (heartbeatListener == null) {
            return;
        }
        List list = this.heartbeatListeners;
        synchronized (list) {
            Iterator iterator = this.heartbeatListeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                HeartbeatListener heartbeatListener2 = (HeartbeatListener)weakReference.get();
                if (heartbeatListener2 == null) {
                    iterator.remove();
                }
                if (!heartbeatListener.equals(heartbeatListener2)) continue;
                iterator.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getServerTime() {
        Object object = this.serverTimeLock;
        synchronized (object) {
            return System.currentTimeMillis() + this.serverTimeOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateServerTime(long l) {
        Object object = this.serverTimeLock;
        synchronized (object) {
            this.serverTimeOffset = l - System.currentTimeMillis();
        }
    }

    synchronized void setActiveRounds(RoundData[] roundDataArray) {
        this.activeRoundsList.clear();
        this.activeRoundsMap.clear();
        for (int i = 0; i < roundDataArray.length; ++i) {
            this.addRound(roundDataArray[i]);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ContestantImpl.this.roundViewManager.updateActiveRoundList();
            }
        };
        this.eventService.invokeLater(runnable);
    }

    synchronized void setPracticeRounds(RoundData[] roundDataArray) {
        this.practiceRoundsList.clear();
        this.practiceRoundsMap.clear();
        for (int i = 0; i < roundDataArray.length; ++i) {
            this.addRound(roundDataArray[i]);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ContestantImpl.this.menuView.updatePracticeRounds(ContestantImpl.this);
            }
        };
        this.eventService.invokeLater(runnable);
    }

    synchronized void setRoundCategories(CategoryData[] categoryDataArray) {
        this.roundCategories = categoryDataArray;
    }

    synchronized void newRound(RoundData roundData) {
        this.addRound(roundData);
        Runnable runnable = new Runnable(){

            public void run() {
                ContestantImpl.this.roundViewManager.updateActiveRoundList();
            }
        };
        this.eventService.invokeLater(runnable);
    }

    private synchronized void addRound(RoundData roundData) {
        Long l = new Long(roundData.getRoundID());
        if (!this.activeRoundsMap.containsKey(l)) {
            RoundModelImpl roundModelImpl = new RoundModelImpl(this, roundData.getRoundID(), roundData.getContestName(), roundData.getRoundName(), roundData.getRoundType(), roundData.getPhaseData(), roundData.getRoundCategoryID(), roundData.getCustomProperties());
            roundModelImpl.setMenuStatus(roundData.isEnabled());
            switch (roundData.getRoundType()) {
                case -2: 
                case -1: 
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    this.activeRoundsList.add(roundModelImpl);
                    this.activeRoundsMap.put(l, roundModelImpl);
                    this.sortRoundList();
                    break;
                }
                case 3: 
                case 9: 
                case 14: 
                case 23: {
                    this.practiceRoundsList.add(roundModelImpl);
                    this.practiceRoundsMap.put(l, roundModelImpl);
                    RoomModelImpl roomModelImpl = new RoomModelImpl(roundModelImpl, this.requester, roundData.getPracticeRoomID(), roundModelImpl.getRoundType().isTeamRound() ? 10 : 4, this.eventService);
                    roomModelImpl.setDivisionID(roundData.getPracticeRoundDivision());
                    roundModelImpl.setCoderRooms(new RoomModelImpl[]{roomModelImpl});
                    this.putRoom(roundData.getPracticeRoomID(), (RoomModel)roomModelImpl);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad round type: " + roundData);
                }
            }
        } else {
            RoundModelImpl roundModelImpl = (RoundModelImpl)this.activeRoundsMap.get(l);
            roundModelImpl.setContestName(roundData.getContestName());
            roundModelImpl.setRoundName(roundData.getRoundName());
            roundModelImpl.setMenuStatus(roundData.isEnabled());
            roundModelImpl.setPhase(roundData.getPhaseData().getPhaseType(), roundData.getPhaseData().getEndTime());
            roundModelImpl.setRoundCustomProperties(roundData.getCustomProperties());
        }
    }

    private void sortRoundList() {
        Collections.sort(this.activeRoundsList, new Comparator(){

            public int compare(Object object, Object object2) {
                RoundModel roundModel = (RoundModel)object;
                RoundModel roundModel2 = (RoundModel)object2;
                return roundModel.getRoundID().compareTo(roundModel2.getRoundID());
            }
        });
    }

    synchronized void removeRound(RoundData roundData) {
        Long l = new Long(roundData.getRoundID());
        RoundModelImpl roundModelImpl = this.getRoundModel(l);
        if (roundModelImpl.hasCoderRooms()) {
            RoomModel[] roomModelArray = roundModelImpl.getCoderRooms();
            for (int i = 0; i < roomModelArray.length; ++i) {
                this.removeRoom(roomModelArray[i].getRoomID());
            }
        }
        switch (roundData.getRoundType()) {
            case 1: 
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                this.activeRoundsList.remove(roundModelImpl);
                this.activeRoundsMap.remove(l);
                this.roundViewManager.clearRoundList();
                this.roundViewManager.updateActiveRoundList();
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 23: {
                throw new UnsupportedOperationException("Removing practice rounds not supported");
            }
            default: {
                throw new IllegalArgumentException("Bad round type: " + roundData);
            }
        }
    }

    public synchronized RoundModel[] getActiveRounds() {
        return this.activeRoundsList.toArray(new RoundModel[0]);
    }

    public synchronized RoundModel[] getPracticeRounds() {
        return this.practiceRoundsList.toArray(new RoundModel[0]);
    }

    public synchronized CategoryData[] getRoundCategories() {
        return this.roundCategories;
    }

    public RoomModel getRoom(long l) {
        Long l2 = new Long(l);
        if (!this.roomMap.containsKey(l2)) {
            throw new IllegalArgumentException("Invalid room: " + l);
        }
        return (RoomModel)this.roomMap.get(l2);
    }

    public RoomModel[] getRooms() {
        return this.roomMap.values().toArray(new RoomModel[0]);
    }

    RoomModel removeRoom(Long l) {
        RoomModel roomModel = (RoomModel)this.roomMap.remove(l);
        if (roomModel != null) {
            this.roomViewManagerManager.removeRoom(roomModel);
        }
        return roomModel;
    }

    RoomModel putRoom(long l, RoomModel roomModel) {
        return this.putRoom(new Long(l), roomModel);
    }

    RoomModel putRoom(Long l, RoomModel roomModel) {
        if (l == null) {
            throw new IllegalArgumentException("Null room ID");
        }
        if (roomModel == null) {
            throw new IllegalArgumentException("Null room: " + l);
        }
        this.roomMap.put(l, roomModel);
        this.roomViewManagerManager.addRoom(roomModel);
        return roomModel;
    }

    void clearRooms() {
        this.roomMap.clear();
        this.roomViewManagerManager.clearRooms();
    }

    void newCoderRooms(long l, RoomData[] roomDataArray) {
        final RoundModelImpl roundModelImpl = this.getRoundModel(l);
        final RoomModelImpl[] roomModelImplArray = new RoomModelImpl[roomDataArray.length];
        for (int i = 0; i < roomDataArray.length; ++i) {
            RoomData roomData = roomDataArray[i];
            int n = roomData.getRoomID();
            roomModelImplArray[i] = new RoomModelImpl(roundModelImpl, this.requester, n, roomData.getRoomType(), this.eventService);
            roomModelImplArray[i].setName(roomData.getRoomTitle());
            roomModelImplArray[i].setRoomNumber(i + 1);
            roomModelImplArray[i].setDivisionID(roomDataArray[i].getDivisionID());
            this.putRoom(new Long(n), (RoomModel)roomModelImplArray[i]);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                roundModelImpl.setCoderRooms(roomModelImplArray);
            }
        };
        this.eventService.invokeLater(runnable);
    }

    void newAdminRoom(long l, RoomData roomData) {
        if (this.userInfo.isAdmin()) {
            RoundModelImpl roundModelImpl = this.getRoundModel(l);
            RoomModelImpl roomModelImpl = new RoomModelImpl(roundModelImpl, this.requester, roomData.getRoomID(), roomData.getRoomType(), this.eventService);
            roomModelImpl.setDivisionID(-1);
            this.putRoom(new Long(roomData.getRoomID()), (RoomModel)roomModelImpl);
            roundModelImpl.setAdminRoom(roomModelImpl);
        }
    }

    void newLobby(Long l) {
        this.putRoom(l, (RoomModel)new RoomModelImpl(null, this.requester, l, 3, this.eventService));
    }

    EventService getEventService() {
        return this.eventService;
    }

    public synchronized boolean isRoomLeader(String string) {
        Iterator iterator = this.activeRoundsList.iterator();
        while (iterator.hasNext()) {
            RoundModelImpl roundModelImpl = (RoundModelImpl)iterator.next();
            if (!roundModelImpl.isRoomLeader(string)) continue;
            return true;
        }
        return false;
    }

    public void setComponentAssignmentData(ComponentAssignmentData componentAssignmentData) {
        this.componentAssignmentData = componentAssignmentData;
    }

    public ComponentAssignmentData getComponentAssignmentData() {
        return this.componentAssignmentData;
    }

    public RoomViewManagerManager getRoomViewManagerManager() {
        return this.roomViewManagerManager;
    }

    void setCurrentAppletVersion(String string) {
        this.currentAppletVersion = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MemoryClassLoader
    extends ClassLoader {
        public MemoryClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class loadClass(String string, byte[] byArray) {
            return this.defineClass(string, byArray, 0, byArray.length);
        }
    }

    private class ReconnectThread
    extends Thread {
        private long startTime;
        private boolean stopped = false;
        private Object reconnectMutex = new Object();

        private ReconnectThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setName("ReconnectThread");
            try {
                if (!ContestantImpl.this.loggedIn) {
                    return;
                }
                this.startTime = System.currentTimeMillis();
                while (this.startTime + 120000L >= System.currentTimeMillis() && !this.stopped) {
                    ContestantImpl.this.messageProcessor.closeConnection();
                    if (ContestantImpl.this.openConnection(ContestantImpl.this.connectionType)) {
                        ContestantImpl.this.requester.setClient(ContestantImpl.this.messageProcessor.getClient());
                        try {
                            ContestantImpl.this.requester.requestReconnect(ContestantImpl.this.getHashCode(), ContestantImpl.this.getConnectionID());
                        }
                        catch (TimeOutException timeOutException) {
                            timeOutException.printStackTrace();
                        }
                    }
                    try {
                        Object object = this.reconnectMutex;
                        synchronized (object) {
                            if (!this.stopped) {
                                this.reconnectMutex.wait(3000L);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (!this.stopped) {
                    ContestantImpl.this.view.reconnectFailedEvent();
                }
            }
            finally {
                ContestantImpl.this.removeReconnectThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            Object object = this.reconnectMutex;
            synchronized (object) {
                this.stopped = true;
                this.reconnectMutex.notifyAll();
            }
        }
    }
}

