/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.impl.ChinaProxySelector;
import java.net.Authenticator;
import java.util.ArrayList;

public abstract class ConnectionType {
    private static ConnectionType[] availableTypes;
    private String id;
    private String name;
    private String description;
    private static Authenticator authenticator;
    public static final ConnectionType DIRECT;
    public static final ConnectionType CHINA_PROXY;
    public static final ConnectionType TUNNEL_CHUNKED;
    public static final ConnectionType TUNNEL_NOT_CHUNKED;
    private static final ConnectionType[] CONNECTION_TYPES;

    public ConnectionType(String string, String string2, String string3) {
        this.id = string;
        this.name = string2;
        this.description = string3;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public abstract boolean isTunneled();

    public abstract boolean isAvailable();

    public void select() {
        throw new InternalError("badly shrinked - this shouldnt happen.");
    }

    public void unselect() {
        throw new InternalError("badly shrinked - this shouldnt happen.");
    }

    public static ConnectionType[] getAvaliableTypes() {
        if (availableTypes == null) {
            ArrayList<ConnectionType> arrayList = new ArrayList<ConnectionType>();
            for (int i = 0; i < CONNECTION_TYPES.length; ++i) {
                if (!CONNECTION_TYPES[i].isAvailable()) continue;
                arrayList.add(CONNECTION_TYPES[i]);
            }
            availableTypes = arrayList.toArray(new ConnectionType[arrayList.size()]);
        }
        return availableTypes;
    }

    public static ConnectionType getById(String string) {
        for (int i = 0; i < CONNECTION_TYPES.length; ++i) {
            if (!CONNECTION_TYPES[i].getId().equals(string)) continue;
            return CONNECTION_TYPES[i];
        }
        return null;
    }

    public static void registerAuthenticator(Authenticator authenticator) {
        ConnectionType.authenticator = authenticator;
    }

    static {
        authenticator = null;
        DIRECT = new ConnectionType("DIRECT", "Direct", "Direct connection to the server."){

            public boolean isTunneled() {
                return false;
            }

            public boolean isAvailable() {
                return true;
            }

            public void select() {
                Authenticator.setDefault(authenticator);
            }

            public void unselect() {
                Authenticator.setDefault(null);
            }
        };
        CHINA_PROXY = new ConnectionType("CHINA", "Direct (China)", "Direct connection to the server via proxy in China."){
            private ChinaProxySelector selector = null;

            public boolean isTunneled() {
                return false;
            }

            public boolean isAvailable() {
                String string = System.getProperty("java.version");
                if (string.charAt(0) > '1') {
                    return true;
                }
                return string.charAt(2) >= '5' || string.length() > 3 && string.charAt(3) != '.';
            }

            public void select() {
                this.selector = new ChinaProxySelector();
                this.selector.setup();
            }

            public void unselect() {
                this.selector.unsetup();
            }
        };
        TUNNEL_CHUNKED = new ConnectionType("TCHUNKED", "HTTP Tunnel A", "HTTP tunneled connection.\nIt is significantly slower than connecting directly and\n should only be used by people who are unable to connect otherwise."){

            public boolean isTunneled() {
                return true;
            }

            public boolean isAvailable() {
                String string = System.getProperty("java.version");
                if (string.charAt(0) > '1') {
                    return true;
                }
                return string.charAt(2) >= '5' || string.length() > 3 && string.charAt(3) != '.';
            }

            public void select() {
                System.setProperty("com.topcoder.net.httptunnel.client.reuseConnection", "true");
                Authenticator.setDefault(authenticator);
            }

            public void unselect() {
                Authenticator.setDefault(null);
            }
        };
        TUNNEL_NOT_CHUNKED = new ConnectionType("TNCHUNKED", "HTTP Tunnel B", "HTTP tunneled connection (old method).\nIt is significantly slower than connecting directly \nshould only be used by people who are unable to connect otherwise.\nThis is the slowest tunnel option."){

            public boolean isTunneled() {
                return true;
            }

            public void select() {
                System.setProperty("com.topcoder.net.httptunnel.client.reuseConnection", "false");
                Authenticator.setDefault(authenticator);
            }

            public void unselect() {
                Authenticator.setDefault(null);
            }

            public boolean isAvailable() {
                return true;
            }
        };
        CONNECTION_TYPES = new ConnectionType[]{DIRECT, CHINA_PROXY, TUNNEL_CHUNKED, TUNNEL_NOT_CHUNKED};
    }
}

