/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels.table;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.view.LeaderListener;
import com.topcoder.netCommon.contestantMessages.response.data.LeaderboardItem;
import java.util.Collection;
import java.util.Iterator;

public class LeaderboardTableModel
extends SortedTableModel
implements LeaderListener {
    private Contestant model;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$topcoder$client$contestApplet$uilogic$panels$table$UserNameEntry;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;

    public LeaderboardTableModel(Contestant contestant) {
        super(new String[]{"Room", "R", "User", "Seed", "Score", ""}, new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = LeaderboardTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = LeaderboardTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$com$topcoder$client$contestApplet$uilogic$panels$table$UserNameEntry == null ? (class$com$topcoder$client$contestApplet$uilogic$panels$table$UserNameEntry = LeaderboardTableModel.class$("com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry")) : class$com$topcoder$client$contestApplet$uilogic$panels$table$UserNameEntry, class$java$lang$Integer == null ? (class$java$lang$Integer = LeaderboardTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = LeaderboardTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Character == null ? (class$java$lang$Character = LeaderboardTableModel.class$("java.lang.Character")) : class$java$lang$Character});
        this.addSortElement(new SortElement(0, false));
        this.addSortElement(new SortElement(1, false));
        this.addSortElement(new SortElement(2, false));
        this.addSortElement(new SortElement(3, false));
        this.addSortElement(new SortElement(4, false));
        this.addSortElement(new SortElement(5, false));
        this.model = contestant;
    }

    public LeaderboardItem getLeaderboardItem(int n) {
        return (LeaderboardItem)super.get(n);
    }

    public Object getValueAt(int n, int n2) {
        LeaderboardItem leaderboardItem = this.getLeaderboardItem(n);
        switch (n2) {
            case 0: {
                RoomModel roomModel = this.model.getRoom(leaderboardItem.getRoomID());
                if (!roomModel.hasLeader()) {
                    return null;
                }
                return roomModel.getRoomNumber();
            }
            case 1: {
                return new Integer(leaderboardItem.getUserRating());
            }
            case 2: {
                return new UserNameEntry(leaderboardItem.getUserName(), leaderboardItem.getUserRating(), true, -1);
            }
            case 3: {
                return new Integer(leaderboardItem.getSeed());
            }
            case 4: {
                return Common.formatScore(leaderboardItem.getPoints() / 100.0);
            }
            case 5: {
                return leaderboardItem.isCloseRace() ? "*" : "";
            }
        }
        throw new IllegalArgumentException("Invalid column: " + n2);
    }

    public int compare(Object object, Object object2) {
        LeaderboardItem leaderboardItem = (LeaderboardItem)object;
        LeaderboardItem leaderboardItem2 = (LeaderboardItem)object2;
        Iterator iterator = this.getSortListIterator();
        block8: while (iterator.hasNext()) {
            SortElement sortElement = (SortElement)iterator.next();
            int n = sortElement.getColumn();
            int n2 = sortElement.isOpposite() ? -1 : 1;
            int n3 = 0;
            switch (n) {
                case 0: {
                    RoomModel roomModel = this.model.getRoom(leaderboardItem.getRoomID());
                    RoomModel roomModel2 = this.model.getRoom(leaderboardItem2.getRoomID());
                    n3 = roomModel.getRoomNumber() - roomModel2.getRoomNumber();
                    if (n3 == 0) continue block8;
                    return n2 * n3;
                }
                case 1: {
                    n3 = leaderboardItem.getUserRating() - leaderboardItem2.getUserRating();
                    if (n3 == 0) continue block8;
                    return n2 * n3;
                }
                case 2: {
                    n3 = LeaderboardTableModel.compareStrings(leaderboardItem.getUserName(), leaderboardItem2.getUserName());
                    if (n3 == 0) continue block8;
                    return n2 * n3;
                }
                case 3: {
                    n3 = leaderboardItem.getSeed() - leaderboardItem2.getSeed();
                    if (n3 == 0) continue block8;
                    return n2 * n3;
                }
                case 4: {
                    double d = leaderboardItem.getPoints() - leaderboardItem2.getPoints();
                    if (d == 0.0) continue block8;
                    return n2 * (d > 0.0 ? 1 : -1);
                }
                case 5: {
                    if (leaderboardItem.isCloseRace() && !leaderboardItem2.isCloseRace()) {
                        return -n2;
                    }
                    if (leaderboardItem.isCloseRace() || !leaderboardItem2.isCloseRace()) continue block8;
                    return n2;
                }
            }
            throw new IllegalStateException("not implemented, column=" + sortElement);
        }
        return 0;
    }

    public void update(Collection collection) {
        this.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            LeaderboardItem leaderboardItem = (LeaderboardItem)iterator.next();
            RoomModel roomModel = this.model.getRoom(leaderboardItem.getRoomID());
            roomModel.addLeaderListener(this);
        }
        super.update(collection);
    }

    public void clear() {
        Iterator iterator = super.getItemList().iterator();
        while (iterator.hasNext()) {
            LeaderboardItem leaderboardItem = (LeaderboardItem)iterator.next();
            try {
                RoomModel roomModel = this.model.getRoom(leaderboardItem.getRoomID());
                roomModel.removeLeaderListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                iterator.remove();
                this.processItemListChanged();
            }
        }
        super.clear();
    }

    public void updateLeader(RoomModel roomModel) {
        this.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

