/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.HeartbeatListener;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimerPanel
implements HeartbeatListener {
    private final NumberFormat systestFormat = new DecimalFormat("0.00");
    private final NumberFormat doubleDigitFormat = new DecimalFormat("00");
    private final DateFormat clockFormat = new SimpleDateFormat("h:mm:ss a z");
    private int testsDone;
    private int totalSystests;
    private UIComponent timerTitle = null;
    private UIComponent timer = null;
    private UIPage page;
    private UIComponent timerPanel;
    private ContestApplet contestApplet = null;
    private int mode = 1;
    private boolean warned = false;
    private RoundModel roundModel;
    private StringBuffer countdownBuffer = new StringBuffer();

    public TimerPanel(ContestApplet contestApplet, UIPage uIPage) {
        this(contestApplet, uIPage, "timer_panel", "timer_title", "timer");
    }

    protected TimerPanel(ContestApplet contestApplet, UIPage uIPage, String string, String string2, String string3) {
        this.contestApplet = contestApplet;
        this.page = uIPage;
        this.timerTitle = uIPage.getComponent(string2);
        this.timer = uIPage.getComponent(string3);
        this.timerPanel = uIPage.getComponent(string);
        contestApplet.getModel().addHeartbeatListener(this);
        this.timerTitle.setProperty("Text", "TOPCODER TIME");
        this.timer.setProperty("Text", "00:00:00");
        this.setMode(1);
    }

    public void setMode(int n) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid mode: " + n);
        }
        if (n == 2 && this.roundModel == null) {
            throw new IllegalStateException("Cannot start countdown with null roundModel!");
        }
        this.mode = n;
    }

    public void setRoundModel(RoundModel roundModel) {
        if (roundModel != this.roundModel) {
            this.resetOnRoundChanged();
        }
        this.roundModel = roundModel;
    }

    private void resetOnRoundChanged() {
        this.testsDone = 0;
        this.totalSystests = 0;
    }

    public void unsetRoundModel() {
        this.setMode(1);
        this.roundModel = null;
    }

    public void setTitle(String string) {
        this.timerTitle.setProperty("Text", string);
    }

    public void updateSystestProgress(int n, int n2) {
        this.testsDone = n;
        this.totalSystests = n2;
    }

    private void updateSystestProgress() {
        String string;
        if (this.totalSystests == 0) {
            string = "00:00:00";
        } else {
            double d = 100.0 * (double)this.testsDone / (double)this.totalSystests;
            String string2 = this.systestFormat.format(d);
            string = "" + string2 + "% of " + this.totalSystests;
        }
        this.timer.setProperty("Text", string);
        this.timer.performAction("repaint");
    }

    private void countdown() {
        if (this.roundModel == null) {
            throw new IllegalStateException("Missing round model: " + this.roundModel);
        }
        this.countdownBuffer.setLength(0);
        int n = this.roundModel.getSecondsLeftInPhase();
        if (this.roundModel.getRoundProperties().usesPerUserCodingTime() && n == 0 && this.roundModel.getPhase() == 4) {
            this.countdownBuffer.append("EXPIRED");
            this.warn();
        } else {
            this.countdownBuffer.append(this.doubleDigitFormat.format(n / 3600));
            this.countdownBuffer.append(':');
            this.countdownBuffer.append(this.doubleDigitFormat.format((n %= 3600) / 60));
            this.countdownBuffer.append(':');
            this.countdownBuffer.append(this.doubleDigitFormat.format(n % 60));
        }
        this.timer.setProperty("Text", this.countdownBuffer.toString());
        this.timer.performAction("repaint");
    }

    private void warn() {
        if (!this.warned) {
            Common.showMessage("Alert", "Your time has expired", this.contestApplet);
            this.warned = true;
        }
    }

    public void tick() {
        switch (this.mode) {
            case 1: {
                this.timer.setProperty("Text", this.clockFormat.format(new Date(this.contestApplet.getModel().getServerTime())));
                this.timer.performAction("repaint");
                break;
            }
            case 2: {
                this.countdown();
                break;
            }
            case 3: {
                this.updateSystestProgress();
                break;
            }
        }
    }

    public boolean isRoundModelInitialized() {
        return this.roundModel != null;
    }

    public void setVisible(boolean bl) {
        this.timerPanel.setProperty("visible", bl);
    }
}

