/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.uilogic.components.LongCodeViewer;
import com.topcoder.client.contestApplet.uilogic.panels.TablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.ValueTransformDecoratorCellRenderer;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyAdapter;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contestantMessages.response.SubmissionHistoryResponse;
import com.topcoder.shared.language.BaseLanguage;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SubmissionHistoryPanel
extends TablePanel {
    private static final String[] headers = new String[]{" ", "Submission", "Time", "Language", "Score"};
    private static final String[] exampleHeaders = new String[]{" ", "Example Submission", "Time", "Language"};
    private static final Class[] classes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SubmissionHistoryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = SubmissionHistoryPanel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$util$Date == null ? (class$java$util$Date = SubmissionHistoryPanel.class$("java.util.Date")) : class$java$util$Date, class$java$lang$String == null ? (class$java$lang$String = SubmissionHistoryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Double == null ? (class$java$lang$Double = SubmissionHistoryPanel.class$("java.lang.Double")) : class$java$lang$Double};
    private static final Class[] exampleClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SubmissionHistoryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = SubmissionHistoryPanel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$util$Date == null ? (class$java$util$Date = SubmissionHistoryPanel.class$("java.util.Date")) : class$java$util$Date, class$java$lang$String == null ? (class$java$lang$String = SubmissionHistoryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Double == null ? (class$java$lang$Double = SubmissionHistoryPanel.class$("java.lang.Double")) : class$java$lang$Double};
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private static final DecimalFormat SCORE_FORMAT = new DecimalFormat("0.00");
    private SubmissionHistoryResponse response;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Double;

    protected String getTableName() {
        return "submission_history_table";
    }

    protected String getMenuName() {
        return "submission_history_menu";
    }

    public SubmissionHistoryPanel(ContestApplet contestApplet, SubmissionHistoryResponse submissionHistoryResponse, UIPage uIPage) {
        super(contestApplet, uIPage, new SubmissionHistoryTableModel(submissionHistoryResponse));
        this.response = submissionHistoryResponse;
        uIPage.getComponent("submission_history_menu_source").addEventListener("Action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SubmissionHistoryPanel.this.openSourceEvent();
            }
        });
        uIPage.getComponent("submission_history_time_column").setProperty("CellRenderer", new ValueTransformDecoratorCellRenderer((TableCellRenderer)uIPage.getComponent("submission_history_time_column").getProperty("CellRenderer")){

            protected Object transform(Object object, int n, int n2) {
                if (object == null) {
                    return null;
                }
                return DATE_FORMAT.format(object);
            }
        });
        if (submissionHistoryResponse.isExampleHistory()) {
            uIPage.getComponent("submission_history_menu_last").addEventListener("Action", new UIActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SubmissionHistoryPanel.this.openResultsEvent();
                }
            });
        } else {
            uIPage.getComponent("submission_history_score_column").setProperty("CellRenderer", new ValueTransformDecoratorCellRenderer((TableCellRenderer)uIPage.getComponent("submission_history_score_column").getProperty("CellRenderer")){

                protected Object transform(Object object, int n, int n2) {
                    if (object == null) {
                        return null;
                    }
                    return SCORE_FORMAT.format(object);
                }
            });
        }
        this.table.addEventListener("Mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SubmissionHistoryPanel.this.mouseClickEvent(mouseEvent);
            }
        });
        ((JTableHeader)this.table.getProperty("TableHeader")).addMouseListener(new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SubmissionHistoryPanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.table.addEventListener("Key", new UIKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SubmissionHistoryPanel.this.openSourceEvent();
                }
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showContestPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openSourceEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
        }
    }

    private synchronized void openSourceEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        if (n == -1) {
            return;
        }
        n = (Integer)this.tableModel.get(n);
        LongCodeViewer longCodeViewer = new LongCodeViewer(this.ca, this.ca.getCurrentFrame(), this.response.getRoundId(), this.response.getHandle(), this.response.getComponentId(), this.response.isExampleHistory(), this.response.getNumber(n), true);
        longCodeViewer.show();
    }

    private synchronized void openResultsEvent() {
        this.ca.getRequester().requestLongTestResults(this.response.getComponentId(), this.getRoom(), this.response.getHandle(), 0);
    }

    private long getRoom() {
        return this.ca.getModel().getRound(this.response.getRoundId()).getRoomByCoder(this.response.getHandle()).getRoomID();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SubmissionHistoryTableModel
    extends SortedTableModel {
        private SubmissionHistoryResponse response;

        public SubmissionHistoryTableModel(SubmissionHistoryResponse submissionHistoryResponse) {
            super(submissionHistoryResponse.isExampleHistory() ? exampleHeaders : headers, submissionHistoryResponse.isExampleHistory() ? exampleClasses : classes);
            this.addSortElement(new SortElement(1, true));
            this.addSortElement(new SortElement(2, true));
            this.addSortElement(new SortElement(3, false));
            if (!submissionHistoryResponse.isExampleHistory()) {
                this.addSortElement(new SortElement(4, false));
            }
            this.response = submissionHistoryResponse;
            int n = submissionHistoryResponse.getCount();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Integer(i));
            }
            this.update(arrayList);
        }

        public Object getValueAt(int n, int n2) {
            int n3 = ((Number)this.get(n)).intValue();
            return this.getDirectValueAt(n3, n2);
        }

        private Object getDirectValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.response.hasPendingTest(n) ? "*" : " ";
                }
                case 1: {
                    return new Integer(this.response.getNumber(n));
                }
                case 2: {
                    return new Date(this.response.getTime(n));
                }
                case 3: {
                    return BaseLanguage.getLanguage(this.response.getLanguageId(n)).getName();
                }
                case 4: {
                    return new Double(this.response.getScore(n));
                }
            }
            throw new IllegalArgumentException("Bad column: " + n2);
        }

        public int compare(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            Iterator iterator = this.getSortListIterator();
            while (iterator.hasNext()) {
                Comparable comparable;
                int n3;
                SortElement sortElement = (SortElement)iterator.next();
                int n4 = sortElement.getColumn();
                int n5 = n3 = sortElement.isOpposite() ? -1 : 1;
                Comparable comparable2 = (Comparable)this.getDirectValueAt(n, n4);
                int n6 = comparable2.compareTo(comparable = (Comparable)this.getDirectValueAt(n2, n4));
                if (n6 == 0) continue;
                return n3 * n6;
            }
            return 0;
        }
    }
}

