/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.AppletPreferencesDialog;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIFactory;
import com.topcoder.client.ui.UIManager;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SkinConfigurationPanel {
    private boolean changesPending = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private ActionHandler handler = new ActionHandler();
    private AppletPreferencesDialog parentFrame;
    private UIPage page;
    private UIComponent skinSelection;
    private UIComponent skinDescription;
    private Map map;

    public SkinConfigurationPanel(FrameLogic frameLogic, UIPage uIPage) {
        this.page = uIPage;
        this.parentFrame = (AppletPreferencesDialog)frameLogic;
        this.skinSelection = uIPage.getComponent("skin_selection_list");
        this.skinDescription = uIPage.getComponent("skin_description_pane");
        UIManager[] uIManagerArray = this.localPref.getAllUIManagers();
        UIManager uIManager = UIFactory.getUIManagerFromResource(this.getClass(), "/ui/default.xml");
        this.map = new HashMap(uIManagerArray.length + 1);
        this.skinSelection.performAction("addItem", new Object[]{uIManager.getName()});
        this.map.put(uIManager.getName(), uIManager.getDescription());
        for (int i = 0; i < uIManagerArray.length; ++i) {
            this.skinSelection.performAction("addItem", new Object[]{uIManagerArray[i].getName()});
            this.map.put(uIManagerArray[i].getName(), uIManagerArray[i].getDescription());
        }
        this.skinSelection.setProperty("UI", this.skinSelection.getProperty("UI"));
        this.skinSelection.setProperty("SelectedItem", this.parentFrame.getApplet().getCurrentUIManager().getName());
        this.skinDescription.setProperty("Text", this.parentFrame.getApplet().getCurrentUIManager().getDescription());
        this.skinSelection.addEventListener("action", this.handler);
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public void savePreferences() {
        this.localPref.setProperty("ui.theme", this.skinSelection.getProperty("selecteditem").toString());
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changesPending = false;
    }

    private class ActionHandler
    implements UIActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SkinConfigurationPanel.this.skinDescription.setProperty("Text", SkinConfigurationPanel.this.map.get(SkinConfigurationPanel.this.skinSelection.getProperty("SelectedItem")));
            SkinConfigurationPanel.this.changesPending = true;
        }
    }
}

