/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.panels.QuestionPanel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.netCommon.contest.Answer;
import com.topcoder.netCommon.contest.Question;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SingleChoicePanel
implements QuestionPanel {
    private Question question;
    private UIComponent panel;
    private UIPage page;
    private List answers;
    private JRadioButton[] selections;

    public SingleChoicePanel(ContestApplet contestApplet, String string, Question question) {
        this.question = question;
        this.page = contestApplet.getCurrentUIManager().getUIPage("single_choice_panel", true);
        this.panel = this.page.getComponent("root_panel");
        ((TitledBorder)this.panel.getProperty("border")).setTitle(string);
        this.page.getComponent("question_text").setProperty("text", question.getQuestionText());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.answers = question.getAnswerText();
        this.selections = new JRadioButton[this.answers.size()];
        UIComponent uIComponent = this.page.getComponent("choice_template");
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.answers.size(); ++i) {
            JRadioButton jRadioButton = (JRadioButton)uIComponent.performAction("clone");
            jRadioButton.setText((String)this.answers.get(i));
            Common.insertInPanel(jRadioButton, (JPanel)this.panel.getEventSource(), gridBagConstraints, 0, i + 1, 1, 1, 0.1, 0.1);
            this.selections[i] = jRadioButton;
            buttonGroup.add(jRadioButton);
        }
    }

    public UIComponent getPanel() {
        return this.panel;
    }

    public Answer getAnswer() {
        ArrayList arrayList = new ArrayList(this.answers.size());
        boolean bl = false;
        for (int i = 0; i < this.answers.size(); ++i) {
            if (!this.selections[i].isSelected()) continue;
            bl = true;
            arrayList.add(this.answers.get(i));
        }
        if (!bl) {
            JOptionPane.showMessageDialog(null, "You must provide an answer to the question: \r\n" + this.question.getQuestionText(), "Error", 0);
            return null;
        }
        return this.question.getAnswer(arrayList);
    }
}

