/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.uilogic.panels.TablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.LeaderboardTableModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.LeaderListener;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contestantMessages.response.data.LeaderboardItem;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.SwingUtilities;

public class RoomInfoTablePanel
extends TablePanel
implements LeaderListener {
    private LeaderboardTableModel leaderboardTableModel = (LeaderboardTableModel)this.tableModel;
    private RoundModel roundModel;
    private UIComponent panel;
    private boolean enabled = true;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setEnabled(boolean bl) {
        this.setPanelEnabled(bl);
        this.panel.setProperty("enabled", bl);
    }

    protected String getTableName() {
        return "room_info_table";
    }

    protected String getMenuName() {
        return "room_info_table_menu";
    }

    public RoomInfoTablePanel(ContestApplet contestApplet, UIPage uIPage) {
        super(contestApplet, uIPage, new LeaderboardTableModel(contestApplet.getModel()));
        this.panel = uIPage.getComponent("room_info_table_panel");
        uIPage.getComponent("room_info_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoomInfoTablePanel.this.popupEvent();
            }
        });
        uIPage.getComponent("room_info_table_user_renderer").setProperty("model", contestApplet.getModel());
        this.table.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (RoomInfoTablePanel.this.enabled) {
                    RoomInfoTablePanel.this.doubleClickEvent(mouseEvent);
                }
            }
        });
        this.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                RoomInfoTablePanel.this.headerClickEvent(mouseEvent);
            }
        });
    }

    private void doubleClickEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.popupEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            boolean bl = (mouseEvent.getModifiers() & 1) > 0;
            this.getTableModel().sort(n, bl);
            this.getTable().getTableHeader().repaint();
        }
    }

    private void popupEvent() {
        int n = this.getTable().getSelectedRow();
        this.ca.setCurrentFrame(this.ca.getMainFrame());
        this.ca.getRoomManager().watch(this.leaderboardTableModel.getLeaderboardItem(n).getRoomID());
    }

    public void clear() {
        this.leaderboardTableModel.clear();
        if (this.roundModel != null) {
            this.roundModel.removeLeaderListener(this);
            this.roundModel = null;
        }
    }

    public void setRound(RoundModel roundModel) {
        this.clear();
        this.roundModel = roundModel;
        this.roundModel.addLeaderListener(this);
        if (roundModel.hasLeaderboard()) {
            LeaderboardItem[] leaderboardItemArray = roundModel.getLeaderboard();
            this.leaderboardTableModel.update(Arrays.asList(leaderboardItemArray));
        }
    }

    public void updateLeader(RoomModel roomModel) {
        if (this.roundModel != null && this.roundModel.hasLeaderboard()) {
            LeaderboardItem[] leaderboardItemArray = this.roundModel.getLeaderboard();
            this.leaderboardTableModel.update(Arrays.asList(leaderboardItemArray));
        }
    }
}

