/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.ImportantMessageDialog;
import com.topcoder.client.contestApplet.uilogic.panels.TablePanel;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyAdapter;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contestantMessages.response.GetImportantMessagesResponse;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public class ImportantMessageSummaryPanel
extends TablePanel {
    private static final String[] headers = new String[]{"Read", "Message"};
    private boolean enabled = true;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void update(GetImportantMessagesResponse getImportantMessagesResponse) {
        this.getTableModel().update(getImportantMessagesResponse.getItems());
    }

    protected String getTableName() {
        return "summary_table";
    }

    protected String getMenuName() {
        return "summary_table_menu";
    }

    public ImportantMessageSummaryPanel(ContestApplet contestApplet, UIPage uIPage) {
        super(contestApplet, uIPage, new ImportantMessageSummaryTableModel());
        this.table.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ImportantMessageSummaryPanel.this.enabled) {
                    ImportantMessageSummaryPanel.this.mouseClickEvent(mouseEvent);
                }
            }
        });
        ((JTableHeader)this.table.getProperty("TableHeader")).addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ImportantMessageSummaryPanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.table.addEventListener("key", new UIKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ImportantMessageSummaryPanel.this.enabled && keyEvent.getKeyCode() == 10) {
                    ImportantMessageSummaryPanel.this.openMessageEvent();
                }
            }
        });
        uIPage.getComponent("summary_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportantMessageSummaryPanel.this.openMessageEvent();
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showContestPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openMessageEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.getTable().getTableHeader().repaint();
        }
    }

    private synchronized void openMessageEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        if (n == -1) {
            return;
        }
        GetImportantMessagesResponse.ImportantMessage importantMessage = (GetImportantMessagesResponse.ImportantMessage)this.tableModel.get(n);
        ImportantMessageDialog importantMessageDialog = new ImportantMessageDialog(this.ca, importantMessage.getMessage());
        importantMessageDialog.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ImportantMessageSummaryTableModel
    extends SortedTableModel {
        public ImportantMessageSummaryTableModel() {
            super(headers, new Class[]{class$java$lang$Long == null ? (class$java$lang$Long = ImportantMessageSummaryPanel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$String == null ? (class$java$lang$String = ImportantMessageSummaryPanel.class$("java.lang.String")) : class$java$lang$String});
            this.addSortElement(new SortElement(0, true));
        }

        public Object getValueAt(int n, int n2) {
            GetImportantMessagesResponse.ImportantMessage importantMessage = (GetImportantMessagesResponse.ImportantMessage)this.get(n);
            switch (n2) {
                case 0: {
                    return new Long(importantMessage.getTime());
                }
                case 1: {
                    return Common.htmlEncode(importantMessage.getMessage());
                }
            }
            throw new IllegalArgumentException("Bad column: " + n2);
        }

        public int compare(Object object, Object object2) {
            GetImportantMessagesResponse.ImportantMessage importantMessage = (GetImportantMessagesResponse.ImportantMessage)object;
            GetImportantMessagesResponse.ImportantMessage importantMessage2 = (GetImportantMessagesResponse.ImportantMessage)object2;
            Iterator iterator = this.getSortListIterator();
            if (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n = sortElement.getColumn();
                int n2 = sortElement.isOpposite() ? -1 : 1;
                switch (n) {
                    case 0: {
                        long l = importantMessage.getTime() - importantMessage2.getTime();
                        return n2 * (l > 0L ? 1 : -1);
                    }
                    case 1: {
                        int n3 = importantMessage.getMessage().compareTo(importantMessage2.getMessage());
                        return n2 * n3;
                    }
                }
                throw new IllegalArgumentException("Bad column: " + sortElement);
            }
            throw new IllegalStateException("Problem sorting broadcasts: " + this.getItemList());
        }
    }
}

