/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.HighlightingException;
import com.topcoder.util.syntaxhighlighter.RuleMatchException;
import com.topcoder.util.syntaxhighlighter.StatefulJTextPaneOutput;
import com.topcoder.util.syntaxhighlighter.SyntaxHighlighter;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTextPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class HighlightConfigurationPanel {
    private UIPage page;
    private FrameLogic parent;
    private UIComponent sourcePreview;
    private StatefulJTextPaneOutput sourcePreviewOutput;
    private String sourcePreviewStr = "/* a comment */\npublic int testMethod() {\n  String s = \"123\";\n  return 0;\n}";
    private SyntaxHighlighter highlighter;
    private SimpleEditorFilter editorFilter;
    private MutableAttributeSet attr = new SimpleAttributeSet();
    private ActionHandler handler = new ActionHandler();
    private UIComponent stdCommentsStyle;
    private UIComponent stdLiteralsStyle;
    private UIComponent stdKeywordsStyle;
    private UIComponent stdDefaultStyle;
    private UIComponent highlightEditorBox;
    private UIComponent highlightViewerBox;
    private HashMap map = new HashMap();
    private boolean changesPending = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private boolean update = true;

    public HighlightConfigurationPanel(FrameLogic frameLogic, UIPage uIPage) {
        this.parent = frameLogic;
        this.page = uIPage;
        this.sourcePreview = uIPage.getComponent("highlight_preview_pane");
        this.sourcePreviewOutput = new StatefulJTextPaneOutput((JTextPane)this.sourcePreview.getEventSource());
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments"), "highlight_comments_color"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals"), "highlight_literals_color"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords"), "highlight_keywords_color"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault"), "highlight_default_color"));
        Object[] objectArray = new Object[]{"Normal", "Bold", "Italic", "Bold Italic"};
        this.highlightEditorBox = this.createJCheckBox("highlight_editor_checkbox", this.localPref.isSyntaxHighlight());
        this.highlightViewerBox = this.createJCheckBox("highlight_viewer_checkbox", this.localPref.isViewerSyntaxHighlight());
        this.stdCommentsStyle = this.createJComboBox("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcommentsstyle", objectArray, "highlight_comments_style");
        this.stdLiteralsStyle = this.createJComboBox("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliteralsstyle", objectArray, "highlight_literals_style");
        this.stdKeywordsStyle = this.createJComboBox("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywordsstyle", objectArray, "highlight_keywords_style");
        this.stdDefaultStyle = this.createJComboBox("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefaultstyle", objectArray, "highlight_default_style");
        AbstractDocument abstractDocument = (AbstractDocument)this.sourcePreview.getProperty("Document");
        this.editorFilter = new SimpleEditorFilter();
        try {
            ConfigManager configManager = this.localPref.getConfigManager();
            if (!configManager.existsNamespace("com.topcoder.util.syntaxhighlighter")) {
                URL uRL = this.getClass().getResource("/syntaxhighlighter/config.xml");
                configManager.add(uRL);
            }
            this.highlighter = new SyntaxHighlighter();
            this.updateHighlighterStyles();
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
        if (this.localPref.isSyntaxHighlight()) {
            abstractDocument.setDocumentFilter(this.editorFilter);
        } else {
            abstractDocument.setDocumentFilter(null);
        }
        this.resetPreview();
    }

    private UIComponent createJButton(Color color, String string) {
        UIComponent uIComponent = this.page.getComponent(string);
        uIComponent.setProperty("Background", color);
        uIComponent.addEventListener("Action", this.handler);
        return uIComponent;
    }

    private UIComponent createJCheckBox(String string, boolean bl) {
        UIComponent uIComponent = this.page.getComponent(string);
        uIComponent.setProperty("Selected", bl);
        uIComponent.addEventListener("Action", this.handler);
        return uIComponent;
    }

    private UIComponent createJComboBox(String string, Object[] objectArray, String string2) {
        UIComponent uIComponent = this.page.getComponent(string2);
        uIComponent.setProperty("items", objectArray);
        uIComponent.setProperty("SelectedIndex", Integer.valueOf(this.localPref.getProperty(string, "0")));
        uIComponent.addEventListener("Action", this.handler);
        return uIComponent;
    }

    private void resetPreview() {
        this.sourcePreview.setProperty("Text", "");
        this.sourcePreview.setProperty("SelectedTextColor", this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt"));
        this.sourcePreview.setProperty("SelectionColor", this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb"));
        this.sourcePreview.setProperty("Background", this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback"));
        this.updateHighlighterStyles();
        try {
            Document document = (Document)this.sourcePreview.getProperty("Document");
            document.insertString(document.getLength(), this.sourcePreviewStr, this.attr);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public void saveHighlightPreferences() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            UIComponent uIComponent = (UIComponent)this.map.get(string);
            hashMap.put(string, uIComponent.getProperty("Background"));
        }
        this.localPref.saveColors(hashMap);
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcommentsstyle", String.valueOf(this.stdCommentsStyle.getProperty("SelectedIndex")));
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliteralsstyle", String.valueOf(this.stdLiteralsStyle.getProperty("SelectedIndex")));
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywordsstyle", String.valueOf(this.stdKeywordsStyle.getProperty("SelectedIndex")));
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefaultstyle", String.valueOf(this.stdDefaultStyle.getProperty("SelectedIndex")));
        this.localPref.setSyntaxHighlight((Boolean)this.highlightEditorBox.getProperty("Selected"));
        this.localPref.setViewerSyntaxHighlight((Boolean)this.highlightViewerBox.getProperty("Selected"));
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changesPending = false;
    }

    private void rehighlight(int n, int n2, int n3) {
        if (((Document)this.sourcePreview.getProperty("Document")).getLength() == 0) {
            return;
        }
        try {
            String string = this.sourcePreviewOutput.getHighlightString(n, n2, n3, 50, 0);
            if (string != null && !string.trim().equals("")) {
                if (!this.update) {
                    this.sourcePreviewOutput.setUpdate(false);
                }
                this.highlighter.highlightText(string, "Java", this.sourcePreviewOutput);
                if (!this.update) {
                    this.sourcePreviewOutput.setUpdate(true);
                }
            }
        }
        catch (RuleMatchException ruleMatchException) {
            ruleMatchException.printStackTrace();
            this.sourcePreviewOutput.resetState();
        }
        catch (HighlightingException highlightingException) {
            highlightingException.printStackTrace();
            this.sourcePreviewOutput.resetState();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            this.sourcePreviewOutput.resetState();
        }
    }

    private void updateHighlighterStyles() {
        String string = this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont");
        int n = 0;
        int n2 = this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize");
        for (int i = 0; i < this.highlighter.getLanguages().length; ++i) {
            TextStyle[] textStyleArray = this.highlighter.getLanguages()[i].getStyles();
            for (int j = 0; j < textStyleArray.length; ++j) {
                if (textStyleArray[j].getName().equals("KEYWORD_STYLE")) {
                    textStyleArray[j].setColor((Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords")).getProperty("Background"));
                    n = (Integer)this.stdKeywordsStyle.getProperty("SelectedIndex");
                } else if (textStyleArray[j].getName().equals("BLOCK_STYLE")) {
                    textStyleArray[j].setColor((Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments")).getProperty("Background"));
                    n = (Integer)this.stdCommentsStyle.getProperty("SelectedIndex");
                } else if (textStyleArray[j].getName().equals("LITERAL_STYLE")) {
                    textStyleArray[j].setColor((Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals")).getProperty("Background"));
                    n = (Integer)this.stdLiteralsStyle.getProperty("SelectedIndex");
                } else if (textStyleArray[j].getName().equals("DEFAULT_STYLE")) {
                    textStyleArray[j].setColor((Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault")).getProperty("Background"));
                    n = (Integer)this.stdDefaultStyle.getProperty("SelectedIndex");
                }
                textStyleArray[j].setBGColor(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback"));
                textStyleArray[j].setFont(new Font(string, n, n2));
            }
        }
    }

    public final class SimpleEditorFilter
    extends DocumentFilter {
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            super.remove(filterBypass, n, n2);
            HighlightConfigurationPanel.this.rehighlight(n, n2, 0);
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(filterBypass, n, string, attributeSet);
            HighlightConfigurationPanel.this.rehighlight(n, 0, string.length());
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            super.replace(filterBypass, n, n2, string, attributeSet);
            HighlightConfigurationPanel.this.rehighlight(n, n2, string.length());
        }
    }

    private class ActionHandler
    implements UIActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                Color color = ((JButton)actionEvent.getSource()).getBackground();
                Color color2 = JColorChooser.showDialog(null, "Choose color", color);
                if (color2 == null) {
                    return;
                }
                if (!color.equals(color2)) {
                    HighlightConfigurationPanel.this.changesPending = true;
                }
                ((JButton)actionEvent.getSource()).setBackground(color2);
                HighlightConfigurationPanel.this.resetPreview();
            } else if (object instanceof JComboBox) {
                HighlightConfigurationPanel.this.changesPending = true;
                HighlightConfigurationPanel.this.resetPreview();
            } else if (object instanceof JCheckBox) {
                HighlightConfigurationPanel.this.changesPending = true;
                HighlightConfigurationPanel.this.resetPreview();
            }
        }
    }
}

