/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.BaseAlgoSummaryTablePanel;
import com.topcoder.client.contestApplet.widgets.AlgorithmCoderComponentRenderer;
import com.topcoder.client.contestApplet.widgets.ContestTableCellRenderer;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DivSummaryTablePanel
extends BaseAlgoSummaryTablePanel {
    public int totalRooms = 0;
    private RoundModel roundModel;
    private Integer divisionID;
    private Integer roomCount = new Integer(0);
    private UIComponent panel;

    public DivSummaryTablePanel(ContestApplet contestApplet, RoundModel roundModel, FrameLogic frameLogic, Integer n, UIPage uIPage) {
        super(contestApplet, frameLogic, false, uIPage);
        this.roundModel = roundModel;
        this.divisionID = n;
        this.panel = uIPage.getComponent("div_summary_table_panel");
        this.init(uIPage.getComponent("challenge_popup"), uIPage.getComponent("other_challenge_popup"), uIPage.getComponent("div_summary_table"), this.panel, uIPage.getComponent("source_menu"), uIPage.getComponent("info_menu"), uIPage.getComponent("history_menu"));
    }

    public void setDivision(Integer n) {
        this.tableModel.removeTableModelListener(this.tableModelListener);
        this.totalRooms = 0;
        this.divisionID = n;
        this.prepareForTableModel();
        this.tableModel = new BaseAlgoSummaryTablePanel.ChallengeTableModel();
        this.tableModel.addTableModelListener(this.tableModelListener);
        this.roomCount = new Integer(0);
        this.setupColumns();
    }

    private void setupColumns() {
        Object object;
        this.setTitle("(Loading...)");
        int n = this.getMaxProblemColumn();
        int n2 = (Integer)this.table.getProperty("ColumnCount");
        for (int i = 3; i < n2; ++i) {
            TableColumn tableColumn = (TableColumn)this.table.performAction("getColumn", new Object[]{new Integer(i)});
            this.table.performAction("removeColumn", new Object[]{tableColumn});
        }
        UIComponent uIComponent = this.page.getComponent("div_summary_problem_column_template");
        uIComponent.setProperty("CellRenderer", new AlgorithmCoderComponentRenderer((ContestTableCellRenderer)this.page.getComponent("base_problem_renderer").getEventSource(), this.getRoundModel()));
        this.table.setProperty("model", this.tableModel);
        n2 = this.tableModel.getColumnCount();
        for (int i = 3; i < n; ++i) {
            object = (TableColumn)uIComponent.performAction("clone");
            ((TableColumn)object).setModelIndex(i);
            ((TableColumn)object).setIdentifier(new Integer(i));
            this.table.performAction("addColumn", new Object[]{object});
            ((TableColumn)object).setHeaderRenderer((TableCellRenderer)uIComponent.getProperty("headerRenderer"));
        }
        if (this.hasFinalScoreColumn()) {
            Integer n3 = new Integer(n2 - 1);
            object = this.page.getComponent("div_summary_score_column");
            TableColumn tableColumn = (TableColumn)object.performAction("clone");
            tableColumn.setHeaderRenderer((TableCellRenderer)object.getProperty("headerRenderer"));
            tableColumn.setModelIndex(n3);
            tableColumn.setIdentifier(n3);
            this.table.performAction("addColumn", new Object[]{tableColumn});
        }
    }

    protected void initTable() {
        String string = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        this.page.getComponent("div_summary_table_header_renderer").setProperty("font", new Font(string, 0, n));
        this.page.getComponent("div_summary_user_renderer").setProperty("font", new Font(string, 0, n));
        this.page.getComponent("div_summary_user_renderer").setProperty("model", this.ca.getModel());
        this.page.getComponent("base_problem_renderer").setProperty("fontName", string);
        this.page.getComponent("base_problem_renderer").setProperty("fontSize", new Integer(n));
        this.page.getComponent("div_summary_cell_renderer").setProperty("fontName", string);
        this.page.getComponent("div_summary_cell_renderer").setProperty("fontSize", new Integer(n));
        this.setupColumns();
    }

    private String buildPrefixForTitle() {
        if (this.roundModel.getRoundProperties().hasDivisions()) {
            return "Division " + this.getDivisionID() + " ";
        }
        return "";
    }

    private void setTitle(String string) {
        ((TitledBorder)this.panel.getProperty("border")).setTitle(this.buildPrefixForTitle() + "Summary " + string);
        this.panel.performAction("repaint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChallengeTable(RoomModel roomModel) {
        if (roomModel == null) {
            return;
        }
        Integer n = this.roomCount;
        synchronized (n) {
            this.roomCount = new Integer(this.roomCount + 1);
            if (this.roomCount < this.totalRooms) {
                this.setTitle("(Loading... " + this.roomCount + "/" + this.totalRooms + ")");
            } else {
                this.setTitle("");
            }
        }
        this.getTableModel().updateChallengeTable();
    }

    protected RoundModel getRoundModel() {
        return this.roundModel;
    }

    protected Integer getDivisionID() {
        return this.divisionID;
    }

    public RoomModel getRoomByCoder(String string) {
        return this.getRoundModel().getRoomByCoder(string);
    }

    protected Collection getCoders() {
        ArrayList<Coder> arrayList = new ArrayList<Coder>(500);
        RoomModel[] roomModelArray = this.getRoundModel().getCoderRooms();
        for (int i = 0; i < roomModelArray.length; ++i) {
            if (roomModelArray[i].getDivisionID().intValue() != this.getDivisionID().intValue() || !roomModelArray[i].hasCoders()) continue;
            Coder[] coderArray = roomModelArray[i].getCoders();
            for (int j = 0; j < coderArray.length; ++j) {
                arrayList.add(coderArray[j]);
            }
        }
        return arrayList;
    }

    protected boolean isRoomLeader(String string) {
        return this.roundModel.isRoomLeader(string);
    }
}

