/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.frames.SourceFindDialog;
import com.topcoder.client.contestApplet.uilogic.views.ChallengeViewLogic;
import com.topcoder.client.contestApplet.uilogic.views.SourceViewerListener;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.render.ProblemRenderer;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyAdapter;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.netCommon.contestantMessages.response.data.ComponentChallengeData;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.HighlightedOutput;
import com.topcoder.util.syntaxhighlighter.HtmlOutput;
import com.topcoder.util.syntaxhighlighter.SyntaxHighlighter;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.text.html.HTMLDocument;

public class SourceViewer
implements Observer,
FrameLogic {
    private final UIComponent problemPane;
    private final UIComponent code;
    private final UIComponent status;
    private final UIComponent frame;
    private final ContestApplet contestApplet;
    private String writer;
    private CoderComponent coderComponent;
    private SyntaxHighlighter highlighter;
    private boolean enabled = true;
    private boolean showChallengeSucceeded = true;
    private UIComponent problemScroll;
    private UIComponent challengeButton = null;
    private UIComponent findButton = null;
    private SourceFindDialog findDialog;
    private SourceViewerListener challengePanel = null;
    private final boolean challengeable;
    private ProblemModel problem;
    private UIComponent splitPane;
    private UIPage page;
    private String oldText;
    private Language oldLanguage;
    private String oldHtml;
    private static SourceViewer otherViewer = null;
    private static Object viewerLock = new Object();
    private final LocalPreferences pref = LocalPreferences.getInstance();
    static /* synthetic */ Class class$com$topcoder$client$contestApplet$editors$Standard$StandardEditorPanel;

    public SourceViewer(ContestApplet contestApplet) {
        this(contestApplet, false);
    }

    public SourceViewer(ContestApplet contestApplet, boolean bl) {
        this(contestApplet, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceViewer(ContestApplet contestApplet, boolean bl, boolean bl2) {
        Object object = viewerLock;
        synchronized (object) {
            if (otherViewer != null && otherViewer != this) {
                otherViewer.closeWindow();
                otherViewer.dispose();
            }
            otherViewer = this;
        }
        this.contestApplet = contestApplet;
        this.page = contestApplet.getCurrentUIManager().getUIPage("source_viewer", true);
        this.frame = this.page.getComponent("root_frame");
        if (bl2) {
            this.code = this.page.getComponent("copy_code_pane");
            this.page.getComponent("code_pane").setProperty("Visible", Boolean.FALSE);
        } else {
            this.code = this.page.getComponent("code_pane");
            this.page.getComponent("copy_code_pane").setProperty("Visible", Boolean.FALSE);
        }
        this.problemPane = this.page.getComponent("problem_pane");
        this.status = this.page.getComponent("challenge_status");
        object = (Component)this.status.getEventSource();
        MouseListener[] mouseListenerArray = ((Component)object).getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            ((Component)object).removeMouseListener(mouseListenerArray[i]);
        }
        this.challengeable = bl;
        this.create();
        this.frame.addEventListener("window", new UIWindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SourceViewer.this.closeWindow();
            }
        });
    }

    public void dispose() {
        this.frame.performAction("dispose");
    }

    public void hide() {
        this.frame.performAction("hide");
    }

    public void show() {
        this.frame.performAction("show");
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            if (this.challengeable) {
                this.challengeButton.setProperty("Enabled", Boolean.TRUE);
            }
        } else if (this.challengeable) {
            this.challengeButton.setProperty("Enabled", Boolean.FALSE);
        }
    }

    public void setChallengeable(boolean bl) {
        if (this.challengeButton != null) {
            this.challengeButton.setProperty("Enabled", bl);
        }
    }

    public void setTitle(String string) {
        this.frame.setProperty("Title", string);
    }

    public void clear() {
        if (((Boolean)this.frame.getProperty("Visible")).booleanValue()) {
            return;
        }
        this.problemPane.setProperty("Text", "");
        ((JScrollBar)this.problemScroll.getProperty("VerticalScrollBar")).setValue(0);
        this.code.setProperty("Text", "");
        this.code.performAction("revalidate");
        this.oldText = null;
        this.oldLanguage = null;
        this.oldHtml = null;
    }

    public void setProblem(ProblemModel problemModel) {
        this.problem = problemModel;
    }

    public void setCode(String string, Language language) {
        Object object;
        String string2 = "";
        try {
            Object object2;
            object = this.pref.getConfigManager();
            if (!((ConfigManager)object).existsNamespace("com.topcoder.util.syntaxhighlighter")) {
                object2 = (class$com$topcoder$client$contestApplet$editors$Standard$StandardEditorPanel == null ? (class$com$topcoder$client$contestApplet$editors$Standard$StandardEditorPanel = SourceViewer.class$("com.topcoder.client.contestApplet.editors.Standard.StandardEditorPanel")) : class$com$topcoder$client$contestApplet$editors$Standard$StandardEditorPanel).getResource("/syntaxhighlighter/config.xml");
                ((ConfigManager)object).add((URL)object2);
            }
            this.highlighter = new SyntaxHighlighter();
            object2 = this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont");
            int n = 0;
            int n2 = this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize");
            for (int i = 0; i < this.highlighter.getLanguages().length; ++i) {
                TextStyle[] textStyleArray = this.highlighter.getLanguages()[i].getStyles();
                for (int j = 0; j < textStyleArray.length; ++j) {
                    if (textStyleArray[j].getName().equals("KEYWORD_STYLE")) {
                        textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords"));
                        n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywordsstyle", "0"));
                    } else if (textStyleArray[j].getName().equals("BLOCK_STYLE")) {
                        textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments"));
                        n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcommentsstyle", "0"));
                    } else if (textStyleArray[j].getName().equals("LITERAL_STYLE")) {
                        textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals"));
                        n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliteralsstyle", "0"));
                    } else if (textStyleArray[j].getName().equals("DEFAULT_STYLE")) {
                        textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault"));
                        n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefaultstyle", "0"));
                    }
                    textStyleArray[j].setBGColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
                    textStyleArray[j].setFont(new Font((String)object2, n, n2));
                }
            }
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
        try {
            if (this.pref.isViewerSyntaxHighlight() && string != null && !string.trim().equals("")) {
                object = new HtmlOutput(this.pref.getTabSize());
                try {
                    this.highlighter.highlightText(string, language.getName(), (HighlightedOutput)object);
                    string2 = ((HtmlOutput)object).getText();
                }
                catch (Exception exception) {
                    string2 = HtmlOutput.span(HtmlOutput.convertStringToHtml(string), new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
                }
            } else {
                string2 = HtmlOutput.span(HtmlOutput.convertStringToHtml(string), new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
            }
        }
        catch (StackOverflowError stackOverflowError) {
            string2 = HtmlOutput.span(HtmlOutput.convertStringToHtml(string), new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
        }
        if (this.oldText == null || !this.oldText.equals(string2) || this.oldLanguage == null || !this.oldLanguage.equals(language)) {
            this.oldText = string2;
            this.oldLanguage = language;
            this.code.setProperty("Text", string2);
            this.code.setProperty("CaretPosition", new Integer(0));
            this.code.performAction("revalidate");
        }
        this.refreshStatement();
        this.findDialog.setText(string);
        this.findDialog.setSyntaxHighlight(this.pref.isViewerSyntaxHighlight());
    }

    public void refreshStatement() {
        Language language = this.oldLanguage == null ? JavaLanguage.JAVA_LANGUAGE : this.oldLanguage;
        ProblemRenderer problemRenderer = new ProblemRenderer(this.problem.getProblem());
        problemRenderer.setForegroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        problemRenderer.setBackgroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        String string = "";
        try {
            string = problemRenderer.toHTML(language);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.oldHtml == null || !this.oldHtml.equals(string)) {
            this.problemPane.setProperty("Text", string);
            this.problemPane.setProperty("CaretPosition", new Integer(0));
            this.oldHtml = string;
        }
    }

    public void setWriter(String string) {
        this.writer = string;
    }

    public void setCoderComponent(CoderComponent coderComponent) {
        this.coderComponent = coderComponent;
        this.setChallengeable(false);
        if (coderComponent.getStatus() == 140) {
            this.status.setProperty("Text", "This problem has been successfully challenged.");
        } else {
            this.status.setProperty("Text", "");
        }
    }

    public void setPanel(SourceViewerListener sourceViewerListener) {
        this.challengePanel = sourceViewerListener;
    }

    private void create() {
        Serializable serializable;
        ((JScrollBar)this.page.getComponent("source_scroll_pane").getProperty("verticalscrollbar")).setUnitIncrement(13);
        this.problemScroll = this.page.getComponent("problem_description_scroll_pane");
        if (!this.challengeable) {
            this.page.getComponent("button_panel").setProperty("Visible", Boolean.FALSE);
        } else {
            this.createButtonPanel();
        }
        this.splitPane = this.page.getComponent("split_pane");
        this.pref.addSaveObserver(this);
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("body {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfont") + ";}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("body {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobontsize") + "pt;}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("pre {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfont") + ";}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("pre {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfontsize") + "pt;}");
        this.code.setProperty("Background", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
        this.code.setProperty("Foreground", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"));
        this.code.setProperty("DisabledTextColor", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"));
        Point point = this.pref.getLocation("com.topcoder.jmaContestApplet.frames.sourceViewer.location");
        if (point == null) {
            serializable = this.contestApplet.getCurrentFrame();
            point = serializable == null ? new Point(0, 0) : serializable.getLocation();
        }
        point = Common.adjustWindowLocation(point);
        this.frame.setProperty("Location", point);
        serializable = this.pref.getSize("com.topcoder.jmaContestApplet.frames.sourceViewer.size");
        if (serializable == null) {
            serializable = new Dimension(760, 360);
        }
        serializable = Common.adjustWindowSize(point, (Dimension)serializable);
        this.frame.setProperty("Size", serializable);
        String string = this.pref.getProperty("com.topcoder.jmaContestApplet.frames.sourceViewer.dividerloc");
        if (string == null) {
            string = "80";
        }
        this.splitPane.setProperty("DividerLocation", Integer.valueOf(string));
        this.findDialog = new SourceFindDialog(this.contestApplet, this.page.getComponent("source_code_panel"), this.code);
        this.frame.addEventListener("Key", new KeyHandler());
        this.page.getComponent("source_code_panel").addEventListener("Key", new KeyHandler());
        this.splitPane.addEventListener("Key", new KeyHandler());
    }

    private void createButtonPanel() {
        this.challengeButton = this.page.getComponent("challenge_button");
        this.challengeButton.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceViewer.this.challengeButtonEvent();
            }
        });
        this.findButton = this.page.getComponent("find_button");
        this.findButton.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceViewer.this.findButtonEvent();
            }
        });
    }

    private void challengeButtonEvent() {
        if (this.challengePanel instanceof ChallengeViewLogic) {
            ((ChallengeViewLogic)this.challengePanel).doChallenge(this.writer, this.coderComponent, this);
        }
    }

    private void findButtonEvent() {
        this.findDialog.show();
    }

    private void closeWindow() {
        if (!this.enabled) {
            return;
        }
        this.pref.removeSaveObserver(this);
        this.challengePanel.sourceViewerClosing();
        if (this.coderComponent != null && this.writer != null) {
            this.contestApplet.getRequester().requestCloseComponent(this.coderComponent.getComponent().getID(), this.writer);
        }
        this.pref.setLocation("com.topcoder.jmaContestApplet.frames.sourceViewer.location", (Point)this.frame.getProperty("Location"));
        this.pref.setSize("com.topcoder.jmaContestApplet.frames.sourceViewer.size", (Dimension)this.frame.getProperty("Size"));
        this.pref.setProperty("com.topcoder.jmaContestApplet.frames.sourceViewer.dividerloc", this.splitPane.getProperty("DividerLocation").toString());
        try {
            this.pref.savePreferences();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void notifyChallengeSucceeded(String string, String string2) {
        if (this.showChallengeSucceeded) {
            this.status.setProperty("Text", "This problem has been successfully challenged.");
            this.showChallengeSucceeded = false;
        }
    }

    public void doChallengeRequest(ArrayList arrayList) {
        ComponentChallengeData componentChallengeData = this.coderComponent.getComponent().getComponentChallengeData();
        if (((Boolean)arrayList.get(0)).booleanValue()) {
            String string = this.writer;
            this.contestApplet.setCurrentFrame((JFrame)this.frame.getEventSource());
            this.contestApplet.getInterFrame().showMessage("Challenging...", this.contestApplet.getCurrentFrame(), 0);
            this.contestApplet.getRequester().requestChallenge(string, componentChallengeData.getComponentID(), (ArrayList)arrayList.get(1));
        }
        if (this.challengePanel instanceof ChallengeViewLogic) {
            ((ChallengeViewLogic)this.challengePanel).setOldArgs((ArrayList)arrayList.get(1), componentChallengeData.getComponentID());
        }
    }

    public void update(Observable observable, Object object) {
        try {
            this.code.setProperty("Font", new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")));
            this.code.setProperty("Background", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
            this.code.setProperty("Foreground", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"));
            this.code.setProperty("DisabledTextColor", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class KeyHandler
    extends UIKeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 70: {
                    if (!keyEvent.isAltDown()) break;
                    keyEvent.consume();
                    SourceViewer.this.findButtonEvent();
                    return;
                }
                case 114: {
                    keyEvent.consume();
                    SourceViewer.this.findDialog.findAgain();
                    return;
                }
            }
        }
    }
}

