/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.PracticeSystestResultsSummaryPanel;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResponse;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResultResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PracticeSystestResultsFrame
implements FrameLogic {
    private UIComponent frame;
    private UIPage page;
    private ContestApplet parentFrame = null;
    private PracticeSystestResultsSummaryPanel summaryPanel = null;
    private UIComponent progress = null;
    private UIComponent statusLabelTemplate = null;
    private Map testCounts = null;
    private Map testsCompleted = null;
    private Map statusMap = null;
    private UIComponent status = null;
    private Map labelMap = null;
    private static ProblemComponentModel[] components = null;
    private boolean enabled = true;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.summaryPanel.setPanelEnabled(bl);
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public void update(PracticeSystemTestResultResponse practiceSystemTestResultResponse) {
        this.summaryPanel.update(practiceSystemTestResultResponse);
        if (practiceSystemTestResultResponse.getResultData().isSucceeded()) {
            this.testsCompleted.put(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId()), new Integer((Integer)this.testsCompleted.get(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId())) + 1));
        } else {
            this.statusMap.put(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId()), new Boolean(false));
            this.testsCompleted.put(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId()), new Integer((Integer)this.testCounts.get(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId()))));
        }
        this.checkLabel(practiceSystemTestResultResponse.getResultData().getComponentId());
        this.updateProgressStatus();
    }

    public static int getCompVal(int n) {
        for (int i = 0; i < components.length; ++i) {
            if (n != components[i].getID().intValue()) continue;
            return components[i].getPoints().intValue();
        }
        return 0;
    }

    private void checkLabel(int n) {
        int n2 = (Integer)this.testsCompleted.get(new Integer(n));
        int n3 = (Integer)this.testCounts.get(new Integer(n));
        boolean bl = (Boolean)this.statusMap.get(new Integer(n));
        JLabel jLabel = (JLabel)this.labelMap.get(new Integer(n));
        if (!bl) {
            jLabel.setForeground((Color)this.page.getComponent("status_error_color").getEventSource());
        } else if (n2 == n3) {
            jLabel.setForeground((Color)this.page.getComponent("status_finish_color").getEventSource());
        }
    }

    private void updateProgressStatus() {
        int n = 0;
        Iterator iterator = this.testsCompleted.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            n += ((Integer)this.testsCompleted.get(k)).intValue();
        }
        this.progress.setProperty("Value", new Integer(n));
        this.progress.setProperty("String", n + "/" + this.getTotalTestCount());
    }

    public void reset(PracticeSystemTestResponse practiceSystemTestResponse) {
        this.summaryPanel.getTableModel().clear();
        this.summaryPanel.reset();
        this.status.performAction("removeAll");
        RoomModel roomModel = this.parentFrame.getModel().getCurrentRoom();
        RoundModel roundModel = roomModel.getRoundModel();
        components = roundModel.getAssignedComponents(roomModel.getDivisionID());
        this.testCounts = practiceSystemTestResponse.getTestCaseCountByComponentId();
        this.testsCompleted = new HashMap();
        this.statusMap = new HashMap();
        this.labelMap = new HashMap();
        int n = 0;
        ArrayList arrayList = new ArrayList();
        Iterator<Object> iterator = this.testCounts.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        Collections.sort(arrayList, new PointValueComparator());
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            int n2 = (Integer)object;
            this.testsCompleted.put(object, new Integer(0));
            this.statusMap.put(object, new Boolean(true));
            JLabel jLabel = (JLabel)this.statusLabelTemplate.performAction("clone");
            jLabel.setText("" + PracticeSystestResultsFrame.getCompVal(n2));
            GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            Common.insertInPanel(jLabel, (JPanel)this.status.getEventSource(), gridBagConstraints, n, 0, 1, 1, 1.0, 1.0);
            this.labelMap.put(object, jLabel);
            ++n;
        }
        this.progress.setProperty("Maximum", new Integer(this.getTotalTestCount()));
        this.progress.setProperty("Value", new Integer(0));
    }

    private int getTotalTestCount() {
        int n = 0;
        Iterator iterator = this.testCounts.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            n += ((Integer)this.testCounts.get(k)).intValue();
        }
        return n;
    }

    public PracticeSystestResultsFrame(ContestApplet contestApplet) {
        this.parentFrame = contestApplet;
        this.page = contestApplet.getCurrentUIManager().getUIPage("practice_systest_results_frame", true);
        this.frame = this.page.getComponent("root_frame");
        this.statusLabelTemplate = this.page.getComponent("status_label_template");
        this.create();
    }

    public void showFrame() {
        Common.setLocationRelativeTo((Component)this.parentFrame.getCurrentFrame(), (JFrame)this.frame.getEventSource());
        this.frame.performAction("show");
        MoveFocus.moveFocus(this.summaryPanel.getTable());
    }

    public void create() {
        this.progress = this.page.getComponent("progress_bar");
        this.status = this.page.getComponent("status_panel");
        this.summaryPanel = new PracticeSystestResultsSummaryPanel(this.parentFrame, this.page);
        this.frame.performAction("pack");
    }

    private class PointValueComparator
    implements Comparator {
        private PointValueComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            int n3 = PracticeSystestResultsFrame.getCompVal(n);
            int n4 = PracticeSystestResultsFrame.getCompVal(n2);
            int n5 = n3 - n4;
            return n5;
        }
    }
}

