/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.netClient.ResponseWaiter;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import java.awt.Component;

public class MessageFrame
implements FrameLogic {
    private UIPage page;
    private UIComponent frame;
    private UIComponent message;
    private final ContestApplet ca;
    private final Component baseComp;
    private ResponseWaiter rw;

    public UIComponent getFrame() {
        return this.frame;
    }

    public MessageFrame(String string, Component component, ContestApplet contestApplet) {
        this.ca = contestApplet;
        this.baseComp = component;
        this.page = contestApplet.getCurrentUIManager().getUIPage("message_frame", true);
        this.frame = this.page.getComponent("root_frame");
        this.message = this.page.getComponent("message");
        this.frame.setProperty("title", string);
        this.frame.performAction("pack");
    }

    public void showMessage(String string, int n) {
        this.showMessage(string, this.baseComp, n);
    }

    public void showMessage(String string, Component component, final int n) {
        this.terminate();
        this.message.setProperty("Text", string);
        Common.setLocationRelativeTo(component, (Component)this.frame.getEventSource());
        this.rw = new ResponseWaiter();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (MessageFrame.this.rw.block()) {
                    MessageFrame.this.ca.getRoomManager().getCurrentRoom().timeOutEvent(n);
                    MessageFrame.this.timeOut();
                }
            }
        });
        thread.start();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame.performAction("show");
    }

    public void hideMessage() {
        this.frame.performAction("hide");
        this.terminate();
    }

    private void terminate() {
        if (this.rw != null) {
            this.rw.unBlock();
        }
    }

    private void timeOut() {
        this.message.setProperty("Text", "Your request timed out.");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame.performAction("hide");
    }
}

