/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.HyperLinkLoader;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.DynamicEditor;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.contestApplet.editors.PluginManager;
import com.topcoder.client.contestApplet.rooms.CoderRoom;
import com.topcoder.client.contestApplet.rooms.CoderRoomInterface;
import com.topcoder.client.contestApplet.rooms.TeamCoderRoom;
import com.topcoder.client.contestApplet.uilogic.components.BroadcastButton;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.frames.MessageDialog;
import com.topcoder.client.contestApplet.uilogic.panels.CodingTimerPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ProblemInfoComponent;
import com.topcoder.client.contestApplet.uilogic.panels.ProblemInfoPanel;
import com.topcoder.client.contestApplet.uilogic.panels.TimerPanel;
import com.topcoder.client.contestApplet.unusedCodeProcessor.UCRProcessor;
import com.topcoder.client.contestApplet.unusedCodeProcessor.UCRProcessorFactory;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.render.ProblemComponentRenderer;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyListener;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.netCommon.contest.round.RoundProperties;
import com.topcoder.shared.language.BaseLanguage;
import com.topcoder.shared.language.CPPLanguage;
import com.topcoder.shared.language.CSharpLanguage;
import com.topcoder.shared.language.CStyleLanguage;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.language.PythonLanguage;
import com.topcoder.shared.language.VBLanguage;
import com.topcoder.shared.problem.DataType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;

public class CodingFrame
implements FrameLogic {
    private static final boolean DEBUG = Boolean.getBoolean("com.topcoder.client.contestApplet.frames.CodingFrame");
    private ContestApplet parentFrame = null;
    protected UIPage page;
    private CodingTimerPanel timerPanel = null;
    private ProblemInfoComponent problemPanel = null;
    private UIComponent problemPane;
    public UIComponent problemScroll = null;
    private UIComponent editorPanel = null;
    private UIComponent jsp;
    private UIComponent connStatus;
    protected UIComponent[] buttons;
    private BroadcastButton broadcastButton;
    private UIComponent javaRadioButton;
    private UIComponent cplusplusRadioButton;
    private UIComponent csharpRadioButton;
    private UIComponent vbRadioButton;
    private UIComponent pythonRadioButton;
    private UIComponent editorList;
    private UIComponent frame;
    private boolean isSaved = true;
    private Language currentLanguage = JavaLanguage.JAVA_LANGUAGE;
    private boolean enabled = true;
    private RoomModel roomModel;
    private LocalPreferences pref = LocalPreferences.getInstance();
    private DynamicEditor dynamicEditor;
    private HashMap editorDefs = new HashMap();
    private boolean ignoreToggleEvent = false;
    private String compiledSource = "";
    private ProblemComponentModel component;
    private CoderRoomInterface cr;
    public int testComponentID;
    private ContestSponsorPanel sponsorPanel;
    HashMap keyPrefs = new HashMap();
    HashMap keyButtons = new HashMap();
    private UIKeyListener kl = new UIKeyListener(){
        long lastTime = 0L;
        int lastKey = 0;

        public void keyPressed(KeyEvent keyEvent) {
            if (this.lastKey == keyEvent.getKeyCode() && System.currentTimeMillis() - this.lastTime < 500L) {
                return;
            }
            this.lastTime = System.currentTimeMillis();
            this.lastKey = keyEvent.getKeyCode();
            Iterator iterator = CodingFrame.this.keyPrefs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!CodingFrame.this.checkValue(keyEvent, (String)CodingFrame.this.keyPrefs.get(string))) continue;
                keyEvent.consume();
                UIComponent uIComponent = (UIComponent)CodingFrame.this.keyButtons.get(string);
                uIComponent.performAction("doClick");
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    };

    public CodingFrame(ContestApplet contestApplet) {
        this(contestApplet, contestApplet.getCurrentUIManager().getUIPage("coding_frame", true));
    }

    protected CodingFrame(ContestApplet contestApplet, UIPage uIPage) {
        this.page = uIPage;
        this.parentFrame = contestApplet;
        this.problemPane = uIPage.getComponent("problem_pane");
        this.frame = uIPage.getComponent("root_frame");
        if (System.getProperty("com.topcoder.client.contestApplet.frames.codingframe.nocopypaste") != null) {
            this.problemPane.setProperty("ClipboardEnabled", Boolean.FALSE);
        } else {
            this.problemPane.setProperty("ClipboardEnabled", Boolean.TRUE);
        }
        if (DEBUG) {
            System.out.println("Creating");
        }
        this.frame.addEventListener("window", new UIWindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CodingFrame.this.unsetupKeyListener(CodingFrame.this.kl, (Container)CodingFrame.this.frame.getProperty("ContentPane"));
                CodingFrame.this.closeCodingWindow();
            }
        });
        this.problemPane.addEventListener("hyperlink", new HyperLinkLoader(this.parentFrame.getAppletContext()));
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public void setCR(CoderRoomInterface coderRoomInterface) {
        this.cr = coderRoomInterface;
    }

    private void unsetupKeyListener(UIKeyListener uIKeyListener, Container container) {
        container.removeKeyListener(uIKeyListener);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (container instanceof Container) {
                this.unsetupKeyListener(uIKeyListener, (Container)container.getComponent(i));
                continue;
            }
            this.unsetupKeyListener(uIKeyListener, container.getComponent(i));
        }
    }

    private void unsetupKeyListener(UIKeyListener uIKeyListener, Component component) {
        component.removeKeyListener(uIKeyListener);
    }

    public void doTest(ArrayList arrayList) {
        ArrayList arrayList2 = null;
        try {
            arrayList2 = (ArrayList)arrayList.get(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.cr instanceof CoderRoom) {
            ((CoderRoom)this.cr).setArgs(arrayList2);
            this.cr = null;
        } else if (this.cr instanceof TeamCoderRoom) {
            ((TeamCoderRoom)this.cr).setArgs(arrayList2);
            this.cr = null;
        }
        if (((Boolean)arrayList.get(0)).booleanValue()) {
            this.test(arrayList, this.testComponentID);
        } else {
            this.setButtons(true, true, true, false, false, true, true, true);
        }
    }

    private void test(ArrayList arrayList, int n) {
        if (this.enabled) {
            this.parentFrame.getInterFrame().showMessage("Testing...", (JFrame)this.frame.getEventSource(), 15);
            this.parentFrame.getRequester().requestTest((ArrayList)arrayList.get(1), n);
        }
    }

    public void dispose() {
        if (DEBUG) {
            System.out.println("dispose: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor != null) {
            PluginManager.getInstance().disposeEditor(this.dynamicEditor);
            this.dynamicEditor = null;
        }
        this.frame.performAction("dispose");
    }

    public void hide() {
        if (DEBUG) {
            System.out.println("hide: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor != null) {
            PluginManager.getInstance().disposeEditor(this.dynamicEditor);
            this.dynamicEditor = null;
        }
        this.frame.performAction("hide");
    }

    public void setVisible(boolean bl) {
        if (DEBUG) {
            System.out.println("setVisible: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor != null) {
            PluginManager.getInstance().disposeEditor(this.dynamicEditor);
            this.dynamicEditor = null;
        }
        this.frame.setProperty("Visible", bl);
    }

    public void clear() {
        this.problemPane.setProperty("Text", "");
        ((JScrollBar)this.problemScroll.getProperty("VerticalScrollBar")).setValue(0);
        if (this.dynamicEditor != null) {
            this.dynamicEditor.clear();
        }
    }

    public void resetFocus() {
        MoveFocus.moveFocus(this.editorList);
        MoveFocus.moveFocus(this.editorPanel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CodingFrame.this.editorPanel.performAction("requestFocus");
            }
        });
    }

    public void showFrame(boolean bl) {
        if (DEBUG) {
            System.out.println("showFrame: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor == null) {
            this.setEditor(this.getDefaultEditor(), null);
        }
        this.updateLanguageButtonStatus();
        this.enableText(bl);
        this.frame.performAction("show");
        this.resetFocus();
    }

    public String getCode() {
        if (this.dynamicEditor == null) {
            return "";
        }
        String string = this.getSourceCode();
        return string == null ? "" : string;
    }

    public TimerPanel getTimerPanel() {
        return this.timerPanel;
    }

    public void updateComponentInfo(ProblemComponentModel problemComponentModel) {
        this.component = problemComponentModel;
        this.setLanguage(this.getDefaultLanguage());
        if (DEBUG) {
            System.out.println("updateComponentInfo: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor == null) {
            this.setEditor(this.getDefaultEditor(), this.component.getDefaultSolution());
        } else {
            this.setEditor((String)this.editorList.getProperty("SelectedItem"), this.component.getDefaultSolution());
        }
    }

    protected ProblemInfoComponent newProblemInfoPanel() {
        return new ProblemInfoPanel(this.parentFrame, this.page);
    }

    public void create() {
        Serializable serializable;
        this.timerPanel = new CodingTimerPanel(this.parentFrame, this.page);
        this.problemPanel = this.newProblemInfoPanel();
        this.createSourceCodePanel();
        this.createButtonPanel();
        this.createEditorTogglePanel();
        this.jsp = this.page.getComponent("problem_editor_split_pane");
        this.problemPane.setProperty("Font", new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.problemfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.problemfontsize")));
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("body {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.problemfont") + ";}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("body {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.problemfontsize") + "pt;}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("pre {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedfont") + ";}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("pre {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedfontsize") + "pt;}");
        this.problemPane.setProperty("Foreground", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        this.problemPane.setProperty("Background", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        this.problemScroll = this.page.getComponent("problem_description_scroll_pane");
        this.setButtons(false, false, false, false, false, false, false, false);
        this.connStatus = this.page.getComponent("connection_status");
        this.sponsorPanel = this.newUnderProblemInfoPanel();
        this.frame.performAction("pack");
        this.setupKeyListener(this.kl, (Container)this.frame.getProperty("ContentPane"));
        Point point = this.pref.getLocation("com.topcoder.jmaContestApplet.frames.codingframe.location");
        if (point == null) {
            serializable = this.parentFrame.getCurrentFrame();
            point = serializable == null ? new Point(0, 0) : serializable.getLocation();
        }
        point = Common.adjustWindowLocation(point);
        this.frame.setProperty("Location", point);
        serializable = this.pref.getSize("com.topcoder.jmaContestApplet.frames.codingframe.size");
        if (serializable == null) {
            serializable = new Dimension(760, 360);
        }
        this.frame.setProperty("Size", Common.adjustWindowSize(point, (Dimension)serializable));
        String string = this.pref.getProperty("com.topcoder.jmaContestApplet.frames.codingframe.dividerloc");
        if (string == null) {
            string = "80";
        }
        this.jsp.setProperty("DividerLocation", Integer.valueOf(string));
    }

    protected ContestSponsorPanel newUnderProblemInfoPanel() {
        return new ContestSponsorPanel(this.page.getComponent("sponsor_logo"), this.getCodingFrameSponsorURLString());
    }

    protected String getCodingFrameSponsorURLString() {
        return CommonData.getSponsorCodingFrameImageAddr(this.parentFrame.getSponsorName(), this.getRoomModel());
    }

    private boolean checkValue(KeyEvent keyEvent, String string) {
        String[] stringArray = string.split("\\+");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if ((keyEvent.getModifiers() & 2) != 0) {
            bl2 = true;
        }
        if ((keyEvent.getModifiers() & 8) != 0) {
            bl = true;
        }
        if ((keyEvent.getModifiers() & 1) != 0) {
            bl3 = true;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].equals("Ctrl")) {
                bl2 = false;
                if ((keyEvent.getModifiers() & 2) != 0) continue;
                return false;
            }
            if (stringArray[i].equals("Alt")) {
                bl = false;
                if ((keyEvent.getModifiers() & 8) != 0) continue;
                return false;
            }
            if (!stringArray[i].equals("Shift")) continue;
            bl3 = false;
            if ((keyEvent.getModifiers() & 1) != 0) continue;
            return false;
        }
        if (bl2 || bl || bl3) {
            return false;
        }
        return stringArray[stringArray.length - 1].equals(KeyEvent.getKeyText(keyEvent.getKeyCode()));
    }

    private void setupKeyListener(UIKeyListener uIKeyListener, Container container) {
        container.removeKeyListener(uIKeyListener);
        container.addKeyListener(uIKeyListener);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (container instanceof Container) {
                this.setupKeyListener(uIKeyListener, (Container)container.getComponent(i));
                continue;
            }
            this.setupKeyListener(uIKeyListener, container.getComponent(i));
        }
    }

    private void setupKeyListener(UIKeyListener uIKeyListener, Component component) {
        component.removeKeyListener(uIKeyListener);
        component.addKeyListener(uIKeyListener);
    }

    private void createEditorTogglePanel() {
        int n;
        List<EditorPlugin> list = Arrays.asList(PluginManager.getInstance().getEditorPlugins());
        String[] stringArray = new String[list.size()];
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            EditorPlugin editorPlugin = list.get(n);
            this.editorDefs.put(editorPlugin.getName(), editorPlugin);
            stringArray[n] = editorPlugin.getName();
        }
        Arrays.sort(stringArray, Collator.getInstance());
        this.editorList = this.page.getComponent("editor_list");
        this.editorList.performAction("removeAllItems");
        for (n = 0; n < stringArray.length; ++n) {
            this.editorList.performAction("addItem", new Object[]{stringArray[n]});
        }
        this.editorList.setProperty("UI", this.editorList.getProperty("UI"));
        this.editorList.setProperty("SelectedItem", this.getDefaultEditor());
        UIActionListener uIActionListener = new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.languageToggleEvent(actionEvent);
            }
        };
        this.javaRadioButton = this.page.getComponent("java_radio_button");
        this.javaRadioButton.addEventListener("action", uIActionListener);
        this.cplusplusRadioButton = this.page.getComponent("c++_radio_button");
        this.cplusplusRadioButton.addEventListener("action", uIActionListener);
        this.csharpRadioButton = this.page.getComponent("c#_radio_button");
        this.csharpRadioButton.addEventListener("action", uIActionListener);
        this.vbRadioButton = this.page.getComponent("vb_radio_button");
        this.vbRadioButton.addEventListener("action", uIActionListener);
        this.pythonRadioButton = this.page.getComponent("python_radio_button");
        this.pythonRadioButton.addEventListener("action", uIActionListener);
        this.editorList.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!CodingFrame.this.ignoreToggleEvent) {
                    CodingFrame.this.editorToggleEvent();
                }
            }
        });
    }

    private void createSourceCodePanel() {
        this.editorPanel = this.page.getComponent("editor_panel");
    }

    public boolean isPanelEnabled() {
        return this.enabled;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.connStatus.setProperty("Enabled", bl);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setProperty("Enabled", bl);
        }
        this.broadcastButton.setEnabled(bl);
    }

    protected Map createButtonDef() {
        HashMap<String, ButtonDef> hashMap = new HashMap<String, ButtonDef>();
        hashMap.put("save_button", new ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.saveButtonEvent();
            }
        }, "com.topcoder.client.contestApplet.common.LocalPreferences.keysave"));
        hashMap.put("clear_button", new ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.clearButtonEvent();
            }
        }, null));
        hashMap.put("compile_button", new ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.compileButtonEvent();
            }
        }, "com.topcoder.client.contestApplet.common.LocalPreferences.keycompile"));
        hashMap.put("test_button", new ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.testButtonEvent();
            }
        }, "com.topcoder.client.contestApplet.common.LocalPreferences.keytest"));
        hashMap.put("submit_button", new ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.submitButtonEvent();
            }
        }, "com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit"));
        return hashMap;
    }

    private void createButtonPanel() {
        Map map = this.createButtonDef();
        this.buttons = new UIComponent[map.size()];
        int n = 0;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ButtonDef buttonDef = (ButtonDef)entry.getValue();
            this.buttons[n] = this.page.getComponent((String)entry.getKey());
            this.buttons[n].addEventListener("action", buttonDef.listener);
            if (buttonDef.hotKey != null) {
                this.keyPrefs.put(buttonDef.hotKey, this.pref.getHotKey(buttonDef.hotKey));
                this.keyButtons.put(buttonDef.hotKey, this.buttons[n]);
            }
            ++n;
        }
        this.broadcastButton = new BroadcastButton(this.parentFrame, this.page.getComponent("broadcast_button"));
    }

    public void enableText(boolean bl) {
        if (this.dynamicEditor == null) {
            return;
        }
        this.dynamicEditor.setTextEnabled(new Boolean(bl));
        this.editorList.setProperty("Enabled", bl && this.isEditorAllowed());
    }

    protected boolean isEditorAllowed() {
        return true;
    }

    public void updateCompile(boolean bl, String string) {
        if (this.dynamicEditor == null) {
            return;
        }
        if (!this.dynamicEditor.setCompileResults(bl, string)) {
            if (bl) {
                Common.showMessage("Compile Results", string, (JFrame)this.frame.getEventSource());
                this.setButtons(true, true, true, false, false, true, true, true);
            } else {
                MessageDialog messageDialog = new MessageDialog(this.parentFrame, this.frame, "Compiler Results", string);
                messageDialog.showDialog();
                this.setButtons(true, true, true, false, false, false, true, false);
            }
        }
    }

    public void setButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.isSaved = !bl4;
    }

    private Language getDefaultLanguage() {
        Integer n = new Integer(0);
        HashMap hashMap = this.parentFrame.getModel().getUserInfo().getPreferences();
        if (hashMap.containsKey(n)) {
            if ((Integer)hashMap.get(n) == 0) {
                return JavaLanguage.JAVA_LANGUAGE;
            }
            return BaseLanguage.getLanguage((Integer)hashMap.get(n));
        }
        return JavaLanguage.JAVA_LANGUAGE;
    }

    protected String getDefaultEditor() {
        String string = PluginManager.getInstance().getDefaultEditorName();
        if (!string.equals("")) {
            return string;
        }
        return "Standard";
    }

    private void setLanguage(Language language) {
        if (language.getId() == 0) {
            language = this.getDefaultLanguage();
        }
        if (language.getId() == 1 && ((Boolean)this.javaRadioButton.getProperty("Visible")).booleanValue()) {
            this.javaRadioButton.setProperty("Selected", Boolean.TRUE);
        } else if (language.getId() == 3 && ((Boolean)this.cplusplusRadioButton.getProperty("Visible")).booleanValue()) {
            this.cplusplusRadioButton.setProperty("Selected", Boolean.TRUE);
        } else if (language.getId() == 4 && ((Boolean)this.csharpRadioButton.getProperty("Visible")).booleanValue()) {
            this.csharpRadioButton.setProperty("Selected", Boolean.TRUE);
        } else if (language.getId() == 5 && ((Boolean)this.vbRadioButton.getProperty("Visible")).booleanValue()) {
            this.vbRadioButton.setProperty("Selected", Boolean.TRUE);
        } else if (language.getId() == 6 && ((Boolean)this.pythonRadioButton.getProperty("Visible")).booleanValue()) {
            this.pythonRadioButton.setProperty("Selected", Boolean.TRUE);
        } else if (((Boolean)this.javaRadioButton.getProperty("Visible")).booleanValue()) {
            language = JavaLanguage.JAVA_LANGUAGE;
            this.javaRadioButton.setProperty("Selected", Boolean.TRUE);
        } else if (((Boolean)this.cplusplusRadioButton.getProperty("Visible")).booleanValue()) {
            language = CPPLanguage.CPP_LANGUAGE;
            this.cplusplusRadioButton.setProperty("Selected", Boolean.TRUE);
        } else if (((Boolean)this.csharpRadioButton.getProperty("Visible")).booleanValue()) {
            language = CSharpLanguage.CSHARP_LANGUAGE;
            this.csharpRadioButton.setProperty("Selected", Boolean.TRUE);
        } else {
            language = JavaLanguage.JAVA_LANGUAGE;
        }
        this.currentLanguage = language;
    }

    public int getLanguage() {
        int n = 1;
        if (((Boolean)this.javaRadioButton.getProperty("Selected")).booleanValue()) {
            n = 1;
        } else if (((Boolean)this.cplusplusRadioButton.getProperty("Selected")).booleanValue()) {
            n = 3;
        } else if (((Boolean)this.csharpRadioButton.getProperty("Selected")).booleanValue()) {
            n = 4;
        } else if (((Boolean)this.vbRadioButton.getProperty("Selected")).booleanValue()) {
            n = 5;
        } else if (((Boolean)this.pythonRadioButton.getProperty("Selected")).booleanValue()) {
            n = 6;
        }
        return n;
    }

    public void updateLanguageButtonStatus() {
        RoundProperties roundProperties = this.getRoomModel().getRoundModel().getRoundProperties();
        this.javaRadioButton.setProperty("enabled", roundProperties.allowsLanguage(JavaLanguage.JAVA_LANGUAGE));
        this.cplusplusRadioButton.setProperty("enabled", roundProperties.allowsLanguage(CPPLanguage.CPP_LANGUAGE));
        this.csharpRadioButton.setProperty("enabled", roundProperties.allowsLanguage(CSharpLanguage.CSHARP_LANGUAGE));
        this.vbRadioButton.setProperty("enabled", roundProperties.allowsLanguage(VBLanguage.VB_LANGUAGE));
        this.pythonRadioButton.setProperty("enabled", roundProperties.allowsLanguage(PythonLanguage.PYTHON_LANGUAGE));
    }

    public void setEditor(String string, String string2) {
        EditorPlugin editorPlugin;
        if (string2 == null) {
            String string3 = string2 = this.dynamicEditor == null ? "" : this.getSourceCode();
        }
        if (this.dynamicEditor != null) {
            PluginManager.getInstance().disposeEditor(this.dynamicEditor);
        }
        if (this.dynamicEditor != null) {
            this.unsetupKeyListener(this.kl, this.dynamicEditor.getEditorPanel());
        }
        if ((editorPlugin = (EditorPlugin)this.editorDefs.get(string)) == null) {
            Common.showMessage("Unknown Editor", "Your default editor points to a non existing editor.  Switching to 'Standard' editor instead", (JFrame)this.frame.getEventSource());
            string = "Standard";
        }
        if (DEBUG) {
            System.out.println("SetEditor: " + string);
        }
        this.createDynamicEditor(string);
        this.editorPanel.performAction("removeAll");
        JPanel jPanel = this.dynamicEditor.getEditorPanel();
        if (jPanel != null) {
            jPanel.setRequestFocusEnabled(true);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (jPanel != null) {
            this.editorPanel.performAction("add", new Object[]{jPanel, gridBagConstraints});
        }
        this.setupKeyListener(this.kl, jPanel);
        this.editorPanel.performAction("invalidate");
        this.editorPanel.performAction("repaint");
        ProblemComponentRenderer problemComponentRenderer = new ProblemComponentRenderer(this.component.getComponent());
        problemComponentRenderer.setForegroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        problemComponentRenderer.setBackgroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        String string4 = null;
        String string5 = null;
        try {
            string4 = problemComponentRenderer.toHTML(this.currentLanguage);
            string5 = problemComponentRenderer.toPlainText(this.currentLanguage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string6 = this.component.getClassName();
        String string7 = this.component.getMethodName();
        DataType[] dataTypeArray = this.component.getParamTypes();
        DataType dataType = this.component.getReturnType();
        this.problemPane.setProperty("Text", string4);
        this.problemPane.setProperty("CaretPosition", new Integer(0));
        this.problemPanel.updateComponentInfo(this.component, this.getCurrentLanguageId());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < dataTypeArray.length; ++i) {
            arrayList.add(dataTypeArray[i].getDescriptor(this.getCurrentLanguageId()));
        }
        this.dynamicEditor.setLanguage(new Integer(this.getCurrentLanguageId()));
        this.dynamicEditor.setProblem(string5);
        this.dynamicEditor.setSignature(string6, string7, arrayList, dataType.getDescriptor(this.currentLanguage));
        this.dynamicEditor.setProblemComponent(this.component, this.currentLanguage, problemComponentRenderer);
        this.dynamicEditor.setSource(string2);
    }

    private void createDynamicEditor(final String string) {
        if (DEBUG) {
            System.out.println("CreateDynamicEditor: " + string);
        }
        if (!this.editorList.getProperty("SelectedItem").equals(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodingFrame.this.ignoreToggleEvent = true;
                    CodingFrame.this.editorList.setProperty("SelectedItem", string);
                    CodingFrame.this.ignoreToggleEvent = false;
                }
            });
        }
        try {
            this.dynamicEditor = PluginManager.getInstance().getEditor(string);
        }
        catch (InstantiationError instantiationError) {
            if (string.equals("Standard")) {
                Common.showMessage("Major Error", "Could not instantiate the STANDARD editor - Something is definately whacko", (JFrame)this.frame.getEventSource());
            } else {
                Common.showMessage("Instantiation Error", "Could not instantiate the editor " + string + " (see the java console for details).  Switching to 'Standard' editor instead", (JFrame)this.frame.getEventSource());
                this.createDynamicEditor("Standard");
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (string.equals("Standard")) {
                Common.showMessage("Major Error", "Could not instantiate the STANDARD editor - Something is definately whacko", (JFrame)this.frame.getEventSource());
            }
            Common.showMessage("Editor Plugin Error", "The editor " + string + " does not implement the required methods for an editor plugin.  Switching to 'Standard' editor instead", (JFrame)this.frame.getEventSource());
            this.createDynamicEditor("Standard");
        }
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    private void editorToggleEvent() {
        if (DEBUG) {
            System.out.println("editorToggleEvent: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        this.setEditor((String)this.editorList.getProperty("SelectedItem"), null);
    }

    private void languageToggleEvent(ActionEvent actionEvent) {
        if (DEBUG) {
            System.out.println("languageToggleEvent: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        String string = actionEvent.getActionCommand();
        int n = this.getCurrentLanguageId();
        CStyleLanguage cStyleLanguage = null;
        if (string.equals("Java")) {
            cStyleLanguage = JavaLanguage.JAVA_LANGUAGE;
        } else if (string.equals("C++")) {
            cStyleLanguage = CPPLanguage.CPP_LANGUAGE;
        } else if (string.equals("C#")) {
            cStyleLanguage = CSharpLanguage.CSHARP_LANGUAGE;
        } else if (string.equals("VB")) {
            cStyleLanguage = VBLanguage.VB_LANGUAGE;
        } else if (string.equals("Python")) {
            cStyleLanguage = PythonLanguage.PYTHON_LANGUAGE;
        } else {
            throw new RuntimeException("unknown language: " + string);
        }
        if (cStyleLanguage.getId() == n) {
            return;
        }
        this.setLanguage(cStyleLanguage);
        this.setEditor((String)this.editorList.getProperty("SelectedItem"), null);
    }

    private void saveButtonEvent() {
        this.isSaved = true;
        this.parentFrame.setCurrentFrame((JFrame)this.frame.getEventSource());
        this.save();
    }

    private void save() {
        if (this.enabled) {
            this.parentFrame.getInterFrame().showMessage("Saving code...", (JFrame)this.frame.getEventSource(), 34);
            this.parentFrame.getRequester().requestSave(this.getComponentId(), this.getSourceCode(), this.getCurrentLanguageId());
        }
    }

    protected long getComponentId() {
        return this.component.getID();
    }

    protected int getCurrentLanguageId() {
        return this.currentLanguage.getId();
    }

    private void clearButtonEvent() {
        if (this.enabled && Common.confirm("Warning", "Are you sure you want to delete your source code?", (JFrame)this.frame.getEventSource())) {
            this.dynamicEditor.clear();
            this.setButtons(false, false, false, false, false, false, false, false);
        }
    }

    private void compileButtonEvent() {
        if (this.enabled) {
            this.setButtons(false, false, false, false, false, false, false, false);
            this.parentFrame.setCurrentFrame((JFrame)this.frame.getEventSource());
            this.compiledSource = this.getSourceCode();
            this.parentFrame.getInterFrame().showMessage("Compiling...", (JFrame)this.frame.getEventSource(), 4);
            this.parentFrame.getRequester().requestCompile(this.compiledSource, this.getLanguage(), this.getComponentId());
        }
    }

    private void testButtonEvent() {
        System.out.println(this.enabled);
        if (this.enabled) {
            this.setButtons(false, false, false, false, false, false, false, false);
            this.parentFrame.setCurrentFrame((JFrame)this.frame.getEventSource());
            this.parentFrame.getRequester().requestTestInfo(this.getComponentId());
        }
    }

    private void submitButtonEvent() {
        if (!this.enabled) {
            return;
        }
        String string = this.getSourceCode();
        if (!string.equals(this.compiledSource) && !Common.confirm("Warning", "You have made a change to your code since the last time you compiled.  Do you want to continue with the submit?", (JFrame)this.frame.getEventSource())) {
            return;
        }
        if (Common.confirm("Warning", "Would you like to submit your code ?", (JFrame)this.frame.getEventSource())) {
            if (this.pref.isTrue("com.topcoder.client.contestApplet.common.LocalPreferences.UnusedCodeCheckEnabled") && !this.parentFrame.getPoweredByView()) {
                try {
                    UCRProcessor uCRProcessor = UCRProcessorFactory.getProcessor(this.getCurrentLanguageId());
                    uCRProcessor.initialize(this.component.getClassName(), this.component.getMethodName(), string);
                    String string2 = uCRProcessor.checkCode();
                    if (!string2.equals("") && !Common.confirm("Warning", string2, (JFrame)this.frame.getEventSource())) {
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.parentFrame.setCurrentFrame((JFrame)this.frame.getEventSource());
            this.submit();
        }
    }

    private void submit() {
        if (this.enabled) {
            this.parentFrame.getInterFrame().showMessage("Submitting...", (JFrame)this.frame.getEventSource(), 14);
            this.parentFrame.getRequester().requestSubmitCode(this.getComponentId());
        }
    }

    private void closeCodingWindow() {
        if (this.enabled) {
            this.parentFrame.getRequester().requestCloseComponent(this.getComponentId(), this.parentFrame.getModel().getCurrentUser());
        }
        this.pref.setLocation("com.topcoder.jmaContestApplet.frames.codingframe.location", (Point)this.frame.getProperty("Location"));
        this.pref.setSize("com.topcoder.jmaContestApplet.frames.codingframe.size", (Dimension)this.frame.getProperty("Size"));
        this.pref.setProperty("com.topcoder.jmaContestApplet.frames.codingframe.dividerloc", String.valueOf((Integer)this.jsp.getProperty("DividerLocation")));
        try {
            this.pref.savePreferences();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void updateComponentSource(String string, Language language) {
        if (DEBUG) {
            System.out.println("updateComponentSource: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        this.setLanguage(language);
        if (this.dynamicEditor == null) {
            this.setEditor(this.getDefaultEditor(), string);
        } else {
            this.setEditor((String)this.editorList.getProperty("SelectedItem"), string);
        }
    }

    public ProblemComponentModel getComponentModel() {
        return this.component;
    }

    public boolean isShowing() {
        return (Boolean)this.frame.getProperty("showing");
    }

    protected String getSourceCode() {
        return this.dynamicEditor.getSource();
    }

    protected ContestApplet getParentFrame() {
        return this.parentFrame;
    }

    public void setRoomModel(RoomModel roomModel) {
        this.roomModel = roomModel;
        if (this.sponsorPanel != null) {
            this.sponsorPanel.updateURL(this.getCodingFrameSponsorURLString());
        }
    }

    public RoomModel getRoomModel() {
        return this.roomModel;
    }

    protected static class ButtonDef {
        public UIActionListener listener;
        public String hotKey;

        public ButtonDef(UIActionListener uIActionListener, String string) {
            this.listener = uIActionListener;
            this.hotKey = string;
        }
    }
}

