/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.DummySortedTableModel;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.ArrayListInputPanel;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;

public class ArrayListInputDialog
implements FrameLogic {
    private UIComponent dialog;
    private UIPage page;
    private ArrayListInputPanel alip = null;
    private ArrayList info = null;
    private UIComponent jtf = null;
    private UIComponent addButton = null;
    private boolean status = false;
    private final int START = 0;
    private final int IN_QUOTE = 1;
    private final int ESCAPE = 2;

    public UIComponent getFrame() {
        return this.dialog;
    }

    public ArrayListInputDialog(ContestApplet contestApplet, UIComponent uIComponent, ArrayList arrayList, String string) {
        this.page = contestApplet.getCurrentUIManager().getUIPage("arraylist_input_dialog", true);
        this.dialog = this.page.getComponent("root_dialog", false);
        this.dialog.setProperty("Owner", uIComponent.getEventSource());
        this.dialog.setProperty("title", string + " Problem Argument");
        this.dialog.create();
        this.alip = new ArrayListInputPanel(this.page, string, (SortedTableModel)new EditableModel());
        this.info = arrayList;
        for (int i = 0; i < this.info.size(); ++i) {
            this.alip.addElement((String)this.info.get(i));
        }
        this.jtf = this.page.getComponent("input_text_field");
        this.addButton = this.page.getComponent("add_button");
        this.jtf.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.inputEvent();
            }
        });
        this.page.getComponent("up_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.upButtonEvent();
            }
        });
        this.page.getComponent("down_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.downButtonEvent();
            }
        });
        this.page.getComponent("add_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.addButtonEvent();
            }
        });
        this.page.getComponent("superadd_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.superAddButtonEvent();
            }
        });
        this.page.getComponent("bracketadd_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.bracketAddButtonEvent();
            }
        });
        this.page.getComponent("remove_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.removeButtonEvent();
            }
        });
        this.page.getComponent("clear_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.clearButtonEvent();
            }
        });
        this.page.getComponent("ok_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.okButtonEvent();
            }
        });
        this.page.getComponent("cancel_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.cancelButtonEvent();
            }
        });
        this.dialog.performAction("pack");
        Common.setLocationRelativeTo(uIComponent, this.dialog);
    }

    public ArrayList showDialog() {
        this.jtf.performAction("requestFocus");
        this.dialog.performAction("show");
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(2);
        arrayList.add(new Boolean(this.status));
        arrayList.add(this.info);
        return arrayList;
    }

    private void inputEvent() {
        this.endEditing();
        this.addButton.performAction("doClick");
    }

    private void upButtonEvent() {
        this.endEditing();
        int n = this.alip.getTable().getSelectedRow();
        int n2 = this.alip.getTable().getRowCount();
        if (n == -1 && n2 == 0) {
            Common.showMessage("", "The list is empty", (JDialog)this.dialog.getEventSource());
        } else if (n == -1) {
            Common.showMessage("", "Please select an element from the list", (JDialog)this.dialog.getEventSource());
        } else {
            if (n == 0) {
                return;
            }
            this.alip.getTableModel().swapRows(n - 1, n);
            this.alip.getTable().setRowSelectionInterval(n - 1, n - 1);
            this.alip.getTable().getSelectionModel().setSelectionInterval(n - 1, n - 1);
        }
    }

    private void downButtonEvent() {
        this.endEditing();
        int n = this.alip.getTable().getSelectedRow();
        int n2 = this.alip.getTable().getRowCount();
        if (n == -1 && n2 == 0) {
            Common.showMessage("", "The list is empty", (JDialog)this.dialog.getEventSource());
        } else if (n == -1) {
            Common.showMessage("", "Please select an element from the list", (JDialog)this.dialog.getEventSource());
        } else {
            if (n >= n2 - 1) {
                return;
            }
            this.alip.getTableModel().swapRows(n + 1, n);
            this.alip.getTable().setRowSelectionInterval(n + 1, n + 1);
            this.alip.getTable().getSelectionModel().setSelectionInterval(n + 1, n + 1);
        }
    }

    private void addButtonEvent() {
        this.endEditing();
        if (this.alip.size() >= 50) {
            Common.showMessage("Error", "You have exceeded the max array size of 50 elements.", (JDialog)this.dialog.getEventSource());
        } else if (((String)this.jtf.getProperty("Text")).length() > 50) {
            Common.showMessage("Error", "You have exceeded the max argument size of 50 characters.", (JDialog)this.dialog.getEventSource());
        } else {
            this.alip.addElement((String)this.jtf.getProperty("Text"));
            this.jtf.setProperty("Text", "");
        }
        MoveFocus.moveFocus(this.jtf);
    }

    private void superAddButtonEvent() {
        this.endEditing();
        StringTokenizer stringTokenizer = new StringTokenizer((String)this.jtf.getProperty("Text"), ",", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ",";
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string.equals(",") && string2.equals(",")) {
                arrayList.add("");
            }
            if (string2.equals(",") && !stringTokenizer.hasMoreTokens()) {
                arrayList.add("");
            }
            if (!string2.equals(",")) {
                arrayList.add(string2);
            }
            string = string2;
        }
        if (this.alip.size() + arrayList.size() > 50) {
            Common.showMessage("Error", "You have exceeded the max array size of 50 elements. Please eliminate some of your elements", (JDialog)this.dialog.getEventSource());
            return;
        }
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.length() > 50) {
                bl = true;
                continue;
            }
            this.alip.addElement(string3);
        }
        if (bl) {
            Common.showMessage("Warning", "One or more entries were ignored because they were either empty (blank) or had a size greater than 50..", (JDialog)this.dialog.getEventSource());
        }
        this.jtf.setProperty("Text", "");
        MoveFocus.moveFocus(this.jtf);
    }

    private void removeButtonEvent() {
        this.endEditing();
        int n = this.alip.getTable().getSelectedRow();
        int[] nArray = this.alip.getTable().getSelectedRows();
        int n2 = this.alip.getTable().getRowCount();
        if (n == -1 && n2 == 0) {
            Common.showMessage("", "The list is empty", (JDialog)this.dialog.getEventSource());
        } else if (n == -1) {
            Common.showMessage("", "Please select an element from the list", (JDialog)this.dialog.getEventSource());
        } else {
            int n3;
            for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                this.alip.removeElement(nArray[n3]);
            }
            n3 = this.alip.getTable().getRowCount();
            if (n < n3 - 1) {
                this.alip.getTable().setRowSelectionInterval(n, n);
                this.alip.getTable().getSelectionModel().setSelectionInterval(n, n);
            } else if (n3 > 0) {
                this.alip.getTable().setRowSelectionInterval(n3 - 1, n3 - 1);
                this.alip.getTable().getSelectionModel().setSelectionInterval(n3 - 1, n3 - 1);
            }
        }
    }

    private void clearButtonEvent() {
        this.alip.clear();
    }

    private void okButtonEvent() {
        this.endEditing();
        if (!this.jtf.getProperty("Text").equals("")) {
            if (JOptionPane.showConfirmDialog((JDialog)this.dialog.getEventSource(), "You have un-saved information entered.  Do you wish to add it and continue?", "Warning", 0, 2) == 0) {
                this.addButton.performAction("doClick");
            } else {
                return;
            }
        }
        this.info.clear();
        SortedTableModel sortedTableModel = this.alip.getTableModel();
        for (int i = 0; i < sortedTableModel.getRowCount(); ++i) {
            this.info.add(sortedTableModel.getValueAt(i, 0));
        }
        this.status = true;
        this.dialog.performAction("dispose");
    }

    private void cancelButtonEvent() {
        this.status = false;
        this.dialog.performAction("dispose");
    }

    private void endEditing() {
        TableCellEditor tableCellEditor;
        if (this.alip.getTable().isEditing() && (tableCellEditor = this.alip.getTable().getCellEditor(this.alip.getTable().getEditingRow(), this.alip.getTable().getEditingColumn())) != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    private void bracketAddButtonEvent() {
        this.endEditing();
        String string = (String)this.jtf.getProperty("Text");
        string = string.trim();
        if (string.length() > 0 && string.charAt(0) == '{') {
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '}') {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() != 0) {
            int n = 0;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer(50);
            block17: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (n) {
                    case 2: {
                        switch (c) {
                            case '\\': {
                                stringBuffer.append('\\');
                                break;
                            }
                            case '\"': {
                                stringBuffer.append('\"');
                                break;
                            }
                            default: {
                                stringBuffer.append('\\');
                                stringBuffer.append(c);
                            }
                        }
                        n = 1;
                        continue block17;
                    }
                    case 1: {
                        String string2;
                        switch (c) {
                            case '\\': {
                                n = 2;
                                continue block17;
                            }
                            case '\"': {
                                string2 = stringBuffer.toString();
                                stringBuffer.delete(0, stringBuffer.length());
                                n = 0;
                                if (string2.length() > 50) {
                                    bl = true;
                                    continue block17;
                                }
                                this.alip.addElement(string2);
                                continue block17;
                            }
                        }
                        stringBuffer.append(c);
                        continue block17;
                    }
                    case 0: {
                        String string2;
                        if (Character.isWhitespace(c)) {
                            if (stringBuffer.length() <= 0) continue block17;
                            string2 = stringBuffer.toString().trim();
                            stringBuffer.delete(0, stringBuffer.length());
                            if (string2.length() > 50) {
                                bl = true;
                                continue block17;
                            }
                            this.alip.addElement(string2);
                            continue block17;
                        }
                        switch (c) {
                            case '\"': {
                                if (stringBuffer.length() > 0) {
                                    stringBuffer.append('\"');
                                    continue block17;
                                }
                                n = 1;
                                continue block17;
                            }
                            case ',': {
                                if (stringBuffer.length() <= 0 && i != 0 && (i <= 0 || string.charAt(i - 1) != ',')) continue block17;
                                string2 = stringBuffer.toString().trim();
                                stringBuffer.delete(0, stringBuffer.length());
                                if (string2.length() > 50) {
                                    bl = true;
                                    continue block17;
                                }
                                this.alip.addElement(string2);
                                continue block17;
                            }
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            if (stringBuffer.length() > 0 || string.charAt(string.length() - 1) == ',') {
                String string3 = stringBuffer.toString().trim();
                stringBuffer.delete(0, stringBuffer.length());
                if (string3.length() > 50) {
                    bl = true;
                } else {
                    this.alip.addElement(string3);
                }
            }
            if (bl) {
                Common.showMessage("Warning", "One or more entries were ignored because they were either empty (blank) or had a size greater than 50..", (JDialog)this.dialog.getEventSource());
            }
        }
        this.jtf.setProperty("Text", "");
        MoveFocus.moveFocus(this.jtf);
    }

    private class EditableModel
    extends DummySortedTableModel {
        ArrayList l = new ArrayList();

        public EditableModel() {
            this.setZeroAllowed(true);
        }

        public int getRowCount() {
            return this.l.size();
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.l.set(n, object);
            this.fireTableRowsUpdated(n, n);
        }

        public Object getValueAt(int n, int n2) {
            return this.l.get(n);
        }

        public void add(Object object) {
            this.l.add(object);
            this.fireTableRowsInserted(this.l.size() - 1, this.l.size() - 1);
        }

        public Object remove(int n) {
            Object e = this.l.remove(n);
            this.fireTableRowsDeleted(n, n);
            return e;
        }

        public void swapRows(int n, int n2) {
            Object e = this.l.get(n);
            this.l.set(n, this.l.get(n2));
            this.l.set(n2, e);
            this.fireTableRowsUpdated(Math.min(n, n2), Math.max(n, n2));
        }

        public void clear() {
            this.l.clear();
            this.fireTableDataChanged();
        }
    }
}

