/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.rooms;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.rooms.RoomModule;
import com.topcoder.client.contestApplet.uilogic.panels.ChatPanel;
import com.topcoder.client.contestApplet.uilogic.panels.HTMLPanel;
import com.topcoder.client.contestApplet.uilogic.panels.LobbyCompPanel;
import com.topcoder.client.contestApplet.uilogic.panels.RoomCompPanel;
import com.topcoder.client.contestApplet.uilogic.panels.RoomPanel;
import com.topcoder.client.contestApplet.uilogic.panels.UserTablePanel;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class LobbyRoom
extends RoomModule {
    private RoomPanel panel = null;
    private ChatPanel chatPanel = null;
    private UserTablePanel userPanel = null;
    private RoomCompPanel lcp = null;
    private UIPage page = null;
    private static boolean once = true;

    LobbyRoom(ContestApplet contestApplet) {
        super(contestApplet, 3);
        this.create();
    }

    LobbyRoom(ContestApplet contestApplet, int n) {
        super(contestApplet, n);
        this.create();
    }

    private void create() {
        String string;
        switch (this.currentRoom) {
            case 3: {
                string = "Lobby";
                break;
            }
            case 8: {
                string = "Moderated Chat";
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "Unsupported room type " + this.currentRoom;
                System.err.println("Unsupported room type (" + this.currentRoom + ").");
                break;
            }
            case -2: {
                string = "Invalid Room";
                System.err.println("Invalid room type (" + this.currentRoom + ").");
                break;
            }
            default: {
                string = "Unknown room type " + this.currentRoom;
            }
        }
        this.page = this.parentFrame.getCurrentUIManager().getUIPage("lobby");
        this.lcp = new LobbyCompPanel(this.page);
        this.panel = new RoomPanel(string, this.parentFrame, this.createWorkPanel(), this.lcp, this.page);
        this.panel.showTimer();
    }

    public void enter() {
        boolean bl;
        this.chatPanel.enter();
        boolean bl2 = bl = this.parentFrame.getModel().getUserInfo().isAdmin() || this.parentFrame.getModel().getUserInfo().isGuest();
        if (!bl && this.parentFrame.getModel().getUserInfo().isFirstTimeUser()) {
            this.displayFirstTimeUserFrame();
        } else if (!bl && this.parentFrame.getModel().getUserInfo().getNumRatedEvents() == 0) {
            this.displayNeverCompetedFrame();
        }
    }

    public void setConnectionStatus(boolean bl) {
        this.panel.setStatusLabel(bl);
        this.chatPanel.setPanelEnabled(bl);
        this.userPanel.setPanelEnabled(bl);
    }

    private void displayFirstTimeUserFrame() {
        if (!once) {
            return;
        }
        once = false;
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/firstTimeUser.properties"));
            String string = properties.getProperty("com.topcoder.firstTimeUser.enabled");
            if (string == null || !Boolean.valueOf(string).equals(Boolean.TRUE)) {
                return;
            }
            this.displayFrame(properties.getProperty("com.topcoder.firstTimeUser.title", "First Time User"), properties.getProperty("com.topcoder.firstTimeUser.location"), Integer.parseInt(properties.getProperty("com.topcoder.firstTimeUser.width", "795")), Integer.parseInt(properties.getProperty("com.topcoder.firstTimeUser.height", "570")));
        }
        catch (Exception exception) {
            System.err.println("Error loading first time user panel");
            exception.printStackTrace();
        }
    }

    private void displayNeverCompetedFrame() {
        if (!once) {
            return;
        }
        once = false;
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/neverCompeted.properties"));
            String string = properties.getProperty("com.topcoder.neverCompeted.enabled");
            if (string == null || !Boolean.valueOf(string).equals(Boolean.TRUE)) {
                return;
            }
            this.displayFrame(properties.getProperty("com.topcoder.neverCompeted.title", "Competition"), properties.getProperty("com.topcoder.neverCompeted.location"), Integer.parseInt(properties.getProperty("com.topcoder.neverCompeted.width", "795")), Integer.parseInt(properties.getProperty("com.topcoder.neverCompeted.height", "570")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void displayFrame(String string, String string2, int n, int n2) throws Exception {
        HTMLPanel hTMLPanel = new HTMLPanel(this.parentFrame);
        hTMLPanel.load(string2, this.parentFrame);
        hTMLPanel.replaceVariables(new String[]{"$USERNAME"}, new String[]{this.parentFrame.getModel().getCurrentUser()});
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        jFrame.getContentPane().add((Component)hTMLPanel.getPanel(), "Center");
        jFrame.setSize(n, n2);
        Common.setLocationRelativeTo((Component)this.parentFrame.getCurrentFrame(), jFrame);
        jFrame.show();
        MoveFocus.moveFocus(jFrame);
    }

    public boolean leave() {
        this.chatPanel.leave();
        this.unsetModel();
        return true;
    }

    public void resetFocus() {
        this.chatPanel.leave();
        this.chatPanel.enter();
    }

    private UIComponent createWorkPanel() {
        this.chatPanel = new ChatPanel(this.parentFrame, this.page);
        this.userPanel = new UserTablePanel(this.parentFrame, this.page);
        return this.page.getComponent("work_panel_base");
    }

    public JPanel reload() {
        this.panel.getWorkPanel().performAction("revalidate");
        this.panel.getWorkPanel().performAction("repaint");
        return (JPanel)this.panel.getPanel().getEventSource();
    }

    public void clear() {
        super.clear();
        this.userPanel.clear();
        this.chatPanel.clear();
    }

    protected void addViews() {
        this.roomModel.addUserListView(this.userPanel);
        this.roomModel.addUserListView(this.chatPanel);
        this.roomModel.addChatView(this.chatPanel);
        this.lcp.updateContestInfo(this.roomModel.getStatus());
        this.panel.getCompPanel().setContestName(this.roomModel.getName());
    }

    void clearViews() {
        this.lcp.updateContestInfo("");
        this.panel.getCompPanel().setContestName("");
        if (this.roomModel != null) {
            this.roomModel.removeChatView(this.chatPanel);
            this.roomModel.removeUserListView(this.chatPanel);
            this.roomModel.removeUserListView(this.userPanel);
        }
    }
}

