/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.panels.table.UserTableModel;
import com.topcoder.client.contestApplet.panels.table.UserTablePanel;
import com.topcoder.client.contestant.RoomModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class CoderContestantTablePanel
extends UserTablePanel {
    private MenuItemInfo[] CONTESTANT_POPUP = new MenuItemInfo[]{new MenuItemInfo("Info", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            CoderContestantTablePanel.this.infoPopupEvent();
        }
    }), new MenuItemInfo("History", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            CoderContestantTablePanel.this.historyPopupEvent();
        }
    })};

    public CoderContestantTablePanel(ContestApplet contestApplet, String[] stringArray) {
        super(contestApplet, "Who's assigned [0]", new UserTableModel(contestApplet.getModel(), stringArray){

            protected boolean isLeader(String string) {
                RoomModel roomModel = this.contestantModel.getCurrentRoom();
                if (roomModel != null && roomModel.hasLeader()) {
                    return roomModel.getLeader().getUserName().equals(string);
                }
                return false;
            }
        }, true);
        this.setContestPopup("Contestants Info", this.CONTESTANT_POPUP);
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (CoderContestantTablePanel.this.isEnabled()) {
                    CoderContestantTablePanel.this.rightClickEvent(mouseEvent);
                    CoderContestantTablePanel.this.doubleClickEvent(mouseEvent);
                }
            }
        });
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                CoderContestantTablePanel.this.tableCountEvent();
            }
        });
        this.setToolTipText("Static list of registered users assigned to this room.");
        this.tableModel.sort(0, true);
        this.setupFonts();
    }

    private void historyPopupEvent() {
        int n = this.contestTable.getSelectedRow();
        String string = ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getName();
        this.ca.setCurrentFrame(this.ca.getMainFrame());
        this.ca.requestCoderHistory(string, this.ca.getModel().getCurrentRoom().getRoomID(), ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getUserType());
    }

    void tableCountEvent() {
        ((TitledBorder)this.getBorder()).setTitle("Who's assigned [" + this.contestTable.getRowCount() + "]");
        this.revalidate();
        this.repaint();
    }
}

