/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.common.PopUpHelper;
import com.topcoder.client.contestApplet.frames.ChallengeFrame;
import com.topcoder.client.contestApplet.frames.RoomInfoFrame;
import com.topcoder.client.contestApplet.frames.SourceViewer;
import com.topcoder.client.contestApplet.panels.table.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.panels.table.RankRenderer;
import com.topcoder.client.contestApplet.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.panels.table.UserNameRenderer;
import com.topcoder.client.contestApplet.widgets.ComponentResultDisplayRenderer;
import com.topcoder.client.contestApplet.widgets.ContestTableCellRenderer;
import com.topcoder.client.contestApplet.widgets.ContestTableHeaderRenderer;
import com.topcoder.client.contestApplet.widgets.FormatTableCellRenderer;
import com.topcoder.client.contestApplet.widgets.LanguageAndStatusColoringDecoratorRenderer;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.netCommon.contest.ResultDisplayType;
import com.topcoder.netCommon.contest.round.RoundProperties;
import com.topcoder.netCommon.contest.round.text.ComponentNameBuilder;
import com.topcoder.netCommon.contestantMessages.response.data.ComponentChallengeData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public abstract class BaseAlgoSummaryTablePanel
extends AbstractSummaryTablePanel
implements SourceViewer.SourceViewerListener {
    private final ContestApplet ca;
    private final Contestant model;
    private ChallengeTableModel tableModel;
    private JTable table;
    private boolean once = true;
    private int lastColumnIndexFix;
    private int columnCount;
    private int maxProblemColumn;
    private boolean enabled = true;
    private Class[] tableModelClasses;
    private String[] tableModelHeaders;
    private ComponentResultDisplayRenderer[] resultDisplayRenderer;
    private int oldCompID = 0;
    private ArrayList oldArgs = null;
    private ProblemModel currentProblemInfo;
    private SourceViewer src;
    private JPopupMenu contestPopup = new JPopupMenu();
    private final CoderComponent.Listener myCoderComponentListener = new CoderComponent.Listener(){

        public void coderComponentEvent(CoderComponent coderComponent) {
            if (coderComponent.hasSourceCode()) {
                if (BaseAlgoSummaryTablePanel.this.currentProblemInfo == null) {
                    throw new IllegalStateException("Missing problem info");
                }
                ComponentNameBuilder componentNameBuilder = BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundType().getComponentNameBuilder();
                String string = componentNameBuilder.longNameForComponent(coderComponent.getComponent().getClassName(), coderComponent.getComponent().getPoints(), BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundProperties());
                BaseAlgoSummaryTablePanel.this.src.clear();
                BaseAlgoSummaryTablePanel.this.src.setCode(coderComponent.getSourceCode(), coderComponent.getSourceCodeLanguage());
                BaseAlgoSummaryTablePanel.this.src.setTitle(coderComponent.getCoder().getHandle() + "'s " + string + " (" + coderComponent.getSourceCodeLanguage().getName() + ")");
            } else {
                BaseAlgoSummaryTablePanel.this.sourceViewerClosing();
            }
        }
    };
    private final ProblemModel.Listener myProblemModelListener = new ProblemModel.Listener(){

        public void updateProblemModel(ProblemModel problemModel) {
            if (problemModel.hasProblemStatement()) {
                BaseAlgoSummaryTablePanel.this.ca.getInterFrame().hideMessage();
                if (BaseAlgoSummaryTablePanel.this.src == null) {
                    throw new IllegalStateException("Source viewer not initialized!");
                }
                BaseAlgoSummaryTablePanel.this.src.setTitle(problemModel.getName());
                if (BaseAlgoSummaryTablePanel.this.once) {
                    BaseAlgoSummaryTablePanel.this.once = false;
                }
                BaseAlgoSummaryTablePanel.this.src.setVisible(true);
                BaseAlgoSummaryTablePanel.this.src.setProblem(problemModel);
                BaseAlgoSummaryTablePanel.this.challengeHandle = BaseAlgoSummaryTablePanel.this.currentComponent.getCoder().getHandle();
                BaseAlgoSummaryTablePanel.this.src.setCoderComponent(BaseAlgoSummaryTablePanel.this.currentComponent);
                BaseAlgoSummaryTablePanel.this.src.setWriter(BaseAlgoSummaryTablePanel.this.currentComponent.getCoder().getHandle());
                if (BaseAlgoSummaryTablePanel.this.currentComponent.getComponent().getComponentTypeID() == 1) {
                    BaseAlgoSummaryTablePanel.this.src.setChallengeable(true);
                } else {
                    BaseAlgoSummaryTablePanel.this.src.setChallengeable(false);
                }
            } else {
                throw new IllegalStateException("Missing statement for problem " + problemModel);
            }
            BaseAlgoSummaryTablePanel.this.src.refreshStatement();
        }

        public void updateProblemModelReadOnly(ProblemModel problemModel) {
        }
    };
    private final MenuItemInfo[] OTHER_CHALLENGE_POPUP = new MenuItemInfo[]{new MenuItemInfo("Info", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseAlgoSummaryTablePanel.this.infoPopupEvent();
        }
    }), new MenuItemInfo("History", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseAlgoSummaryTablePanel.this.historyPopupEvent();
        }
    })};
    private final MenuItemInfo SOURCE_ITEM = new MenuItemInfo("Source", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseAlgoSummaryTablePanel.this.sourcePopupEvent();
        }
    });
    private final MenuItemInfo[] CHALLENGE_POPUP = new MenuItemInfo[]{this.SOURCE_ITEM};
    private final MenuItemInfo[] ONLY_SOURCE_POPUP = new MenuItemInfo[]{this.SOURCE_ITEM};
    private JFrame frame = null;
    private JPopupMenu otherContestPopup = new JPopupMenu();
    private String challengeHandle;
    private CoderComponent currentComponent;
    private boolean onlySourceMenuItem;
    private boolean update;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$topcoder$client$contestApplet$panels$table$UserNameEntry;
    static /* synthetic */ Class class$com$topcoder$client$contestApplet$panels$table$ChallengeProblemEntry;

    private void setContestPopup(JPopupMenu jPopupMenu) {
        this.contestPopup = jPopupMenu;
    }

    private void setContestPopup(MenuItemInfo[] menuItemInfoArray) {
        String string = "Challenge Info";
        this.setContestPopup(PopUpHelper.createPopupMenu(string, menuItemInfoArray));
    }

    private JTable createTable() {
        JTable jTable = new JTable(this.tableModel);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setBackground(Common.TB_COLOR);
        jTable.setForeground(Common.TF_COLOR);
        jTable.setSelectionBackground(Common.HB_COLOR);
        jTable.setSelectionForeground(Common.HF_COLOR);
        jTable.setShowGrid(false);
        jTable.setSelectionMode(0);
        jTable.getColumnModel().setColumnMargin(0);
        this.setHeaders(jTable);
        String string = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        ContestTableCellRenderer contestTableCellRenderer = new ContestTableCellRenderer(string, n);
        jTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = BaseAlgoSummaryTablePanel.class$("java.lang.String")) : class$java$lang$String, contestTableCellRenderer);
        this.resultDisplayRenderer = new ComponentResultDisplayRenderer[this.columnCount - 3 - this.lastColumnIndexFix];
        for (int i = 0; i < this.columnCount; ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(25);
                tableColumn.setCellRenderer(new ContestTableCellRenderer(string, n));
                continue;
            }
            if (i == 1) {
                tableColumn.setPreferredWidth(23);
                tableColumn.setCellRenderer(new RankRenderer());
                continue;
            }
            if (i == 2) {
                tableColumn.setPreferredWidth(115);
                tableColumn.setCellRenderer(new UserNameRenderer(this.model, string, n));
                continue;
            }
            if (i < this.maxProblemColumn) {
                tableColumn.setPreferredWidth(140);
                this.resultDisplayRenderer[this.getIndexOfRenderer((int)i)] = new ComponentResultDisplayRenderer(this.getRoundModel(), new ContestTableCellRenderer(string, n));
                tableColumn.setCellRenderer(new LanguageAndStatusColoringDecoratorRenderer(this.resultDisplayRenderer[this.getIndexOfRenderer(i)], Color.WHITE){

                    protected Integer getLanguage(Object object, int n, int n2) {
                        try {
                            return ((CoderComponent)object).getLanguageID();
                        }
                        catch (RuntimeException runtimeException) {
                            return null;
                        }
                    }

                    protected int getStatus(Object object, int n, int n2) {
                        try {
                            return ((CoderComponent)object).getStatus();
                        }
                        catch (RuntimeException runtimeException) {
                            return 0;
                        }
                    }
                });
                continue;
            }
            tableColumn.setPreferredWidth(100);
            tableColumn.setCellRenderer(new FormatTableCellRenderer(new ContestTableCellRenderer(string, n), Common.newScoreFormat()));
        }
        return jTable;
    }

    private void setHeaders(JTable jTable) {
        String string = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        for (int i = 0; i < this.columnCount; ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderRenderer(new ContestTableHeaderRenderer(true, string, n));
            jTable.getColumnModel().getColumn(i).setCellRenderer(new ContestTableCellRenderer(string, n));
        }
    }

    private void createTablePanel() {
        String string = this.getTitle();
        int n = 0;
        int n2 = 0;
        JScrollPane jScrollPane = new JScrollPane(this.table);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(-1, -1, -1, -1);
        this.setBorder(Common.getTitledBorder(string));
        this.setPreferredSize(new Dimension(n, n2));
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.getViewport().setBackground(Common.TB_COLOR);
        this.table.setPreferredScrollableViewportSize(jScrollPane.getSize());
        this.setBackground(Common.WPB_COLOR);
        this.setOpaque(true);
        Common.insertInPanel(jScrollPane, this, gridBagConstraints, 0, 0, 1, 1);
        String string2 = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n3 = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setBackground(Common.BG_COLOR);
        this.table.getTableHeader().setResizingAllowed(true);
        this.table.getTableHeader().setDefaultRenderer(new ContestTableHeaderRenderer(true, string2, n3));
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (BaseAlgoSummaryTablePanel.this.enabled) {
                    BaseAlgoSummaryTablePanel.this.mouseClickEvent(mouseEvent);
                    BaseAlgoSummaryTablePanel.this.otherMouseClickEvent(mouseEvent);
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BaseAlgoSummaryTablePanel.this.headerClickEvent(mouseEvent);
            }
        });
    }

    private void showContestPopup(MouseEvent mouseEvent) {
        this.contestPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public BaseAlgoSummaryTablePanel(ContestApplet contestApplet, JFrame jFrame, boolean bl, boolean bl2) {
        super(new GridBagLayout());
        this.ca = contestApplet;
        this.model = contestApplet.getModel();
        this.frame = jFrame;
        this.onlySourceMenuItem = bl;
        this.update = bl2;
    }

    protected void init() {
        this.prepareForTableModel();
        this.tableModel = new ChallengeTableModel();
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (BaseAlgoSummaryTablePanel.this.currentProblemInfo != null && BaseAlgoSummaryTablePanel.this.currentComponent.getStatus() == 140) {
                    BaseAlgoSummaryTablePanel.this.src.notifyChallengeSucceeded(BaseAlgoSummaryTablePanel.this.currentComponent.getCoder().getHandle(), Common.formatNoFractions(BaseAlgoSummaryTablePanel.this.currentProblemInfo.getComponents()[0].getPoints()));
                }
                BaseAlgoSummaryTablePanel.this.updateRoomLeader();
            }
        });
        this.table = this.createTable();
        UIManager.put("MenuItem.selectionBackground", Common.HB_COLOR);
        MenuItemInfo[] menuItemInfoArray = this.onlySourceMenuItem ? this.ONLY_SOURCE_POPUP : this.CHALLENGE_POPUP;
        this.setContestPopup(menuItemInfoArray);
        this.otherContestPopup = PopUpHelper.createPopupMenu("", this.OTHER_CHALLENGE_POPUP);
        this.createTablePanel();
    }

    public JComponent getTable() {
        return this.table;
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        if (n2 > 2 && n2 < this.maxProblemColumn) {
            Coder coder = this.tableModel.getCoder(n);
            int n3 = 2;
            ProblemModel[] problemModelArray = this.getRoundModel().getProblems(this.getDivisionID());
            CoderComponent coderComponent = null;
            boolean bl = false;
            for (int i = 0; !bl && i < problemModelArray.length; ++i) {
                for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                    if (++n3 != n2) continue;
                    coderComponent = coder.getComponent(problemModelArray[i].getComponents()[j].getID());
                    bl = true;
                }
                if (problemModelArray[i].getProblemType() != 2 || ++n3 != n2) continue;
                coderComponent = null;
                bl = true;
            }
            if (coderComponent != null && coderComponent.getStatus() >= 120) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.showContestPopup(mouseEvent);
                } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.sourcePopupEvent();
                } else if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.resultDisplayRenderer[this.getIndexOfRenderer(n2)].toggleDisplayTypeForComponent(coderComponent, this.getRoundModel().getRoundProperties().getAllowedScoreTypesToShow());
                    this.tableModel.fireTableCellUpdated(n, n2);
                }
            }
        }
    }

    private int getIndexOfRenderer(int n) {
        return n - 3;
    }

    private void otherMouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        if (n2 < 3 || n2 >= this.maxProblemColumn) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.otherContestPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.infoPopupEvent();
            }
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.table.getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.tableModel.sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.table.getTableHeader().repaint();
        }
    }

    private void infoPopupEvent() {
        int n = this.table.getSelectedRow();
        this.challengeHandle = ((UserNameEntry)this.table.getValueAt(n, 2)).getName();
        this.ca.setCurrentFrame(this.frame);
        this.ca.requestCoderInfo(this.challengeHandle, ((UserNameEntry)this.table.getValueAt(n, 2)).getUserType());
    }

    private void sourcePopupEvent() {
        CoderComponent coderComponent;
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (n2 > 2 && n2 < this.maxProblemColumn && (coderComponent = this.tableModel.getCoderComponent(n, n2)).getStatus() > 110) {
            if (coderComponent.getStatus() > 120) {
                this.createNewSourceViewer(true);
            } else {
                this.createNewSourceViewer(false);
            }
            this.currentComponent = coderComponent;
            this.currentProblemInfo = this.currentComponent.getComponent().getProblem();
            this.challengeHandle = this.tableModel.getValueAt(n, 2).toString();
            this.ca.setCurrentFrame(this.frame);
            boolean bl = false;
            if (this.frame instanceof ChallengeFrame) {
                bl = ((ChallengeFrame)this.frame).getPrettyToggle();
            } else if (this.frame instanceof RoomInfoFrame) {
                bl = ((RoomInfoFrame)this.frame).getPrettyToggle();
            }
            this.currentComponent.addListener(this.myCoderComponentListener);
            this.currentProblemInfo.addListener(this.myProblemModelListener);
            this.ca.setCurrentFrame(this.frame);
            this.ca.getInterFrame().showMessage("Fetching problem...", this.frame, 40);
            this.ca.getModel().getRequester().requestChallengeComponent(this.currentComponent.getComponent().getID(), bl, this.getRoomByCoder(this.challengeHandle).getRoomID(), this.challengeHandle);
        }
    }

    public void doChallenge(String string, CoderComponent coderComponent, JFrame jFrame) {
        if (!this.enabled) {
            return;
        }
        ComponentChallengeData componentChallengeData = coderComponent.getComponent().getComponentChallengeData();
        this.challengeHandle = string;
        this.currentComponent = coderComponent;
        this.ca.setCurrentFrame(this.frame);
        String string2 = "You are entering arguments to challenge the " + componentChallengeData.getMethodName() + " method of the " + componentChallengeData.getClassName() + " class.  If successful, this challenge will be worth " + 50 + " points. If it is unsuccessful, it will cost you " + -25 + " points.";
        if (this.oldCompID != coderComponent.getComponent().getID().intValue()) {
            // empty if block
        }
    }

    private void updateRoomLeader() {
        this.tableModel.updateRoomLeader();
        this.repaint();
    }

    public void updateView(ResultDisplayType resultDisplayType) {
        for (int i = 0; i < this.resultDisplayRenderer.length; ++i) {
            ComponentResultDisplayRenderer componentResultDisplayRenderer = this.resultDisplayRenderer[i];
            componentResultDisplayRenderer.setDisplayType(resultDisplayType);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void historyPopupEvent() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            Coder coder = this.tableModel.getCoder(n);
            String string = coder.getHandle();
            this.ca.setCurrentFrame(this.frame);
            this.ca.requestCoderHistory(string, this.getRoomByCoder(string).getRoomID(), coder.getUserType());
        }
    }

    private void prepareForTableModel() {
        RoundModel roundModel = this.getRoundModel();
        if (!roundModel.hasProblems(this.getDivisionID())) {
            throw new IllegalStateException("Can't build challenge table model, no problems for round: " + roundModel);
        }
        ProblemModel[] problemModelArray = roundModel.getProblems(this.getDivisionID());
        boolean bl = false;
        for (int i = 0; i < problemModelArray.length; ++i) {
            if (problemModelArray[i].getProblemType() != 2) continue;
            bl = true;
        }
        String string = bl ? "C: " : "";
        String string2 = "P: ";
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(class$java$lang$Integer == null ? (class$java$lang$Integer = BaseAlgoSummaryTablePanel.class$("java.lang.Integer")) : class$java$lang$Integer);
        arrayList2.add("Place");
        arrayList.add(class$java$lang$Integer == null ? (class$java$lang$Integer = BaseAlgoSummaryTablePanel.class$("java.lang.Integer")) : class$java$lang$Integer);
        arrayList2.add("R");
        arrayList.add(class$com$topcoder$client$contestApplet$panels$table$UserNameEntry == null ? (class$com$topcoder$client$contestApplet$panels$table$UserNameEntry = BaseAlgoSummaryTablePanel.class$("com.topcoder.client.contestApplet.panels.table.UserNameEntry")) : class$com$topcoder$client$contestApplet$panels$table$UserNameEntry);
        arrayList2.add("Handle");
        ComponentNameBuilder componentNameBuilder = roundModel.getRoundType().getComponentNameBuilder();
        RoundProperties roundProperties = roundModel.getRoundProperties();
        for (int i = 0; i < problemModelArray.length; ++i) {
            for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                arrayList.add(class$com$topcoder$client$contestApplet$panels$table$ChallengeProblemEntry == null ? BaseAlgoSummaryTablePanel.class$("com.topcoder.client.contestApplet.panels.table.ChallengeProblemEntry") : class$com$topcoder$client$contestApplet$panels$table$ChallengeProblemEntry);
                ProblemComponentModel problemComponentModel = problemModelArray[i].getComponents()[j];
                String string3 = componentNameBuilder.shortNameForComponent(problemComponentModel.getClassName(), problemComponentModel.getPoints(), roundProperties);
                arrayList2.add(string + string3);
            }
            if (problemModelArray[i].getProblemType() != 2) continue;
            arrayList.add(class$java$lang$String == null ? BaseAlgoSummaryTablePanel.class$("java.lang.String") : class$java$lang$String);
            arrayList2.add(string2 + problemModelArray[i].getName());
        }
        this.lastColumnIndexFix = 0;
        if (roundModel.getRoundProperties().usesScore()) {
            arrayList.add(class$java$lang$String == null ? (class$java$lang$String = BaseAlgoSummaryTablePanel.class$("java.lang.String")) : class$java$lang$String);
            arrayList2.add("Score");
            this.lastColumnIndexFix = 1;
        }
        this.tableModelClasses = arrayList.toArray(new Class[0]);
        this.tableModelHeaders = arrayList2.toArray(new String[0]);
        this.columnCount = this.tableModelClasses.length;
        this.maxProblemColumn = this.columnCount - this.lastColumnIndexFix;
    }

    private void createNewSourceViewer(boolean bl) {
        boolean bl2;
        this.closeSourceViewer();
        RoomModel roomModel = this.getRoomByCoder(this.tableModel.getValueAt(this.table.getSelectedRow(), 2).toString());
        boolean bl3 = bl2 = roomModel.isPracticeRoom() || this.getRoundModel().isInChallengePhase();
        if (bl2) {
            bl2 = roomModel.isAssigned(this.ca.getModel().getCurrentUser());
        }
        if (!bl) {
            bl2 = false;
        }
        this.src = new SourceViewer(this.ca, bl2);
        this.src.setPanel(this);
    }

    public Collection getFilteredCoders() {
        Collection collection = this.getCoders();
        if (this.getRoundModel().getRoundProperties().getShowScoresOfOtherCoders().booleanValue()) {
            return collection;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Coder coder = (Coder)iterator.next();
            if (!coder.getHandle().equals(this.ca.getModel().getCurrentUser())) continue;
            return Collections.singletonList(coder);
        }
        return Collections.EMPTY_LIST;
    }

    public void closeSourceViewer() {
        if (this.src != null) {
            this.sourceViewerClosing();
            this.src.setVisible(false);
            this.src.dispose();
            this.src = null;
        }
    }

    public void sourceViewerClosing() {
        if (this.currentProblemInfo != null) {
            this.currentProblemInfo.removeListener(this.myProblemModelListener);
            this.currentProblemInfo = null;
        }
        if (this.currentComponent != null) {
            this.currentComponent.removeListener(this.myCoderComponentListener);
            this.currentComponent = null;
        }
    }

    protected abstract RoundModel getRoundModel();

    protected abstract Integer getDivisionID();

    protected abstract boolean isRoomLeader(String var1);

    protected abstract Collection getCoders();

    protected abstract RoomModel getRoomByCoder(String var1);

    protected abstract String getTitle();

    public ChallengeTableModel getTableModel() {
        return this.tableModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class RankComparator
    implements Comparator {
        private RankComparator() {
        }

        public int compare(Object object, Object object2) {
            Double d = (Double)object;
            Double d2 = (Double)object2;
            return d2.compareTo(d);
        }
    }

    final class ChallengeTableModel
    extends SortedTableModel
    implements Coder.Listener {
        private Map rankByScore = new HashMap();
        private RankComparator rankComparator = new RankComparator();

        private ChallengeTableModel() {
            super(BaseAlgoSummaryTablePanel.this.tableModelHeaders, BaseAlgoSummaryTablePanel.this.tableModelClasses);
            if (BaseAlgoSummaryTablePanel.this.lastColumnIndexFix > 0) {
                this.addSortElement(new SortElement(BaseAlgoSummaryTablePanel.this.maxProblemColumn, true));
            }
            this.addSortElement(new SortElement(0, true));
            this.addSortElement(new SortElement(1, true));
            this.addSortElement(new SortElement(2, true));
            for (int i = 2; i < BaseAlgoSummaryTablePanel.this.maxProblemColumn; ++i) {
                this.addSortElement(new SortElement(i, true));
            }
            this.updateChallengeTable();
        }

        public void updateChallengeTable() {
            if (!BaseAlgoSummaryTablePanel.this.update) {
                return;
            }
            Collection collection = BaseAlgoSummaryTablePanel.this.getFilteredCoders();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Coder coder = (Coder)iterator.next();
                coder.addListener(this);
            }
            this.update(collection);
            this.updateRoomLeader();
        }

        public void updateRoomLeader() {
            if (!BaseAlgoSummaryTablePanel.this.update) {
                return;
            }
            List list = (List)this.getItemList();
            Double[] doubleArray = new Double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Coder coder = (Coder)list.get(i);
                doubleArray[i] = coder.getScore();
            }
            Arrays.sort(doubleArray, 0, doubleArray.length, this.rankComparator);
            this.rankByScore.clear();
            Double d = new Double(Double.MIN_VALUE);
            for (int i = 0; i < doubleArray.length; ++i) {
                if (d.equals(doubleArray[i])) continue;
                d = doubleArray[i];
                this.rankByScore.put(d, new Integer(i + 1));
            }
            this.sort();
        }

        private int getCoderRank(Coder coder) {
            if (BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundProperties().usesScore()) {
                Integer n = (Integer)this.rankByScore.get(coder.getScore());
                return n != null ? n : -1;
            }
            return 1;
        }

        public void coderEvent(Coder coder) {
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            Coder coder = this.getCoder(n);
            return this.getValueAt(coder, n2);
        }

        private Object getValueAt(Coder coder, int n) {
            if (n == 0) {
                return new Integer(this.getCoderRank(coder));
            }
            if (n == 1) {
                return coder.getRating();
            }
            if (n == 2) {
                return new UserNameEntry(coder.getHandle(), coder.getRating(), BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundProperties().usesScore() && BaseAlgoSummaryTablePanel.this.isRoomLeader(coder.getHandle()), coder.getUserType());
            }
            if (n >= 3 && n < BaseAlgoSummaryTablePanel.this.maxProblemColumn) {
                if (this.shouldUsePassedSystemTestsOnColumn(n)) {
                    return this.getComponentColumnValueAsTests(coder, n);
                }
                return this.getComponentColumnValueAsPoints(coder, n);
            }
            if (n == BaseAlgoSummaryTablePanel.this.maxProblemColumn) {
                return new Double(coder.getScore() / 100.0);
            }
            throw new IllegalArgumentException("Invalid column: " + n);
        }

        private boolean shouldUsePassedSystemTestsOnColumn(int n) {
            return BaseAlgoSummaryTablePanel.this.getRoundModel().getPhase() >= 9 && ResultDisplayType.PASSED_TESTS.equals(BaseAlgoSummaryTablePanel.this.resultDisplayRenderer[BaseAlgoSummaryTablePanel.this.getIndexOfRenderer(n)].getDisplayType());
        }

        private Object getComponentColumnValueAsPoints(Coder coder, int n) {
            int n2 = 2;
            ProblemModel[] problemModelArray = BaseAlgoSummaryTablePanel.this.getRoundModel().getProblems(BaseAlgoSummaryTablePanel.this.getDivisionID());
            for (int i = 0; i < problemModelArray.length; ++i) {
                double d = 0.0;
                for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                    d += coder.getComponent(problemModelArray[i].getComponents()[j].getID()).getPoints().doubleValue() / 100.0;
                    if (++n2 != n) continue;
                    return coder.getComponent(problemModelArray[i].getComponents()[j].getID());
                }
                if (problemModelArray[i].getProblemType() != 2 || ++n2 != n) continue;
                return new Double(d);
            }
            throw new IllegalArgumentException("Invalid column: " + n);
        }

        private Object getComponentColumnValueAsTests(Coder coder, int n) {
            int n2 = 2;
            ProblemModel[] problemModelArray = BaseAlgoSummaryTablePanel.this.getRoundModel().getProblems(BaseAlgoSummaryTablePanel.this.getDivisionID());
            for (int i = 0; i < problemModelArray.length; ++i) {
                int n3 = 0;
                for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                    Integer n4 = coder.getComponent(problemModelArray[i].getComponents()[j].getID()).getPassedSystemTests();
                    n3 += n4 == null ? 0 : n4;
                    if (++n2 != n) continue;
                    return coder.getComponent(problemModelArray[i].getComponents()[j].getID());
                }
                if (problemModelArray[i].getProblemType() != 2 || ++n2 != n) continue;
                return new Integer(n3);
            }
            throw new IllegalArgumentException("Invalid column: " + n);
        }

        Coder getCoder(int n) {
            return (Coder)this.get(n);
        }

        private CoderComponent getCoderComponent(int n, int n2) {
            Coder coder = (Coder)this.get(n);
            ProblemModel[] problemModelArray = BaseAlgoSummaryTablePanel.this.getRoundModel().getProblems(BaseAlgoSummaryTablePanel.this.getDivisionID());
            int n3 = 2;
            CoderComponent coderComponent = null;
            boolean bl = false;
            for (int i = 0; !bl && i < problemModelArray.length; ++i) {
                for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                    if (++n3 != n2) continue;
                    coderComponent = coder.getComponent(problemModelArray[i].getComponents()[j].getID());
                    bl = true;
                }
                if (problemModelArray[i].getProblemType() != 2 || ++n3 != n2) continue;
                coderComponent = null;
                bl = true;
            }
            return coderComponent;
        }

        public int compare(Object object, Object object2) {
            Coder coder = (Coder)object;
            Coder coder2 = (Coder)object2;
            Iterator iterator = this.getSortListIterator();
            while (iterator.hasNext()) {
                int n;
                SortElement sortElement = (SortElement)iterator.next();
                int n2 = sortElement.getColumn();
                int n3 = n = sortElement.isOpposite() ? -1 : 1;
                if (n2 == 0) {
                    int n4 = this.getCoderRank(coder) - this.getCoderRank(coder2);
                    if (n4 == 0) continue;
                    return n * n4;
                }
                if (n2 == 1) {
                    int n5 = coder.getRating() - coder2.getRating();
                    if (n5 == 0) continue;
                    return n * n5;
                }
                if (n2 == 2) {
                    int n6 = ChallengeTableModel.compareStrings(coder.getHandle(), coder2.getHandle());
                    if (n6 == 0) continue;
                    return n * n6;
                }
                if (n2 >= 3 && n2 < BaseAlgoSummaryTablePanel.this.maxProblemColumn) {
                    int n7 = this.shouldUsePassedSystemTestsOnColumn(n2) ? this.compareCoderByComponentPassedTestsColumn(coder, coder2, n2) : (BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundProperties().usesScore() ? this.compareCoderByComponentPointsColumn(coder, coder2, n2) : this.compareCoderByComponentStatusColumn(coder, coder2, n2));
                    if (n7 == 0) continue;
                    return n7 * n;
                }
                if (n2 == BaseAlgoSummaryTablePanel.this.maxProblemColumn) {
                    double d = coder.getScore() - coder2.getScore();
                    if (d == 0.0) continue;
                    return n * (d > 0.0 ? 1 : -1);
                }
                throw new IllegalStateException("bad sort column =" + sortElement);
            }
            return 0;
        }

        private int compareCoderByComponentStatusColumn(Coder coder, Coder coder2, int n) {
            Object object = this.getValueAt(coder, n);
            Object object2 = this.getValueAt(coder2, n);
            if (object instanceof CoderComponent) {
                return ((CoderComponent)object).getStatus().compareTo(((CoderComponent)object2).getStatus());
            }
            return ((Comparable)object).compareTo(object2);
        }

        private int compareCoderByComponentPassedTestsColumn(Coder coder, Coder coder2, int n) {
            Object object = this.getValueAt(coder, n);
            Object object2 = this.getValueAt(coder2, n);
            if (object instanceof CoderComponent) {
                Integer n2 = ((CoderComponent)object).getPassedSystemTests();
                Integer n3 = ((CoderComponent)object2).getPassedSystemTests();
                if (n2 == null) {
                    return n3 == null ? 0 : -1;
                }
                if (n3 == null) {
                    return 1;
                }
                return n2.compareTo(n3);
            }
            return ((Comparable)object).compareTo(object2);
        }

        private int compareCoderByComponentPointsColumn(Coder coder, Coder coder2, int n) {
            Object object = this.getValueAt(coder, n);
            Object object2 = this.getValueAt(coder2, n);
            if (object instanceof CoderComponent) {
                return ((CoderComponent)object).getPoints().compareTo(((CoderComponent)object2).getPoints());
            }
            return ((Comparable)object).compareTo(object2);
        }
    }
}

