/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.room;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.widgets.ImageIconPanel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.HeartbeatListener;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class TimerPanel
extends ImageIconPanel
implements HeartbeatListener {
    private final NumberFormat systestFormat = new DecimalFormat("0.00");
    private final NumberFormat doubleDigitFormat = new DecimalFormat("00");
    private final DateFormat clockFormat = new SimpleDateFormat("h:mm:ss a z");
    private int testsDone;
    private int totalSystests;
    private JLabel timerTitle = null;
    private JLabel timer = null;
    private ContestApplet contestApplet = null;
    private int mode = 1;
    private boolean warned = false;
    private RoundModel roundModel;
    private StringBuffer countdownBuffer = new StringBuffer();

    protected TimerPanel(ContestApplet contestApplet, LayoutManager layoutManager, ImageIcon imageIcon) {
        super(layoutManager, imageIcon);
        this.contestApplet = contestApplet;
        contestApplet.getModel().addHeartbeatListener(this);
    }

    public TimerPanel(ContestApplet contestApplet) {
        super((LayoutManager)new GridBagLayout(), Common.getImage("timer.gif", contestApplet));
        this.contestApplet = contestApplet;
        this.setMinimumSize(new Dimension(165, 72));
        this.setPreferredSize(new Dimension(165, 72));
        this.createTimer(0, 0);
        contestApplet.getModel().addHeartbeatListener(this);
    }

    public void setMode(int n) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid mode: " + n);
        }
        if (n == 2 && this.roundModel == null) {
            throw new IllegalStateException("Cannot start countdown with null roundModel!");
        }
        this.mode = n;
    }

    public void setRoundModel(RoundModel roundModel) {
        if (roundModel != this.roundModel) {
            this.resetOnRoundChanged();
        }
        this.roundModel = roundModel;
    }

    private void resetOnRoundChanged() {
        this.testsDone = 0;
        this.totalSystests = 0;
    }

    public void unsetRoundModel() {
        this.setMode(1);
        this.roundModel = null;
    }

    protected void createTimer(int n, int n2) {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 0;
        this.timerTitle = new JLabel("TOPCODER TIME");
        this.timerTitle.setForeground(Common.TIMER_COLOR);
        this.timerTitle.setFont(new Font("SansSerif", 0, 10));
        this.timer = new JLabel("00:00:00");
        this.timer.setForeground(Common.TIMER_COLOR);
        this.timer.setFont(new Font("SansSerif", 0, 12));
        gridBagConstraints.insets = new Insets(30 + n2, 37 + n, 3, 15);
        Common.insertInPanel(this.timerTitle, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.insets = new Insets(2, 37 + n, 15, 15);
        Common.insertInPanel(this.timer, this, gridBagConstraints, 0, 1, 1, 1, 0.1, 0.1);
        this.setToolTipText("The Contest Timer counts down the different phases of a competition.");
        this.setMode(1);
    }

    public void setTitle(String string) {
        this.timerTitle.setText(string);
    }

    public void updateSystestProgress(int n, int n2) {
        this.testsDone = n;
        this.totalSystests = n2;
    }

    private void updateSystestProgress() {
        String string;
        if (this.totalSystests == 0) {
            string = "00:00:00";
        } else {
            double d = 100.0 * (double)this.testsDone / (double)this.totalSystests;
            String string2 = this.systestFormat.format(d);
            string = "" + string2 + "% of " + this.totalSystests;
        }
        this.timer.setText(string);
        this.timer.repaint();
    }

    private void countdown() {
        if (this.roundModel == null) {
            throw new IllegalStateException("Missing round model: " + this.roundModel);
        }
        this.countdownBuffer.setLength(0);
        int n = this.roundModel.getSecondsLeftInPhase();
        if (this.roundModel.getRoundProperties().usesPerUserCodingTime() && n == 0 && this.roundModel.getPhase() == 4) {
            this.countdownBuffer.append("EXPIRED");
            this.warn();
        } else {
            this.countdownBuffer.append(this.doubleDigitFormat.format(n / 3600));
            this.countdownBuffer.append(':');
            this.countdownBuffer.append(this.doubleDigitFormat.format((n %= 3600) / 60));
            this.countdownBuffer.append(':');
            this.countdownBuffer.append(this.doubleDigitFormat.format(n % 60));
        }
        this.timer.setText(this.countdownBuffer.toString());
        this.timer.repaint();
    }

    private void warn() {
        if (!this.warned) {
            Common.showMessage("Alert", "Your time has expired", this);
            this.warned = true;
        }
    }

    public void tick() {
        switch (this.mode) {
            case 1: {
                this.timer.setText(this.clockFormat.format(new Date(this.contestApplet.getModel().getServerTime())));
                this.timer.repaint();
                break;
            }
            case 2: {
                this.countdown();
                break;
            }
            case 3: {
                this.updateSystestProgress();
                break;
            }
        }
    }

    public boolean isRoundModelInitialized() {
        return this.roundModel != null;
    }
}

