/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.main;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.events.MainMenuEvents;
import com.topcoder.client.contestApplet.panels.main.ActiveRoundsMenu;
import com.topcoder.client.contestApplet.panels.main.TCCheckBoxMenuItem;
import com.topcoder.client.contestApplet.panels.main.TCMenu;
import com.topcoder.client.contestApplet.panels.main.TCMenuItem;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.MenuView;
import com.topcoder.netCommon.contestantMessages.response.data.CategoryData;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public final class MainMenuPanel
extends JPanel
implements MenuView {
    private final MenuItemInfo[] TOOLS_MENU = new MenuItemInfo[]{new MenuItemInfo("Room Summary", 's', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.statusWindowEvent(actionEvent);
        }
    })};
    private final MenuItemInfo[] TOOLS_MENU_PlUGINS = new MenuItemInfo[]{new MenuItemInfo("Room Summary", 's', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.statusWindowEvent(actionEvent);
        }
    }), new MenuItemInfo("TopCoder Plugins", 'p', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.contestPluginsEvent();
        }
    })};
    private final MenuItemInfo[] PRACTICE_OPTIONS_MENU = new MenuItemInfo[]{new MenuItemInfo("Clear All Problems", 'c', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.clearProblemsEvent();
        }
    }), new MenuItemInfo("Clear Problem(s)", 'p', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.clearSelectedProblemEvent();
        }
    }), new MenuItemInfo("Run System Test", 'r', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.systemTestEvent();
        }
    })};
    private final MenuItemInfo[] HELP_MENU = new MenuItemInfo[]{new MenuItemInfo("Competition Manual", 'm', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.contestManualEvent();
        }
    }), new MenuItemInfo("Competition FAQ", 'F', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.contestFAQEvent();
        }
    }), new MenuItemInfo("ChangeLog", 'l', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.changeLogEvent();
        }
    }), new MenuItemInfo("About", 'a', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.aboutEvent();
        }
    })};
    private final MenuItemInfo[] HELP_MENU_SUN = new MenuItemInfo[]{new MenuItemInfo("About", 'a', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.aboutEvent();
        }
    })};
    private final MenuItemInfo[] MAIN_MENU = new MenuItemInfo[]{new MenuItemInfo("Search", 's', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.searchButtonEvent();
        }
    }), new MenuItemInfo("Visited Practice Rooms", 'v', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.visitedPracticeEvent();
        }
    }), new MenuItemInfo("Active Users", 'a', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.activeUsersButtonEvent();
        }
    }), new MenuItemInfo("Important Messages", 'i', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.importantMessagesButtonEvent();
        }
    }), new MenuItemInfo("Logoff", 'f', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.logoffButtonEvent();
        }
    })};
    private final MenuItemInfo[] OPTIONS_MENU_2 = new MenuItemInfo[]{new MenuItemInfo("Editor", 'e', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.editorOptionsEvent();
        }
    }), new MenuItemInfo("Setup User Preferences", 's', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.setupUserPreferences();
        }
    })};
    private final MenuItemInfo[] OPTIONS_MENU_3 = new MenuItemInfo[]{new MenuItemInfo("Setup User Preferences", 's', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.setupUserPreferences();
        }
    })};
    private final MenuItemInfo[] OPTIONS_MENU = new MenuItemInfo[]{new MenuItemInfo("Disable Chat", 'c', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.chatToggleEvent();
        }
    }), new MenuItemInfo("Disable Chat History", 'y', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.disableChatHistory();
        }
    }, "com.topcoder.jmaContestApplet.ContestApplet.disableChatHistory"), new MenuItemInfo("Disable Chat Scrolling", 's', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.chatScrollingEvent(actionEvent);
        }
    }, "com.topcoder.jmaContesntApplet.ContestApplet.disableChatScrolling"), new MenuItemInfo("Disable Auto-Enhanced Chat", 'A', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.disableAutoEnhancedChat();
        }
    }, "com.topcoder.jmaContestApplet.ContestApplet.disableAutoEnhancedChat"), new MenuItemInfo("Disable Enter/Exit Messages", 'e', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.disableEnterExitMsgsEvent();
        }
    }, "com.topcoder.jmaContestApplet.ContestApplet.disableEnterExitMsgs"), new MenuItemInfo("Disable Broadcast Popup", 'b', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.disableBroadcastPopup();
        }
    }, "com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastPopup"), new MenuItemInfo("Disable Broadcast Beep", 'p', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.disableBroadcastBeep();
        }
    }, "com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastBeep"), new MenuItemInfo("Disable Chat/Find Tabs", 'f', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.disableChatFindTabs();
        }
    }, "com.topcoder.jmaContestApplet.ContestApplet.disableChatFindTabs"), new MenuItemInfo("Enable Timestamps", 'p', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.enableTimestamps();
        }
    }, "com.topcoder.jmaContesntApplet.ContestApplet.enableTimestamps"), new MenuItemInfo("Enable Unused Code Check", 'u', new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainMenuPanel.this.mme.enabledUnusedCodeCheck();
        }
    }, "com.topcoder.client.contestApplet.common.LocalPreferences.UnusedCodeCheckEnabled")};
    private ContestApplet ca = null;
    private JMenuBar menuBar = null;
    private ActiveRoundsMenu activeMenu = null;
    private TCMenu chatMenu;
    private TCMenu mainMenu = null;
    private TCMenu optionsMenu = null;
    private TCMenu practiceMenu = null;
    private TCMenu practiceOptionsMenu = null;
    private TCMenu activeRoomMenu = null;
    private TCMenu toolsMenu = null;
    private TCMenu lobbyMenu;
    private TCMenu helpMenu = null;
    private MainMenuEvents mme = null;

    public MainMenuPanel(ContestApplet contestApplet) {
        super(new GridBagLayout());
        this.ca = contestApplet;
        this.mme = new MainMenuEvents(contestApplet);
        this.setCursor(new Cursor(12));
        this.setBackground(Common.TOP_BACK);
        this.create();
    }

    public void setMenuEnabled(boolean bl) {
        this.chatMenu.setEnabled(bl);
        this.mainMenu.setEnabled(bl);
        this.optionsMenu.setEnabled(bl);
        this.practiceMenu.setEnabled(bl);
        this.practiceOptionsMenu.setEnabled(bl);
        this.activeMenu.setEnabled(bl);
        this.toolsMenu.setEnabled(bl);
        this.lobbyMenu.setEnabled(bl);
        this.helpMenu.setEnabled(bl);
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.menuBar = new JMenuBar();
        TCMenu tCMenu = this.createMenu("Main", this.MAIN_MENU, 'm');
        TCMenu tCMenu2 = this.createOptionsMenu("Options", this.OPTIONS_MENU, this.OPTIONS_MENU_2, 'o');
        if (this.ca.getPoweredByView() || this.ca.getCompanyName().startsWith("Sun")) {
            this.OPTIONS_MENU[this.OPTIONS_MENU.length - 1].setEnabled(false);
            tCMenu2 = this.createOptionsMenu("Options", this.OPTIONS_MENU, this.OPTIONS_MENU_3, 'o');
        }
        TCMenu tCMenu3 = this.createEmptyMenu("Lobbies", 'b');
        TCMenu tCMenu4 = this.createEmptyMenu("Practice Rooms", 'p');
        TCMenu tCMenu5 = this.createMenu("Practice Options", this.PRACTICE_OPTIONS_MENU, 'c');
        TCMenu tCMenu6 = this.createMenu("Tools", this.TOOLS_MENU_PlUGINS, 't');
        if (this.ca.getPoweredByView() || this.ca.getCompanyName().startsWith("Sun")) {
            tCMenu6 = this.createMenu("Tools", this.TOOLS_MENU, 't');
        }
        TCMenu tCMenu7 = this.createEmptyMenu("Moderated Chats", 'd');
        TCMenu tCMenu8 = this.createMenu("Help", this.HELP_MENU, 'h');
        if (this.ca.getPoweredByView() || this.ca.getCompanyName().startsWith("Sun")) {
            tCMenu8 = this.createMenu("Help", this.HELP_MENU_SUN, 'h');
        }
        this.activeMenu = this.ca.getActiveRoundsMenu();
        this.menuBar.setBackground(Common.TOP_BACK);
        this.menuBar.add(tCMenu);
        this.menuBar.add(tCMenu3);
        this.menuBar.add(tCMenu2);
        this.menuBar.add(tCMenu4);
        this.menuBar.add(tCMenu5);
        this.menuBar.add(this.activeMenu);
        this.menuBar.add(tCMenu6);
        if (!this.ca.getPoweredByView()) {
            this.menuBar.add(tCMenu8);
        }
        this.menuBar.setMinimumSize(new Dimension(0, 20));
        this.menuBar.setPreferredSize(new Dimension(0, 20));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(this.menuBar, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        this.mainMenu = tCMenu;
        this.lobbyMenu = tCMenu3;
        this.optionsMenu = tCMenu2;
        this.practiceMenu = tCMenu4;
        this.practiceOptionsMenu = tCMenu5;
        this.chatMenu = tCMenu7;
        this.activeRoomMenu = this.activeMenu;
        this.toolsMenu = tCMenu6;
        this.helpMenu = tCMenu8;
        this.createActiveChatMenu(new ArrayList(), new ArrayList(), new ArrayList());
    }

    private TCMenu createEmptyMenu(String string, char c) {
        return this.createMenu(string, new MenuItemInfo[0], c);
    }

    private TCMenu createMenu(String string, MenuItemInfo[] menuItemInfoArray, char c) {
        TCMenu tCMenu = new TCMenu(string, 120, 14, c);
        for (int i = 0; i < menuItemInfoArray.length; ++i) {
            MenuItemInfo menuItemInfo = menuItemInfoArray[i];
            TCMenuItem tCMenuItem = new TCMenuItem(menuItemInfo);
            tCMenu.add(tCMenuItem);
        }
        tCMenu.repaint();
        return tCMenu;
    }

    private TCMenu createOptionsMenu(String string, MenuItemInfo[] menuItemInfoArray, MenuItemInfo[] menuItemInfoArray2, char c) {
        JMenuItem jMenuItem;
        MenuItemInfo menuItemInfo;
        int n;
        TCMenu tCMenu = new TCMenu(string, 120, 14, c);
        for (n = 0; n < menuItemInfoArray.length; ++n) {
            menuItemInfo = menuItemInfoArray[n];
            jMenuItem = new TCCheckBoxMenuItem(menuItemInfo);
            jMenuItem.setEnabled(menuItemInfo.isEnabled());
            tCMenu.add(jMenuItem);
        }
        for (n = 0; n < menuItemInfoArray2.length; ++n) {
            menuItemInfo = menuItemInfoArray2[n];
            jMenuItem = new TCMenuItem(menuItemInfo);
            jMenuItem.setEnabled(menuItemInfo.isEnabled());
            tCMenu.add(jMenuItem);
        }
        return tCMenu;
    }

    public boolean isChatEnabled() {
        return !this.optionsMenu.getItem(0).isSelected();
    }

    public void setMenuConfig(int n, RoomModel roomModel) {
        switch (n) {
            case 0: 
            case 3: 
            case 8: {
                this.practiceOptionsMenu.setVisible(false);
                this.toolsMenu.setVisible(false);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                this.practiceOptionsMenu.setVisible(false);
                this.toolsMenu.setVisible(true);
                break;
            }
            case 5: {
                this.practiceOptionsMenu.setVisible(false);
                this.toolsMenu.setVisible(true);
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                this.practiceOptionsMenu.setVisible(!roomModel.getRoundModel().getRoundType().isLongRound());
                this.toolsMenu.setVisible(true);
                break;
            }
            case 6: {
                System.err.println("Unsupported room type (" + n + ").");
                this.practiceOptionsMenu.setVisible(false);
                this.toolsMenu.setVisible(false);
                break;
            }
            case -2: {
                System.err.println("Room type (" + n + ") invalid.");
                this.practiceOptionsMenu.setVisible(false);
                this.toolsMenu.setVisible(false);
                break;
            }
            default: {
                this.practiceOptionsMenu.setVisible(false);
                this.toolsMenu.setVisible(false);
            }
        }
    }

    public void createLobbyMenu(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        boolean[] blArray = new boolean[stringArray.length];
        Object[] objectArray = new Long[stringArray.length];
        for (int i = 0; i < arrayList3.size(); ++i) {
            Integer n = (Integer)arrayList3.get(i);
            objectArray[i] = new Long(n.longValue());
            blArray[i] = arrayList2.get(i).equals("A");
        }
        this.lobbyMenu.addToMenu(stringArray, blArray, objectArray, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenuPanel.this.lobbyEvent(actionEvent);
            }
        });
    }

    public void modifyLobbyMenu(String string, String string2) {
        MainMenuPanel.modifyMenu(this.lobbyMenu, string, string2);
    }

    public void createActiveChatMenu(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        if (arrayList.isEmpty()) {
            arrayList.add("No Active Chats");
            arrayList2.add("I");
            arrayList3.add(new Integer(-2));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        boolean[] blArray = new boolean[stringArray.length];
        Object[] objectArray = new Long[stringArray.length];
        for (int i = 0; i < arrayList3.size(); ++i) {
            Integer n = (Integer)arrayList3.get(i);
            objectArray[i] = new Long(n.longValue());
            blArray[i] = arrayList2.get(i).equals("A");
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenuPanel.this.activeChatsEvent(actionEvent);
            }
        };
        this.chatMenu.addToMenu(stringArray, blArray, objectArray, actionListener);
    }

    public void updatePracticeRounds(Contestant contestant) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenuPanel.this.practiceEvent(actionEvent);
            }
        };
        RoundModel[] roundModelArray = contestant.getPracticeRounds();
        CategoryData[] categoryDataArray = contestant.getRoundCategories();
        this.practiceMenu.removeAll();
        this.practiceMenu.buildCategorizedCascadingMenu(roundModelArray, categoryDataArray, actionListener);
    }

    private static void modifyMenu(JMenu jMenu, String string, String string2) {
        int n = -1;
        for (int i = 0; i <= jMenu.getItemCount(); ++i) {
            if (!jMenu.getItem(i).getText().equals(string)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            if (!string2.equals("A")) {
                jMenu.getItem(n).setEnabled(false);
            } else {
                jMenu.getItem(n).setEnabled(true);
            }
        }
    }

    public void modifyActiveChatMenu(String string, String string2) {
        JMenuItem jMenuItem = null;
        for (int i = 0; jMenuItem == null && i < this.chatMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem2 = this.chatMenu.getItem(i);
            if (jMenuItem2.getText().equals("No Active Chats") || !jMenuItem2.getText().equals(string)) continue;
            jMenuItem = jMenuItem2;
        }
        if (jMenuItem != null) {
            jMenuItem.setEnabled(string2.equals("A"));
        }
    }

    private void practiceEvent(ActionEvent actionEvent) {
        TCMenuItem tCMenuItem = (TCMenuItem)actionEvent.getSource();
        if (!tCMenuItem.hasUserData()) {
            throw new IllegalStateException("Missing round in menu item: " + tCMenuItem);
        }
        RoundModel roundModel = (RoundModel)tCMenuItem.getUserData();
        this.ca.getRoomManager().loadRoom(roundModel.getRoundType().isTeamRound() ? 10 : 4, roundModel.getCoderRooms()[0].getRoomID(), 2);
    }

    private void activeChatsEvent(ActionEvent actionEvent) {
        TCMenuItem tCMenuItem = (TCMenuItem)actionEvent.getSource();
        if (tCMenuItem.getText().equals("No Active Chats")) {
            return;
        }
        this.ca.getRoomManager().loadRoom(8, (Long)tCMenuItem.getUserData(), 2);
    }

    private void lobbyEvent(ActionEvent actionEvent) {
        TCMenuItem tCMenuItem = (TCMenuItem)actionEvent.getSource();
        this.ca.getRoomManager().loadRoom(3, (Long)tCMenuItem.getUserData(), 2);
    }
}

