/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.rooms.CoderRoomInterface;
import com.topcoder.client.contestApplet.widgets.RoundBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class TeamProblemPanel
extends JPanel {
    private ContestApplet ca = null;
    private JComboBox problemList = null;
    private JComboBox componentList = null;
    private JLabel phaseStatus = null;
    private JLabel phaseDesc = null;
    private boolean isCoderRoom = true;

    public TeamProblemPanel(ContestApplet contestApplet, boolean bl) {
        super(new GridBagLayout());
        this.ca = contestApplet;
        this.isCoderRoom = bl;
        this.setOpaque(false);
        this.setBorder(new RoundBorder(Common.PB_COLOR, 5, true));
        this.setMinimumSize(new Dimension(0, 60));
        this.setPreferredSize(new Dimension(0, 60));
        this.create();
        this.setPhase(0);
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.phaseStatus = new JLabel("");
        this.phaseDesc = new JLabel("");
        this.phaseStatus.setFont(new Font("SansSerif", 0, 10));
        this.phaseStatus.setForeground(Common.THF_COLOR);
        this.phaseDesc.setFont(new Font("SansSerif", 0, 10));
        this.phaseDesc.setForeground(Color.white);
        JLabel jLabel = new JLabel(Common.getImage("dotted_line.gif", this.ca));
        JLabel jLabel2 = new JLabel(Common.getImage("dotted_line.gif", this.ca));
        JComboBox jComboBox = Common.createComboBox();
        JComboBox jComboBox2 = Common.createComboBox();
        JButton jButton = Common.getImageButton("g_summary_but.gif", this.ca);
        jButton.setMnemonic('s');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TeamProblemPanel.this.statusWindowEvent(actionEvent);
            }
        });
        jPanel.setBackground(Common.BG_COLOR);
        gridBagConstraints.insets = new Insets(4, 5, -1, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        Common.insertInPanel(jComboBox, jPanel, gridBagConstraints, 1, 0, 1, 1, 0.0, 0.1);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(-1, 5, 4, 5);
        Common.insertInPanel(jComboBox2, jPanel, gridBagConstraints, 1, 1, 1, 1, 0.0, 0.1);
        gridBagConstraints.insets = new Insets(0, 10, -1, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 2, 0, 1, 2, 0.0, 0.1);
        Common.insertInPanel(jButton, jPanel, gridBagConstraints, 3, 0, 1, 2, 0.0, 0.1);
        Common.insertInPanel(jLabel2, jPanel, gridBagConstraints, 4, 0, 1, 2, 0.0, 0.1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        Common.insertInPanel(this.phaseStatus, jPanel, gridBagConstraints, 5, 0, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        Common.insertInPanel(this.phaseDesc, jPanel, gridBagConstraints, 5, 1, 1, 1, 1.0, 0.1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Common.insertInPanel(jPanel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        this.problemList = jComboBox;
        this.componentList = jComboBox2;
    }

    public void setPhase(int n) {
        switch (n) {
            case 0: {
                this.phaseStatus.setText("COMPETITION STATUS : 0. COMPETITION INACTIVE");
                this.phaseDesc.setText("The contest is currently not running.");
                break;
            }
            case 2: {
                this.phaseStatus.setText("COMPETITION STATUS : 0. REGISTRATION PHASE");
                this.phaseDesc.setText("Select event registration from the main menu.");
                break;
            }
            case 1: 
            case 3: {
                this.phaseStatus.setText("COMPETITION STATUS : 0. STARTS IN");
                this.phaseDesc.setText("The competition will start at the end of the countdown.");
                break;
            }
            case 4: {
                this.phaseStatus.setText("COMPETITION STATUS : 1. CODING PHASE");
                if (this.isCoderRoom) {
                    this.phaseDesc.setText("Select a problem from the problem list.");
                    break;
                }
                this.phaseDesc.setText("Please select the status window from the tools menu.");
                break;
            }
            case 5: {
                this.phaseStatus.setText("COMPETITION STATUS : 2. INTERMISSION");
                this.phaseDesc.setText("Please wait for the challenge phase to start.");
                break;
            }
            case 6: {
                this.phaseStatus.setText("COMPETITION STATUS : 3. CHALLENGE PHASE");
                this.phaseDesc.setText("Please select the status window from the tools menu.");
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.phaseStatus.setText("COMPETITION STATUS : 4. SYSTEM TESTING PHASE");
                this.phaseDesc.setText("Please wait for the system test phase to end.");
                break;
            }
            case 12: {
                this.phaseStatus.setText("MODERATED CHAT STATUS : 1. CHATTING");
                this.phaseDesc.setText("Ask questions with /moderator.");
                break;
            }
            default: {
                System.err.println("Unknown phase (" + n + ").");
            }
        }
    }

    public JComboBox getProblemList() {
        return this.problemList;
    }

    public JComboBox getComponentList() {
        return this.componentList;
    }

    private void statusWindowEvent(ActionEvent actionEvent) {
        ((CoderRoomInterface)((Object)this.ca.getRoomManager().getCurrentRoom())).challengeButtonEvent(actionEvent);
    }
}

