/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.UserAssignmentPanel;
import com.topcoder.client.contestApplet.panels.coding.CodingTimerPanel;
import com.topcoder.client.contestApplet.panels.room.TimerPanel;
import com.topcoder.client.contestApplet.panels.table.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.panels.table.ChallengeTablePanel;
import com.topcoder.client.contestApplet.panels.table.LongSummaryTablePanel;
import com.topcoder.client.contestApplet.widgets.MouseLessTextArea;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestApplet.widgets.ResultDisplayTypeSelectionPanel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ChallengeFrame
extends JFrame {
    private ContestApplet parentFrame = null;
    private AbstractSummaryTablePanel challengePanel = null;
    private CodingTimerPanel timerPanel = null;
    private boolean once = true;
    private JRadioButton jrb2 = null;
    private UserAssignmentPanel userAssignmentPanel = null;
    private RoomModel room;
    private boolean open = false;
    private boolean enabled = true;
    private ResultDisplayTypeSelectionPanel resultDisplayTypeSelectionPanel;

    public ChallengeFrame(ContestApplet contestApplet, RoomModel roomModel) {
        super("TopCoder Competition Arena - Competition Details");
        this.parentFrame = contestApplet;
        this.room = roomModel;
        this.create();
    }

    public void showFrame(boolean bl) {
        if (this.once) {
            Common.setLocationRelativeTo((Component)this.parentFrame.getMainFrame(), this);
            this.once = false;
        }
        this.show();
        if (!this.open) {
            this.parentFrame.getRequester().requestOpenSummary(this.room.getRoomID());
        }
        this.open = true;
        MoveFocus.moveFocus(this.challengePanel.getTable());
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        MouseLessTextArea mouseLessTextArea = this.room.getRoundModel().getRoundProperties().hasChallengePhase() ? new MouseLessTextArea("During the challenge phase, you can right click on submitted problems to view a user's source code, or to challenge the validity of the user's problem.") : new MouseLessTextArea("After the coding phase, you can right click on submitted problems to view a user's source code.");
        JPanel jPanel = Common.createMessagePanel("Instructions", mouseLessTextArea, 0, 100, Common.BG_COLOR);
        AbstractSummaryTablePanel abstractSummaryTablePanel = this.room.getRoundModel() != null && this.room.getRoundModel().getRoundType().isLongRound() ? new LongSummaryTablePanel(this.parentFrame, this.room, this, true) : new ChallengeTablePanel(this.parentFrame, this.room, this, false);
        CodingTimerPanel codingTimerPanel = new CodingTimerPanel(this.parentFrame);
        JPanel jPanel2 = this.createPrettyTogglePanel();
        this.timerPanel = codingTimerPanel;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        abstractSummaryTablePanel.setPreferredSize(new Dimension(675, 310));
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(jPanel, this.getContentPane(), gridBagConstraints, 0, 0, 1, 3, 1.0, 0.0);
        gridBagConstraints.insets = new Insets(25, 5, 5, 15);
        gridBagConstraints.fill = 0;
        Common.insertInPanel(codingTimerPanel, this.getContentPane(), gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 5, 0, 15);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(jPanel2, this.getContentPane(), gridBagConstraints, 1, 1, 1, 1, 0.0, 0.0);
        if (this.parentFrame.getModel().getUserInfo().isCaptain() && (this.parentFrame.getModel().getCurrentRoom().getType() == 9 || this.parentFrame.getModel().getCurrentRoom().getType() == 10 || this.parentFrame.getModel().getCurrentRoom().getType() == 13)) {
            this.userAssignmentPanel = new UserAssignmentPanel(this.parentFrame, this.room);
            gridBagConstraints.insets = new Insets(5, 15, 15, 15);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            Common.insertInPanel(this.userAssignmentPanel, this.getContentPane(), gridBagConstraints, 0, 3, 2, 1, 0.0, 1.0);
        }
        if (this.parentFrame.getCompanyName().equals("SunOnsite") && !this.room.isPracticeRoom()) {
            JPanel jPanel3 = this.createViewResultsPanel();
            gridBagConstraints.insets = new Insets(0, 5, 0, 15);
            gridBagConstraints.fill = 1;
            Common.insertInPanel(jPanel3, this.getContentPane(), gridBagConstraints, 1, 2, 1, 1, 0.0, 0.0);
        }
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(abstractSummaryTablePanel, this.getContentPane(), gridBagConstraints, 0, 4, 2, 1, 0.1, 0.1);
        this.challengePanel = abstractSummaryTablePanel;
        this.pack();
    }

    public void hide() {
        super.hide();
        this.challengePanel.closeSourceViewer();
        if (this.open && this.enabled) {
            this.parentFrame.getRequester().requestCloseSummary(this.room.getRoomID());
        }
        this.open = false;
    }

    public boolean getPrettyToggle() {
        return this.jrb2.isSelected();
    }

    private JPanel createPrettyTogglePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        if (this.room.getRoundModel().getRoundType().isLongRound()) {
            return jPanel;
        }
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel("Pretty : ", 2);
        JRadioButton jRadioButton = new JRadioButton("Off", true);
        JRadioButton jRadioButton2 = new JRadioButton("On", false);
        jLabel.setToolTipText("Reformat source code for readability.");
        jLabel.setForeground(Color.white);
        jRadioButton.setBackground(Common.WPB_COLOR);
        jRadioButton2.setBackground(Common.WPB_COLOR);
        jRadioButton.setForeground(Color.white);
        jRadioButton2.setForeground(Color.white);
        jRadioButton.setOpaque(false);
        jRadioButton2.setOpaque(false);
        jRadioButton.setActionCommand("Standard");
        jRadioButton2.setActionCommand("VI");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        this.jrb2 = jRadioButton2;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setOpaque(false);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.3, 0.1);
        Common.insertInPanel(jPanel2, jPanel, gridBagConstraints, 1, 0, 2, 1, 0.1, 0.1);
        JLabel jLabel2 = new JLabel("View : ", 2);
        jLabel2.setToolTipText("View challenge/test status or point values.");
        jLabel2.setForeground(Color.white);
        this.resultDisplayTypeSelectionPanel = new ResultDisplayTypeSelectionPanel(this.room.getRoundModel(), new ResultDisplayTypeSelectionPanel.Listener(){

            public void typeChanged(ResultDisplayType resultDisplayType) {
                ChallengeFrame.this.challengePanel.updateView(resultDisplayType);
            }
        });
        Common.insertInPanel(jLabel2, jPanel, gridBagConstraints, 0, 1, 1, 1, 0.3, 0.1);
        Common.insertInPanel(this.resultDisplayTypeSelectionPanel, jPanel, gridBagConstraints, 1, 1, 2, 1, 0.1, 0.1);
        return jPanel;
    }

    public TimerPanel getTimerPanel() {
        return this.timerPanel;
    }

    private JPanel createViewResultsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        JButton jButton = new JButton("System Test Results");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChallengeFrame.this.parentFrame.getRequester().requestSystestResults(ChallengeFrame.this.room.getRoundModel().getRoundID().intValue());
            }
        });
        jPanel.setOpaque(false);
        Common.insertInPanel(jButton, jPanel, gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0);
        return jPanel;
    }

    public AbstractSummaryTablePanel getChallengePanel() {
        return this.challengePanel;
    }

    public UserAssignmentPanel getAssignmentPanel() {
        return this.userAssignmentPanel;
    }
}

