/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet;

import com.topcoder.client.contestApplet.TCSecurityManager;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.DynamicEditor;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.contestApplet.editors.PluginManager;
import com.topcoder.client.contestApplet.frames.BadgeIdDialog;
import com.topcoder.client.contestApplet.frames.MainFrame;
import com.topcoder.client.contestApplet.frames.RoundStatsFrame;
import com.topcoder.client.contestApplet.frames.TeamManagerFrame;
import com.topcoder.client.contestApplet.frames.VotingFrame;
import com.topcoder.client.contestApplet.frames.VotingResultsFrame;
import com.topcoder.client.contestApplet.frames.WLMyTeamInfoFrame;
import com.topcoder.client.contestApplet.frames.WLTeamsInfoFrame;
import com.topcoder.client.contestApplet.panels.main.ActiveRoundsMenu;
import com.topcoder.client.contestApplet.panels.main.MainMenuPanel;
import com.topcoder.client.contestApplet.rooms.CoderRoom;
import com.topcoder.client.contestApplet.rooms.RoomManager;
import com.topcoder.client.contestApplet.rooms.RoomModule;
import com.topcoder.client.contestApplet.uilogic.frames.ActiveUsersTableFrame;
import com.topcoder.client.contestApplet.uilogic.frames.AuthenticatorDialog;
import com.topcoder.client.contestApplet.uilogic.frames.BroadcastDialog;
import com.topcoder.client.contestApplet.uilogic.frames.BroadcastSummaryFrame;
import com.topcoder.client.contestApplet.uilogic.frames.CoderHistoryFrame;
import com.topcoder.client.contestApplet.uilogic.frames.ImportantMessageDialog;
import com.topcoder.client.contestApplet.uilogic.frames.ImportantMessageSummaryFrame;
import com.topcoder.client.contestApplet.uilogic.frames.LongTestResultsFrame;
import com.topcoder.client.contestApplet.uilogic.frames.MessageDialog;
import com.topcoder.client.contestApplet.uilogic.frames.MessageFrame;
import com.topcoder.client.contestApplet.uilogic.frames.PracticeSystestResultsFrame;
import com.topcoder.client.contestApplet.uilogic.frames.RegistrantsTableFrame;
import com.topcoder.client.contestApplet.uilogic.frames.RoomInfoFrame;
import com.topcoder.client.contestApplet.uilogic.frames.RoomListFrame;
import com.topcoder.client.contestApplet.uilogic.frames.StatementViewer;
import com.topcoder.client.contestApplet.uilogic.frames.SubmissionHistoryFrame;
import com.topcoder.client.contestApplet.uilogic.frames.SurveyDialog;
import com.topcoder.client.contestApplet.uilogic.frames.VisitedPracticeFrame;
import com.topcoder.client.contestant.BroadcastListener;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.LoginException;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.impl.ConnectionType;
import com.topcoder.client.contestant.impl.ContestantImpl;
import com.topcoder.client.contestant.message.Requester;
import com.topcoder.client.contestant.view.ContestantView;
import com.topcoder.client.contestant.view.EventService;
import com.topcoder.client.ui.UIFactory;
import com.topcoder.client.ui.UIManager;
import com.topcoder.netCommon.contestantMessages.AdminBroadcast;
import com.topcoder.netCommon.contestantMessages.response.CoderHistoryResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateVisitedPracticeResponse;
import com.topcoder.netCommon.contestantMessages.response.GetImportantMessagesResponse;
import com.topcoder.netCommon.contestantMessages.response.ImportantMessageResponse;
import com.topcoder.netCommon.contestantMessages.response.LongTestResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.NoBadgeIdResponse;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResponse;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResultResponse;
import com.topcoder.netCommon.contestantMessages.response.RoundStatsResponse;
import com.topcoder.netCommon.contestantMessages.response.SubmissionHistoryResponse;
import com.topcoder.netCommon.contestantMessages.response.VoteResponse;
import com.topcoder.netCommon.contestantMessages.response.VoteResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.WLMyTeamInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.WLTeamsInfoResponse;
import java.applet.AppletContext;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class ContestApplet
extends JApplet
implements ContestantView {
    private JApplet launchApplet = null;
    private Contestant model;
    private MessageFrame interFrame = null;
    private RoomManager roomManager = null;
    private MainFrame mainFrame = null;
    private JFrame currentFrame = null;
    private boolean disableChatScrolling = false;
    private boolean disableLeaderTicker = false;
    private boolean disableEnterExitMsgs = false;
    private boolean disableAutoEnhancedChat = false;
    private boolean disableChatHistory = false;
    private boolean disableChatFindTabs = false;
    private String companyName;
    private String sponsorName;
    private boolean poweredByView = false;
    private MainMenuPanel menuPanel = null;
    private HashMap roomHash = new HashMap();
    private RegistrantsTableFrame rtf = null;
    private RegistrantsTableFrame hsrtf = null;
    private RegistrantsTableFrame mmrtf = null;
    private ImportantMessageSummaryFrame imf = null;
    private PracticeSystestResultsFrame psrf = null;
    private ActiveUsersTableFrame autf = null;
    private TeamManagerFrame tmfm = null;
    private TeamManagerFrame tmfc = null;
    private ActiveRoundsMenu activeRoundsMenu;
    private VisitedPracticeFrame vpf = null;
    private UIManager currentUIManager = null;
    private BroadcastListener mainBroadcastListener = new BroadcastListener(){

        public void refreshBroadcasts() {
        }

        public void readBroadcast(AdminBroadcast adminBroadcast) {
        }

        public void newBroadcast(AdminBroadcast adminBroadcast) {
            String string = LocalPreferences.getInstance().getProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastPopup");
            String string2 = LocalPreferences.getInstance().getProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastBeep");
            if (string == null || !string.equals("true")) {
                new BroadcastDialog(ContestApplet.this, adminBroadcast).show();
            }
            if (string2 == null || !string2.equals("true")) {
                Toolkit.getDefaultToolkit().beep();
                Toolkit.getDefaultToolkit().beep();
                Toolkit.getDefaultToolkit().beep();
            }
        }
    };
    private boolean connected = true;
    private ArrayList messages = new ArrayList();
    private StatementViewer problemStatementViewer;

    public ActiveRoundsMenu getActiveRoundsMenu() {
        return this.activeRoundsMenu;
    }

    public UIManager getCurrentUIManager() {
        return this.currentUIManager;
    }

    protected Contestant createModel() {
        return new ContestantImpl();
    }

    public ContestApplet(String string, int n, String string2, String string3, String string4, boolean bl, String string5) {
        String string6;
        try {
            System.setSecurityManager(new TCSecurityManager());
        }
        catch (AccessControlException accessControlException) {
            System.out.println("Cannot create the security manager - plugins will not work");
        }
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        if (localPreferences != null) {
            string6 = localPreferences.getProperty("com.topcoder.jmaContestApplet.ContestApplet.disableEnterExitMsgs");
            this.disableEnterExitMsgs = string6 == null ? false : string6.equals("true");
            string6 = localPreferences.getProperty("com.topcoder.jmaContestApplet.ContestApplet.disableAutoEnhancedChat");
            this.disableAutoEnhancedChat = string6 == null ? false : string6.equals("true");
            string6 = localPreferences.getProperty("com.topcoder.jmaContestApplet.ContestApplet.disableChatHistory");
            this.disableChatHistory = string6 == null ? false : string6.equals("true");
            string6 = localPreferences.getProperty("com.topcoder.jmaContestApplet.ContestApplet.disableChatFindTabs");
            this.disableChatFindTabs = string6 == null ? false : string6.equals("true");
        }
        this.currentUIManager = null;
        string6 = localPreferences.getProperty("ui.theme", "Default");
        UIManager[] uIManagerArray = localPreferences.getAllUIManagers();
        for (int i = 0; i < uIManagerArray.length; ++i) {
            if (!uIManagerArray[i].getName().equals(string6)) continue;
            this.currentUIManager = uIManagerArray[i];
            break;
        }
        if (this.currentUIManager == null) {
            this.currentUIManager = UIFactory.getUIManagerFromResource(this.getClass(), "/ui/default.xml");
        }
        this.currentUIManager.create();
        this.companyName = string3;
        this.sponsorName = string5;
        this.poweredByView = bl;
        if (string3 == null || string3.trim().length() == 0) {
            this.companyName = "TopCoder";
        }
        if (string5 == null || string5.trim().length() == 0) {
            this.sponsorName = string3;
        }
        if (string3.equalsIgnoreCase("Sun")) {
            this.companyName = "Sun";
        }
        this.model = this.createModel();
        this.roomManager = new RoomManager(this, this.companyName);
        this.activeRoundsMenu = new ActiveRoundsMenu("Active Contests", 120, 14, 'a', this);
        this.mainFrame = new MainFrame(this);
        this.currentFrame = this.mainFrame;
        this.interFrame = new MessageFrame("", this.mainFrame, this);
        this.menuPanel = this.mainFrame.getMenuPanel();
        this.rtf = new RegistrantsTableFrame(this, 0);
        this.hsrtf = new RegistrantsTableFrame(this, 1);
        this.mmrtf = new RegistrantsTableFrame(this, 2);
        this.imf = new ImportantMessageSummaryFrame(this);
        this.psrf = new PracticeSystestResultsFrame(this);
        this.vpf = new VisitedPracticeFrame(this);
        this.autf = new ActiveUsersTableFrame(this);
        this.tmfm = new TeamManagerFrame(this, 1);
        this.tmfc = new TeamManagerFrame(this, 2);
        ConnectionType.registerAuthenticator(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(AuthenticatorDialog.getUsername(), AuthenticatorDialog.getPassword());
            }
        });
        if (!string4.equals("")) {
            System.out.println("This is my destination:" + string4);
            this.model.setGoThroughProxy(true);
        }
        this.model.init(string, n, string2, this, this.autf, this.rtf, this.hsrtf, this.mmrtf, this.tmfm.getTeamListView(), this.tmfm.getAvailableListView(), this.tmfm.getMemberListView(), this.menuPanel, this.roomManager, new EventService(){

            public void invokeLater(Runnable runnable) {
                EventQueue.invokeLater(runnable);
            }
        }, string4);
        this.model.getRoundViewManager().addListener(this.activeRoundsMenu);
        this.model.getBroadcastManager().addBroadcastListener(this.mainBroadcastListener, false);
        this.roomManager.loadInitRoom();
    }

    public ContestApplet(String string, int n, String string2, String string3, JApplet jApplet, String string4, boolean bl, String string5) {
        this(string, n, string2, string3, string4, bl, string5);
        this.launchApplet = jApplet;
    }

    public AppletContext getAppletContext() {
        AppletContext appletContext = null;
        if (this.launchApplet != null) {
            appletContext = this.launchApplet.getAppletContext();
        }
        return appletContext;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void mainFrameEvent() {
        if (!this.connected) {
            return;
        }
        if (!this.roomManager.leave()) {
            return;
        }
        this.mainFrame.hide();
        this.model.logoff();
    }

    public void loggingOff() {
        this.leave();
        this.roomManager.loadRoom(0, 2);
    }

    private void leave() {
        this.mainFrame.leave();
        Enumeration enumeration = new Vector(this.roomHash.values()).elements();
        while (enumeration.hasMoreElements()) {
            RoomInfoFrame roomInfoFrame = (RoomInfoFrame)enumeration.nextElement();
            roomInfoFrame.hide();
            roomInfoFrame.dispose();
        }
    }

    public void setCurrentFrame(JFrame jFrame) {
        this.currentFrame = jFrame;
    }

    public JFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public void setDisableScrollingChat(boolean bl) {
        this.disableChatScrolling = bl;
    }

    public boolean isScrollingChatDisabled() {
        return this.disableChatScrolling;
    }

    public boolean isEnterExitMsgsDisabled() {
        return this.disableEnterExitMsgs;
    }

    public void setDisableEnterExitMsgs(boolean bl) {
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        localPreferences.setProperty("com.topcoder.jmaContestApplet.ContestApplet.disableEnterExitMsgs", bl ? "true" : "false");
        try {
            localPreferences.savePreferences();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.disableEnterExitMsgs = bl;
    }

    public boolean isAutoEnhancedChatDisabled() {
        return this.disableAutoEnhancedChat;
    }

    public void setdisableAutoEnhancedChat(boolean bl) {
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        localPreferences.setProperty("com.topcoder.jmaContestApplet.ContestApplet.disableAutoEnhancedChat", bl ? "true" : "false");
        try {
            localPreferences.savePreferences();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.disableAutoEnhancedChat = bl;
    }

    public boolean isChatFindTabsDisabled() {
        return this.disableChatFindTabs;
    }

    public void setDisableChatFindTabs(boolean bl) {
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        localPreferences.setProperty("com.topcoder.jmaContestApplet.ContestApplet.disableChatFindTabs", bl ? "true" : "false");
        this.disableChatFindTabs = bl;
        try {
            localPreferences.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isChatHistoryDisabled() {
        return this.disableChatHistory;
    }

    public void setDisableChatHistory(boolean bl) {
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        localPreferences.setProperty("com.topcoder.jmaContestApplet.ContestApplet.disableChatHistory", bl ? "true" : "false");
        try {
            localPreferences.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disableChatHistory = bl;
    }

    public MessageFrame getInterFrame() {
        return this.interFrame;
    }

    public boolean isChatEnabled() {
        return this.menuPanel.isChatEnabled();
    }

    private void showCodePopup() {
        String string;
        RoomModule roomModule = this.roomManager.getCurrentRoom();
        if (roomModule instanceof CoderRoom && ((CoderRoom)roomModule).getCodingFrame().isShowing() && !(string = ((CoderRoom)roomModule).getCodingFrame().getCode()).equals("")) {
            MessageDialog messageDialog = new MessageDialog(this, this.mainFrame, "Please copy your working code into a local editor", string);
            messageDialog.show();
        }
    }

    public void reconnectFailedEvent() {
        this.showCodePopup();
        this.disconnectPopUp();
        this.connected = false;
    }

    public void closingConnectionEvent() {
    }

    private void disconnectPopUp() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    Common.showMessage("Client Connection Error", "The connection to the server has been lost. Logging off.", ContestApplet.this.mainFrame);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.leave();
        this.roomManager.loadRoom(0, 2);
    }

    public void setConnectionStatus(boolean bl) {
        this.connected = bl;
        RoomModule roomModule = this.roomManager.getCurrentRoom();
        roomModule.setConnectionStatus(bl);
        this.mainFrame.setMenuEnabled(bl);
        RoomListFrame.getInstance(this).setPanelEnabled(bl);
        BroadcastSummaryFrame.getInstance(this).setPanelEnabled(bl);
        if (this.autf != null) {
            this.autf.setPanelEnabled(bl);
        }
        if (this.rtf != null) {
            this.rtf.setPanelEnabled(bl);
        }
        if (this.hsrtf != null) {
            this.hsrtf.setPanelEnabled(bl);
        }
        RoomModel[] roomModelArray = this.model.getRooms();
        for (int i = 0; i < roomModelArray.length; ++i) {
            if (roomModelArray[i].getWatchView() == null || !(roomModelArray[i].getWatchView() instanceof RoomInfoFrame)) continue;
            ((RoomInfoFrame)roomModelArray[i].getWatchView()).setPanelEnabled(bl);
        }
        if (this.activeRoundsMenu != null) {
            this.activeRoundsMenu.setPanelEnabled(bl);
        }
    }

    public void lostConnectionEvent() {
        this.setConnectionStatus(false);
        this.getModel().startReconnectAttempt();
    }

    public Requester getRequester() {
        return this.model.getRequester();
    }

    public Contestant getModel() {
        return this.model;
    }

    public void requestCoderInfo(String string, int n) {
        this.getInterFrame().showMessage("Fetching coder info...", this.getCurrentFrame(), 42);
        this.model.getRequester().requestCoderInfo(string, n);
    }

    public void requestCoderHistory(String string, long l, int n) {
        this.getInterFrame().showMessage("Fetching coder history...", this.getCurrentFrame(), 37);
        this.model.getRequester().requestCoderHistory(string, l, n);
    }

    public void requestSubmissionHistory(String string, long l, int n, boolean bl) {
        this.getInterFrame().showMessage("Fetching submission history...", this.getCurrentFrame(), 37);
        this.model.getRequester().requestSubmissionHistory(string, l, n, bl);
    }

    public void popup(final int n, final int n2, final String string, final String string2, final ArrayList arrayList, final Object object) {
        this.interFrame.hideMessage();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n2 == 0) {
                    if (n == 1) {
                        MessageDialog messageDialog = new MessageDialog(ContestApplet.this, ContestApplet.this.getCurrentFrame(), string, string2, true, true);
                        messageDialog.setButtonText((String)arrayList.get(0));
                        messageDialog.setButton2Text((String)arrayList.get(1));
                        boolean bl = messageDialog.showDialog();
                        if (bl) {
                            ContestApplet.this.roomManager.loadRoom((Integer)((ArrayList)object).get(0), ((Integer)((ArrayList)object).get(1)).intValue(), 2);
                        }
                        ContestApplet.this.model.getRequester().requestPopupGeneric(n, bl ? 0 : 1, null);
                    } else if (n == 0) {
                        MessageDialog messageDialog = new MessageDialog(ContestApplet.this, ContestApplet.this.getCurrentFrame(), string, string2, true, true);
                        messageDialog.setButtonText((String)arrayList.get(0));
                        messageDialog.setButton2Text((String)arrayList.get(1));
                        boolean bl = messageDialog.showDialog();
                        Long l = (Long)object;
                        if (bl) {
                            ContestApplet.this.model.getRequester().requestRegister(l, new ArrayList());
                        }
                    } else if (n == 4) {
                        SurveyDialog surveyDialog = new SurveyDialog(ContestApplet.this, ContestApplet.this.getMainFrame(), string, string2, (String)arrayList.get(3), (ArrayList)arrayList.get(2));
                        surveyDialog.setButtonText((String)arrayList.get(0));
                        surveyDialog.setButton2Text((String)arrayList.get(1));
                        ArrayList arrayList2 = surveyDialog.showDialog();
                        boolean bl = (Boolean)arrayList2.remove(0);
                        Long l = (Long)object;
                        if (bl) {
                            ContestApplet.this.model.getRequester().requestRegister(l, arrayList2);
                        }
                    } else if (n == 5) {
                        Long l = (Long)arrayList.get(0);
                        boolean bl = (Boolean)arrayList.get(1);
                        Common.showMessage(string, string2, ContestApplet.this.getCurrentFrame());
                        if (!ContestApplet.this.companyName.toLowerCase().startsWith("Sun".toLowerCase())) {
                            bl = false;
                        }
                        if (ContestApplet.this.companyName.toLowerCase().equals("sunonsitefinals")) {
                            bl = false;
                        }
                        if (bl) {
                            ContestApplet.this.getInterFrame().showMessage("System Testing...", ContestApplet.this.getCurrentFrame(), 14);
                            ContestApplet.this.model.getRequester().requestSunAutoCompile(l.intValue());
                        }
                    }
                } else if (n2 == 1) {
                    boolean bl = Common.confirm(string, string2, ContestApplet.this.getCurrentFrame());
                    if (bl && n == 1) {
                        ContestApplet.this.roomManager.loadRoom((Integer)((ArrayList)object).get(0), ((Integer)((ArrayList)object).get(1)).intValue(), 2);
                        return;
                    }
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    if (object instanceof Integer) {
                        arrayList3.add(object);
                    }
                    ContestApplet.this.model.getRequester().requestPopupGeneric(n, bl ? 0 : 1, arrayList3);
                }
            }
        });
    }

    public void popup(final int n, final String string, final String string2) {
        this.interFrame.hideMessage();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n == 0) {
                    MessageDialog messageDialog = new MessageDialog(ContestApplet.this, ContestApplet.this.getCurrentFrame(), string, string2);
                    messageDialog.show();
                } else if (n == 1) {
                    if (string2.length() > 300) {
                        MessageDialog messageDialog = new MessageDialog(ContestApplet.this, ContestApplet.this.getCurrentFrame(), string, string2);
                        messageDialog.show();
                    } else {
                        Common.showMessage(string, string2, ContestApplet.this.getCurrentFrame());
                    }
                } else if (n == 2) {
                    MessageDialog messageDialog = new MessageDialog(ContestApplet.this, ContestApplet.this.getCurrentFrame(), string, string2, false, true);
                    messageDialog.show();
                }
            }
        });
    }

    public RoomManager getRoomManager() {
        return this.roomManager;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public boolean getPoweredByView() {
        return this.poweredByView;
    }

    public void vote(VoteResponse voteResponse) {
        VotingFrame.showFrame(this, voteResponse);
    }

    public void sendVoteBack(int n, String string) {
        this.getRequester().requestVote(n, string);
    }

    public void voteResults(VoteResultsResponse voteResultsResponse) {
        VotingResultsFrame.showFrame(this, voteResultsResponse);
    }

    public void disposeVotingFrame() {
        VotingFrame.disposeVotingFrame();
    }

    public void disposeTieBreakVotingFrame() {
        VotingFrame.disposeTieBreakVotingFrame();
    }

    public void sendRoundStatsRequest(int n, String string) {
        this.getRequester().requestRoundStats(n, string);
    }

    public void roundStatsResponse(RoundStatsResponse roundStatsResponse) {
        int n = roundStatsResponse.getRoundId();
        String string = roundStatsResponse.getCoderName();
        Coder coder = this.findCoder(n, string);
        RoundStatsFrame.showFrame(this, roundStatsResponse, coder, n);
    }

    public Coder findCoder(int n, String string) {
        Coder coder = null;
        RoomModel roomModel = this.findRoom(n, string);
        if (roomModel != null) {
            coder = roomModel.getCoder(string);
        }
        if (coder == null) {
            throw new IllegalStateException();
        }
        return coder;
    }

    public RoomModel findRoom(int n, String string) {
        RoomModel roomModel = null;
        Contestant contestant = this.getModel();
        RoundModel[] roundModelArray = contestant.getActiveRounds();
        block0: for (int i = 0; i < roundModelArray.length; ++i) {
            RoundModel roundModel = roundModelArray[i];
            if (n != roundModel.getRoundID().intValue()) continue;
            RoomModel[] roomModelArray = roundModel.getCoderRooms();
            for (int j = 0; j < roomModelArray.length; ++j) {
                RoomModel roomModel2 = roomModelArray[j];
                if (roomModel2.getCoder(string) == null) continue;
                roomModel = roomModel2;
                break block0;
            }
            break;
        }
        if (roomModel == null) {
            throw new IllegalStateException();
        }
        return roomModel;
    }

    public void viewCodeRequest(String string, long l, int n) {
        RoomModel roomModel = this.findRoom(n, string);
        long l2 = roomModel.getRoomID();
        this.getRequester().requestChallengeComponent(l, false, l2, string);
    }

    public void noBadgeId(NoBadgeIdResponse noBadgeIdResponse) {
        BadgeIdDialog.showDialog(this, noBadgeIdResponse);
    }

    public void loginWithBadgeId(String string, String string2, String string3) throws LoginException {
        this.model.loginWithBadgeId(string, string2, string3);
        if (this.model.isLoggedIn()) {
            this.getRoomManager().loadRoom(3, -1L, 1);
        }
    }

    public void wlMyTeamInfoResponse(WLMyTeamInfoResponse wLMyTeamInfoResponse) {
        WLMyTeamInfoFrame.showFrame(this.getCurrentFrame(), wLMyTeamInfoResponse);
    }

    public void wlTeamsInfoResponse(WLTeamsInfoResponse wLTeamsInfoResponse) {
        WLTeamsInfoFrame.showFrame(this.getCurrentFrame(), wLTeamsInfoResponse);
    }

    public void showImportantMessages() {
        for (int i = 0; i < this.messages.size(); ++i) {
            ImportantMessageResponse importantMessageResponse = (ImportantMessageResponse)this.messages.get(i);
            ImportantMessageDialog importantMessageDialog = new ImportantMessageDialog(this, importantMessageResponse.getText());
            importantMessageDialog.showDialog();
            this.getRequester().requestReadMessage(importantMessageResponse.getId());
        }
        this.messages.clear();
    }

    public void importantMessage(ImportantMessageResponse importantMessageResponse) {
        this.messages.add(importantMessageResponse);
    }

    public void importantMessageSummry(GetImportantMessagesResponse getImportantMessagesResponse) {
        this.imf.update(getImportantMessagesResponse);
        this.imf.showFrame();
    }

    public void visitedPracticeList(CreateVisitedPracticeResponse createVisitedPracticeResponse) {
        this.vpf.update(createVisitedPracticeResponse);
        this.vpf.showFrame();
    }

    public void startPracticeSystest(PracticeSystemTestResponse practiceSystemTestResponse) {
        this.psrf.reset(practiceSystemTestResponse);
        this.psrf.showFrame();
    }

    public void practiceSystestResult(PracticeSystemTestResultResponse practiceSystemTestResultResponse) {
        this.psrf.update(practiceSystemTestResultResponse);
    }

    public void showSubmissionHistory(SubmissionHistoryResponse submissionHistoryResponse) {
        this.interFrame.hideMessage();
        SubmissionHistoryFrame submissionHistoryFrame = new SubmissionHistoryFrame(this, submissionHistoryResponse);
        submissionHistoryFrame.setVisible(true);
    }

    public void showLongTestResults(LongTestResultsResponse longTestResultsResponse) {
        this.interFrame.hideMessage();
        LongTestResultsFrame longTestResultsFrame = new LongTestResultsFrame(this, longTestResultsResponse);
        longTestResultsFrame.setVisible(true);
    }

    public void showProblemStatement(ProblemModel problemModel) {
        if (this.problemStatementViewer == null) {
            this.problemStatementViewer = new StatementViewer(this);
        }
        this.problemStatementViewer.setProblemStatement(problemModel);
        this.problemStatementViewer.setVisible(true);
    }

    public void showCoderHistory(CoderHistoryResponse coderHistoryResponse) {
        this.interFrame.hideMessage();
        CoderHistoryFrame coderHistoryFrame = new CoderHistoryFrame(this, coderHistoryResponse);
        coderHistoryFrame.showFrame();
    }

    public void loadPlugins() {
        final PluginManager pluginManager = PluginManager.getInstance();
        EditorPlugin[] editorPluginArray = pluginManager.getEditorPlugins();
        for (int i = editorPluginArray.length - 1; i >= 0; --i) {
            if (!editorPluginArray[i].getEager()) continue;
            final EditorPlugin editorPlugin = editorPluginArray[i];
            try {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            DynamicEditor dynamicEditor = pluginManager.getEditor(editorPlugin);
                            pluginManager.disposeEditor(dynamicEditor);
                        }
                        catch (Exception exception) {
                            System.err.println("Error with: " + editorPlugin.getName());
                            exception.printStackTrace();
                        }
                    }
                });
                thread.start();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

