/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter.rules;

import com.topcoder.util.syntaxhighlighter.ContentSegment;
import com.topcoder.util.syntaxhighlighter.HighlightedSequence;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import com.topcoder.util.syntaxhighlighter.rules.RuleHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WordMatchRule
implements Rule {
    private static final String WORD_NODE_NAME = "word";
    private static final String WORDLIST_NODE_NAME = "wordlist";
    private final Set wordList = new HashSet();

    public WordMatchRule(Node node) {
        RuleHelper.checkNull(node, "node");
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("node is not a element.");
        }
        String[] stringArray = RuleHelper.getNodeText(RuleHelper.getSingleChildElementByName((Element)node, WORDLIST_NODE_NAME)).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.checkAndAddWord(stringArray[i])) continue;
            throw new IllegalArgumentException(stringArray[i] + " is not a valid word.");
        }
        NodeList nodeList = ((Element)node).getElementsByTagName(WORD_NODE_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getParentNode() != node) {
                throw new IllegalArgumentException("some word nodes are not the wordMatchRule's children.");
            }
            if (this.checkAndAddWord(RuleHelper.getNodeText(node2))) continue;
            throw new IllegalArgumentException(RuleHelper.getNodeText(node2) + " is not a valid word.");
        }
    }

    public WordMatchRule(String[] stringArray) {
        RuleHelper.checkNull(stringArray, "wordList");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Parameter 'wordList' must contain element(s).");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new IllegalArgumentException("null value in list is illegal.");
            }
            if (this.checkAndAddWord(stringArray[i])) continue;
            throw new IllegalArgumentException(stringArray[i] + " is not a valid word.");
        }
    }

    public void applyRule(HighlightedSequence highlightedSequence, TextStyle textStyle) {
        RuleHelper.checkNull(highlightedSequence, "sequence");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        highlightedSequence.reset();
        ContentSegment contentSegment = highlightedSequence.getNextToken();
        while (contentSegment != null) {
            if (this.wordList.contains(contentSegment.getContent())) {
                arrayList.add(new Integer(contentSegment.getStart()));
                arrayList2.add(new Integer(contentSegment.getEnd()));
            }
            contentSegment = highlightedSequence.getNextToken();
        }
        highlightedSequence.highlight(arrayList, arrayList2, textStyle);
    }

    public Rule.Point getToken(HighlightedSequence highlightedSequence) {
        RuleHelper.checkNull(highlightedSequence, "sequence");
        ContentSegment contentSegment = highlightedSequence.getNextToken();
        while (contentSegment != null) {
            if (this.wordList.contains(contentSegment.getContent())) {
                return new Rule.Point(contentSegment.getStart(), contentSegment.getEnd());
            }
            contentSegment = highlightedSequence.getNextToken();
        }
        return null;
    }

    private boolean checkAndAddWord(String string) {
        if (this.isValidWord(string = string.trim())) {
            this.wordList.add(string);
            return true;
        }
        return false;
    }

    private boolean isValidWord(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

