/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter.rules;

import com.topcoder.util.syntaxhighlighter.HighlightedSequence;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import com.topcoder.util.syntaxhighlighter.rules.RuleHelper;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BlockMatchRule
implements Rule {
    private static final String START_DELIMITER_NODE_NAME = "startDelimiter";
    private static final String END_DELIMITER_NODE_NAME = "endDelimiter";
    private final String startDelimiter;
    private final String endDelimiter;

    public BlockMatchRule(Node node) {
        RuleHelper.checkNull(node, "node");
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("node is not a element.");
        }
        this.startDelimiter = RuleHelper.getNodeTextWithoutTrimEmptyCheck(RuleHelper.getSingleChildElementByName((Element)node, START_DELIMITER_NODE_NAME));
        this.endDelimiter = RuleHelper.getNodeTextWithoutTrimEmptyCheck(RuleHelper.getSingleChildElementByName((Element)node, END_DELIMITER_NODE_NAME));
    }

    public BlockMatchRule(String string, String string2) {
        RuleHelper.checkNullEmptyParam(string, START_DELIMITER_NODE_NAME);
        RuleHelper.checkNullEmptyParam(string2, END_DELIMITER_NODE_NAME);
        this.startDelimiter = string;
        this.endDelimiter = string2;
    }

    public void applyRule(HighlightedSequence highlightedSequence, TextStyle textStyle) {
        RuleHelper.checkNull(highlightedSequence, "sequence");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n = highlightedSequence.indexOf(this.startDelimiter);
        while (n >= 0) {
            int n2 = highlightedSequence.indexOf(this.endDelimiter, n + this.startDelimiter.length());
            n2 = n2 < 0 ? highlightedSequence.length() : (n2 += this.endDelimiter.length());
            arrayList.add(new Integer(n));
            arrayList2.add(new Integer(n2));
            n = highlightedSequence.indexOf(this.startDelimiter, n2);
        }
        highlightedSequence.highlight(arrayList, arrayList2, textStyle);
    }

    public Rule.Point getToken(HighlightedSequence highlightedSequence) {
        int n = highlightedSequence.indexOf(this.startDelimiter);
        if (n >= 0) {
            int n2 = highlightedSequence.indexOf(this.endDelimiter, n + this.startDelimiter.length());
            n2 = n2 < 0 ? highlightedSequence.length() : (n2 += this.endDelimiter.length());
            return new Rule.Point(n, n2);
        }
        return null;
    }
}

