/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.log.Log;
import com.topcoder.util.syntaxhighlighter.Category;
import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.ContentSegment;
import com.topcoder.util.syntaxhighlighter.HighlightedOutput;
import com.topcoder.util.syntaxhighlighter.HighlightedSequence;
import com.topcoder.util.syntaxhighlighter.HighlightingException;
import com.topcoder.util.syntaxhighlighter.Language;
import com.topcoder.util.syntaxhighlighter.LoggingErrorHandler;
import com.topcoder.util.syntaxhighlighter.RuleMatchException;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SyntaxHighlighter {
    public static final String DEFAULT_NAMESPACE = "com.topcoder.util.syntaxhighlighter";
    private static final String PROPERTY_NAME = "language_files";
    private final List languages;

    public SyntaxHighlighter() throws ConfigurationException {
        this(DEFAULT_NAMESPACE, null);
    }

    public SyntaxHighlighter(String string) throws ConfigurationException {
        this(string, null);
    }

    public SyntaxHighlighter(String string, Log log) throws ConfigurationException {
        block7: {
            this.languages = new ArrayList();
            SHHelper.checkString(string, "namespace");
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                ConfigManager configManager = ConfigManager.getInstance();
                String[] stringArray = configManager.getStringArray(string, PROPERTY_NAME);
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        documentBuilder.setErrorHandler(new LoggingErrorHandler(log));
                        InputStream inputStream = this.getClass().getResourceAsStream("/" + stringArray[i]);
                        Document document = documentBuilder.parse(inputStream);
                        Language language = new Language(document);
                        this.languages.add(language);
                    }
                    break block7;
                }
                throw new ConfigurationException("Language files must be specified.");
            }
            catch (UnknownNamespaceException unknownNamespaceException) {
                throw new ConfigurationException("Namespace cannot be found.");
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new ConfigurationException("There are some errors in parser configuration.");
            }
            catch (SAXException sAXException) {
                throw new ConfigurationException("There are errors in the configuration files.");
            }
            catch (IOException iOException) {
                throw new ConfigurationException("There are errors in reading the configuration files.");
            }
        }
    }

    public SyntaxHighlighter(Log log) throws ConfigurationException {
        this(DEFAULT_NAMESPACE, log);
    }

    public Language[] getLanguages() {
        return this.languages.toArray(new Language[this.languages.size()]);
    }

    public void highlightText(String string, String string2, HighlightedOutput highlightedOutput) throws RuleMatchException, HighlightingException {
        Category[] categoryArray;
        SHHelper.checkNull(string, "text");
        if (string.length() == 0) {
            throw new IllegalArgumentException("'text' may not be empty.");
        }
        SHHelper.checkString(string2, "languageName");
        SHHelper.checkNull(highlightedOutput, "outputPlugin");
        Category[] categoryArray2 = null;
        Object object = this.languages.iterator();
        while (object.hasNext()) {
            categoryArray = (Category[])object.next();
            if (!categoryArray.getName().equals(string2)) continue;
            categoryArray2 = categoryArray;
            break;
        }
        if (categoryArray2 == null) {
            throw new IllegalArgumentException("Language " + string2 + " was not found.");
        }
        object = new HighlightedSequence(string);
        categoryArray = categoryArray2.getCategories();
        int n = 0;
        block1: while (n < categoryArray.length) {
            Rule[] ruleArray;
            int n2 = categoryArray[n].getPrecedence();
            ArrayList<Rule> arrayList = new ArrayList<Rule>();
            ArrayList<TextStyle> arrayList2 = new ArrayList<TextStyle>();
            while (n < categoryArray.length && n2 == categoryArray[n].getPrecedence()) {
                ruleArray = categoryArray[n].getRules();
                for (int i = 0; i < ruleArray.length; ++i) {
                    arrayList.add(ruleArray[i]);
                    arrayList2.add(categoryArray[n].getStyle());
                }
                ++n;
            }
            ruleArray = arrayList.toArray(new Rule[arrayList.size()]);
            TextStyle[] textStyleArray = arrayList2.toArray(new TextStyle[arrayList2.size()]);
            Rule.Point[] pointArray = new Rule.Point[ruleArray.length];
            boolean[] blArray = new boolean[ruleArray.length];
            block4: while (true) {
                int n3;
                Rule.Point point = null;
                TextStyle textStyle = null;
                for (n3 = 0; n3 < ruleArray.length; ++n3) {
                    if (blArray[n3]) continue;
                    Rule.Point point2 = pointArray[n3];
                    if (point2 == null) {
                        point2 = ruleArray[n3].getToken((HighlightedSequence)object);
                        if (point2 == null) {
                            blArray[n3] = true;
                            continue;
                        }
                        pointArray[n3] = point2;
                    }
                    if (point != null && point.getStart() <= point2.getStart()) continue;
                    point = point2;
                    textStyle = textStyleArray[n3];
                }
                if (point == null) continue block1;
                ((HighlightedSequence)object).highlight(point.getStart(), point.getEnd(), textStyle);
                n3 = point.getEnd() - point.getStart();
                int n4 = 0;
                while (true) {
                    if (n4 >= ruleArray.length) continue block4;
                    if (!blArray[n4]) {
                        Rule.Point point3 = pointArray[n4];
                        pointArray[n4] = point3.getStart() < point.getEnd() ? null : new Rule.Point(point3.getStart() - n3, point3.getEnd() - n3);
                    }
                    ++n4;
                }
                break;
            }
        }
        ContentSegment[] contentSegmentArray = ((HighlightedSequence)object).getOrderedSegments();
        highlightedOutput.setText(contentSegmentArray);
    }
}

