/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.syntaxhighlighter.ContentSegment;
import com.topcoder.util.syntaxhighlighter.HighlightedOutput;
import com.topcoder.util.syntaxhighlighter.HighlightingException;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import com.topcoder.util.syntaxhighlighter.Segment;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class StatefulJTextPaneOutput
implements HighlightedOutput {
    private final JTextPane textPane;
    private String paneContent = "";
    private String paneLanguage = "";
    private List previousSegments = new ArrayList();
    private int curSegment = -1;
    private boolean isCurHighlighted = false;
    private boolean update = true;

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public StatefulJTextPaneOutput(JTextPane jTextPane) {
        SHHelper.checkNull(jTextPane, "textPane");
        this.textPane = jTextPane;
    }

    private boolean isInFastMode() {
        return this.curSegment > -1 && !this.previousSegments.isEmpty();
    }

    public void setText(ContentSegment[] contentSegmentArray) throws HighlightingException {
        int n;
        SHHelper.checkNull(contentSegmentArray, "contentSegments");
        if (contentSegmentArray.length == 0) {
            throw new IllegalArgumentException("contentSegments should not contain no elements.");
        }
        try {
            Arrays.sort(contentSegmentArray);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Some elements of contentSegments are of wrong type.");
        }
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        int n2 = styledDocument.getLength();
        int n3 = 0;
        if (this.isInFastMode()) {
            n3 = ((ContentSegment)this.previousSegments.get(this.curSegment)).getStart();
        }
        for (n = 0; n < contentSegmentArray.length; ++n) {
            if (contentSegmentArray[n] == null) {
                throw new IllegalArgumentException("Some elements of contentSegments are null or illegal.");
            }
            if (contentSegmentArray[n].getStart() + n3 + contentSegmentArray[n].getContent().length() <= n2) continue;
            throw new HighlightingException("A referenced segment is outside the bounds of the document. The document should not be changed while highlighting occurs.");
        }
        for (n = 0; n < contentSegmentArray.length && this.update; ++n) {
            ContentSegment contentSegment = contentSegmentArray[n];
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            TextStyle textStyle = contentSegment.getStyle();
            if (textStyle != null) {
                if (textStyle.getBGColor() != null) {
                    StyleConstants.setBackground(simpleAttributeSet, textStyle.getBGColor());
                }
                if (textStyle.getFont() != null) {
                    Font font = textStyle.getFont();
                    StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
                    StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
                    StyleConstants.setBold(simpleAttributeSet, font.isBold());
                    StyleConstants.setItalic(simpleAttributeSet, font.isItalic());
                }
                if (textStyle.getColor() != null) {
                    StyleConstants.setForeground(simpleAttributeSet, textStyle.getColor());
                }
            }
            styledDocument.setCharacterAttributes(contentSegment.getStart() + n3, contentSegment.getContent().length(), simpleAttributeSet, true);
        }
        this.isCurHighlighted = true;
        this.createFastSegments(contentSegmentArray, n3);
    }

    private void createFastSegments(ContentSegment[] contentSegmentArray, int n) {
        if (!this.isInFastMode()) {
            this.previousSegments.clear();
            this.previousSegments.addAll(Arrays.asList(contentSegmentArray));
        } else {
            this.previousSegments.subList(this.curSegment, this.previousSegments.size()).clear();
            for (int i = 0; i < contentSegmentArray.length; ++i) {
                ContentSegment contentSegment = contentSegmentArray[i];
                this.previousSegments.add(new ContentSegment(contentSegment.getStart() + n, contentSegment.getEnd() + n, contentSegment.getStyle(), contentSegment.getContent()));
            }
        }
    }

    public void resetState() {
        this.curSegment = -1;
        this.previousSegments.clear();
        this.isCurHighlighted = false;
    }

    public String getHighlightString(int n) throws BadLocationException {
        return this.getHighlightString(n, 0, 0, 0, 0);
    }

    public String getHighlightString(int n, int n2, int n3, int n4) throws BadLocationException {
        return this.getHighlightString(n, n2, n3, n4, 0);
    }

    public String getHighlightString(int n, int n2, int n3, int n4, int n5) throws BadLocationException {
        Object object;
        int n6;
        if (n < 0) {
            throw new IllegalArgumentException("position should be greater than or equal to zero.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("remove should be greater than or equal to zero.");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("insert should be greater than or equal to zero.");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("lines should be greater than or equal to zero.");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("columns should be greater than or equal to zero.");
        }
        if (!this.isCurHighlighted) {
            this.resetState();
        }
        this.curSegment = 0;
        if (this.previousSegments.isEmpty()) {
            return this.textPane.getDocument().getText(0, this.textPane.getDocument().getLength());
        }
        for (n6 = 1; n6 < this.previousSegments.size() && ((Segment)(object = (ContentSegment)this.previousSegments.get(n6))).getStart() < n; ++n6) {
            if (((Segment)object).getStyle() == null) continue;
            this.curSegment = n6 - 1;
        }
        n6 = ((ContentSegment)this.previousSegments.get(this.curSegment)).getStart();
        object = this.textPane.getDocument().getText(n6, this.textPane.getDocument().getLength() - n6);
        if (n4 == 0) {
            return object;
        }
        int n7 = n + n3;
        int n8 = 0;
        int n9 = ((ContentSegment)this.previousSegments.get(this.previousSegments.size() - 1)).getEnd() + 1 + n3 - n2;
        if (n3 == 0 && n2 == 0 && n6 + ((String)object).length() <= n9) {
            return null;
        }
        int n10 = n4;
        while (n7 - n6 < ((String)object).length()) {
            char c = ((String)object).charAt(n7 - n6);
            if (c == '\n') {
                --n10;
                n8 = 0;
            } else if (n5 > 0 && Character.isJavaIdentifierPart(c) && ++n8 > n5) {
                --n10;
                n8 -= n5;
            }
            if (n10 <= 0) {
                if (n3 == 0 && n2 == 0 && n7 <= n9) {
                    return null;
                }
                if (n10 <= -n4) break;
            }
            ++n7;
        }
        return ((String)object).substring(0, Math.min(n7 - n6, ((String)object).length()));
    }

    public boolean needsUpdate(String string, String string2) {
        SHHelper.checkString(string, "text");
        SHHelper.checkString(string2, "language");
        if (this.curSegment > -1) {
            return true;
        }
        if (this.paneContent.equals(string) && this.paneLanguage.equals(string2)) {
            return false;
        }
        this.paneContent = string;
        this.paneLanguage = string2;
        return true;
    }

    public JTextPane getJTextPane() {
        return this.textPane;
    }
}

