/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

final class SHHelper {
    private SHHelper() {
    }

    public static void checkNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The parameter '" + string + "' should not be null.");
        }
    }

    public static String getNodeText(Node node) throws ConfigurationException {
        if (node == null) {
            throw new ConfigurationException("Null node is illegal.");
        }
        if (node.getNodeType() != 1) {
            throw new ConfigurationException("The node must be an element node.");
        }
        String string = node.getNodeName();
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            String string2 = node.getNodeValue();
            if (string2 == null || string2.trim().length() == 0) {
                throw new ConfigurationException("Value of property '" + string + "' is illegal.");
            }
            return string2;
        }
        throw new ConfigurationException("Text node can't be found.");
    }

    public static int getNodeInteger(Node node) throws ConfigurationException {
        if (node == null) {
            throw new ConfigurationException("Null node is illegal.");
        }
        if (node.getNodeType() != 1) {
            throw new ConfigurationException("The node must be an element node.");
        }
        String string = node.getNodeName();
        String string2 = SHHelper.getNodeText(node);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Parse integer error in property '" + string + "'.");
        }
    }

    public static void checkString(String string, String string2) {
        SHHelper.checkNull(string, string2);
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("The parameter '" + string2 + "' should not be an empty string.");
        }
    }

    public static void checkNegative(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter '" + string + "' should not be negative.");
        }
    }

    public static void checkList(List list, String string, Class clazz) {
        SHHelper.checkNull(list, string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) {
                throw new IllegalArgumentException("The " + string + " contains a null element.");
            }
            if (clazz.isInstance(e)) continue;
            throw new IllegalArgumentException("The " + string + " contains an element not implementing " + clazz.getName() + ".");
        }
    }

    public static void checkConfigString(String string, String string2) throws ConfigurationException {
        if (string == null) {
            throw new ConfigurationException("The property '" + string2 + "' is missing.");
        }
        if (string.trim().length() == 0) {
            throw new ConfigurationException("Value of the property '" + string2 + "' should not be an empty string(trimed).");
        }
    }

    public static void checkStartEnd(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Paramenter 'start' with negative value is illegal.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Paramenter 'end' with negative value is illegal.");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Parameter 'start' larger than 'end' was illegal.");
        }
    }
}

