/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.log.Level;
import com.topcoder.util.log.Log;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

class LoggingErrorHandler
implements ErrorHandler {
    private Log log;

    public LoggingErrorHandler(Log log) {
        this.log = log;
    }

    public void warning(SAXParseException sAXParseException) {
        LoggingErrorHandler.LogException(this.log, Level.WARN, sAXParseException);
    }

    public void error(SAXParseException sAXParseException) {
        LoggingErrorHandler.LogException(this.log, Level.ERROR, sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        LoggingErrorHandler.LogException(this.log, Level.FATAL, sAXParseException);
    }

    private static void LogException(Log log, Level level, SAXParseException sAXParseException) {
        SHHelper.checkNull(sAXParseException, "exception");
        if (log != null) {
            log.log(level, (Object)("Line: " + sAXParseException.getLineNumber() + " Column: " + sAXParseException.getColumnNumber() + " Message: " + sAXParseException.getMessage()));
        }
    }
}

