/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.syntaxhighlighter.ContentSegment;
import com.topcoder.util.syntaxhighlighter.HighlightedOutput;
import com.topcoder.util.syntaxhighlighter.HighlightingException;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.Font;
import java.util.Arrays;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class JTextPaneOutput
implements HighlightedOutput {
    private final JTextPane textPane;

    public JTextPaneOutput() {
        this.textPane = new JTextPane();
    }

    public JTextPaneOutput(JTextPane jTextPane) {
        SHHelper.checkNull(jTextPane, "textPane");
        this.textPane = jTextPane;
    }

    public void setText(ContentSegment[] contentSegmentArray) throws HighlightingException {
        SHHelper.checkNull(contentSegmentArray, "contentSegments");
        if (contentSegmentArray.length == 0) {
            throw new IllegalArgumentException("contentSegments should not contain no elements.");
        }
        try {
            Arrays.sort(contentSegmentArray);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Some elements of contentSegments are of wrong type.");
        }
        Document document = this.textPane.getDocument();
        try {
            document.remove(0, document.getLength());
            for (int i = 0; i < contentSegmentArray.length; ++i) {
                if (contentSegmentArray[i] == null) {
                    throw new IllegalArgumentException("Some elements of contentSegments are null or illegal.");
                }
                ContentSegment contentSegment = contentSegmentArray[i];
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                TextStyle textStyle = contentSegment.getStyle();
                if (textStyle != null) {
                    if (textStyle.getBGColor() != null) {
                        StyleConstants.setBackground(simpleAttributeSet, textStyle.getBGColor());
                    }
                    if (textStyle.getFont() != null) {
                        Font font = textStyle.getFont();
                        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
                        StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
                        StyleConstants.setBold(simpleAttributeSet, font.isBold());
                        StyleConstants.setItalic(simpleAttributeSet, font.isItalic());
                    }
                    if (textStyle.getColor() != null) {
                        StyleConstants.setForeground(simpleAttributeSet, textStyle.getColor());
                    }
                }
                document.insertString(contentSegment.getStart(), contentSegment.getContent(), simpleAttributeSet);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new HighlightingException("contentSegments have bad location segments.");
        }
    }

    public JTextPane getJTextPane() {
        return this.textPane;
    }
}

