/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.impl.xml.swing;

import com.topcoder.client.ui.UIManager;
import com.topcoder.client.ui.UIManagerConfigurationException;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.UIPropertyValueParser;
import com.topcoder.client.ui.impl.XMLUIManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSwingDefaults {
    private static final String SWING_CONFIG_XML = "swing.xml";

    private XMLSwingDefaults() {
    }

    public static void set(UIManager uIManager) throws UIManagerConfigurationException {
        Object object;
        Object object2;
        URL uRL;
        XMLUIManager xMLUIManager = (XMLUIManager)uIManager;
        URL uRL2 = xMLUIManager.getXMLConfig();
        try {
            uRL = new URL(uRL2, SWING_CONFIG_XML);
        }
        catch (MalformedURLException malformedURLException) {
            object2 = uRL2.toExternalForm();
            object = ((String)object2).substring(0, ((String)object2).lastIndexOf(47) + 1) + SWING_CONFIG_XML;
            try {
                uRL = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new UIManagerConfigurationException("The URL '" + (String)object + "' is malformed.", malformedURLException2);
            }
        }
        ClassLoader classLoader = xMLUIManager.getClassLoader();
        javax.swing.UIManager.getDefaults().put("ClassLoader", classLoader);
        object2 = Locale.getDefault();
        Locale.setDefault(Locale.US);
        object = null;
        try {
            object = uRL.openStream();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(new SwingDefaultsHandler(classLoader, xMLUIManager.getCurrentPage()));
            xMLReader.parse(new InputSource((InputStream)object));
        }
        catch (IOException iOException) {
            throw new UIManagerConfigurationException("The configuration file cannot be read.", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UIManagerConfigurationException("The SAX parser cannot be created.", parserConfigurationException);
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
            throw new UIManagerConfigurationException("The Swing defaults XML configuration is invalid at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ".", sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new UIManagerConfigurationException("The Swing defaults XML configuration is invalid.", sAXException);
        }
        finally {
            Locale.setDefault((Locale)object2);
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class SwingDefaultsHandler
    extends DefaultHandler {
        private ClassLoader loader;
        private Locator locator;
        private boolean valid;
        private UIPage currentPage;

        public SwingDefaultsHandler(ClassLoader classLoader, UIPage uIPage) {
            this.loader = classLoader;
            this.valid = false;
            this.currentPage = uIPage;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("swing".equals(string2)) {
                if (this.valid) {
                    throw new SAXParseException("Swing element must be the root.", this.locator);
                }
                this.valid = true;
            } else if ("property".equals(string2)) {
                if (!this.valid) {
                    throw new SAXParseException("Property element must be under the swing element.", this.locator);
                }
                String string4 = attributes.getValue("name");
                String string5 = attributes.getValue("value");
                String string6 = attributes.getValue("parser");
                if (string4 == null || string5 == null) {
                    throw new SAXParseException("Name and value must exist for property.", this.locator);
                }
                if ("swing.defaultlaf".equals(string4)) {
                    try {
                        javax.swing.UIManager.setLookAndFeel(string5);
                    }
                    catch (Exception exception) {
                        throw new SAXParseException("The look and feel is not supported.", this.locator, exception);
                    }
                } else if ("metal.theme".equals(string4)) {
                    try {
                        MetalLookAndFeel.setCurrentTheme((MetalTheme)Class.forName(string5, true, this.loader).newInstance());
                    }
                    catch (Exception exception) {
                        throw new SAXParseException("The metal theme is not supported.", this.locator, exception);
                    }
                } else if (string6 == null) {
                    javax.swing.UIManager.getDefaults().put(string4, string5);
                } else {
                    try {
                        UIPropertyValueParser uIPropertyValueParser = (UIPropertyValueParser)Class.forName(string6, true, this.loader).newInstance();
                        Object object = uIPropertyValueParser.parse(this.currentPage, string5, this.loader);
                        if (object instanceof Font) {
                            object = new FontUIResource((Font)object);
                        } else if (object instanceof Color) {
                            object = new ColorUIResource((Color)object);
                        } else if (object instanceof Icon) {
                            object = new IconUIResource((Icon)object);
                        } else if (object instanceof Border) {
                            object = new BorderUIResource((Border)object);
                        } else if (object instanceof Insets) {
                            Insets insets = (Insets)object;
                            object = new InsetsUIResource(insets.top, insets.left, insets.bottom, insets.right);
                        } else if (object instanceof Dimension) {
                            Dimension dimension = (Dimension)object;
                            object = new DimensionUIResource(dimension.width, dimension.height);
                        }
                        javax.swing.UIManager.getDefaults().put(string4, object);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXParseException("The parser is not an UIPropertyValueParser.", this.locator, classCastException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new SAXParseException("The parser does not have a default constructor.", this.locator, instantiationException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SAXParseException("The parser class cannot be loaded.", this.locator, classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SAXParseException("The default constructor of the parser class is not public.", this.locator, illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SAXParseException("The property value is invalid for the parser.", this.locator, illegalArgumentException);
                    }
                }
            } else {
                throw new SAXParseException("Unknown element '" + string2 + "'.", this.locator);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("swing".equals(string2)) {
                this.valid = false;
            }
        }
    }
}

