/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.impl.component;

import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIComponentException;
import com.topcoder.client.ui.UIEventListener;
import com.topcoder.client.ui.event.UIChangeListener;
import com.topcoder.client.ui.impl.component.UISwingComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.plaf.ViewportUI;

public class UIViewport
extends UISwingComponent {
    private JViewport component;

    protected Object createComponent() {
        return new JViewport();
    }

    protected void initialize() throws UIComponentException {
        super.initialize();
        this.component = (JViewport)this.getEventSource();
    }

    protected void addChildImpl(UIComponent uIComponent, GridBagConstraints gridBagConstraints) throws UIComponentException {
        if (!(uIComponent.getEventSource() instanceof Component)) {
            throw new UIComponentException("This container does not support " + uIComponent.getClass() + ".");
        }
        this.component.setView((Component)uIComponent.getEventSource());
    }

    protected void setPropertyImpl(String string, Object object) throws UIComponentException {
        if ("ExtentSize".equalsIgnoreCase(string)) {
            this.component.setExtentSize((Dimension)object);
        } else if ("ScrollMode".equalsIgnoreCase(string)) {
            this.component.setScrollMode(((Number)object).intValue());
        } else if ("UI".equalsIgnoreCase(string)) {
            this.component.setUI((ViewportUI)object);
        } else if ("View".equalsIgnoreCase(string)) {
            this.component.setView((Component)object);
        } else if ("ViewPosition".equalsIgnoreCase(string)) {
            this.component.setViewPosition((Point)object);
        } else if ("ViewSize".equalsIgnoreCase(string)) {
            this.component.setViewSize((Dimension)object);
        } else {
            super.setPropertyImpl(string, object);
        }
    }

    protected Object getPropertyImpl(String string) throws UIComponentException {
        if ("ExtentSize".equalsIgnoreCase(string)) {
            return this.component.getExtentSize();
        }
        if ("ScrollMode".equalsIgnoreCase(string)) {
            return new Integer(this.component.getScrollMode());
        }
        if ("View".equalsIgnoreCase(string)) {
            return this.component.getView();
        }
        if ("ViewPosition".equalsIgnoreCase(string)) {
            return this.component.getViewPosition();
        }
        if ("ViewRect".equalsIgnoreCase(string)) {
            return this.component.getViewRect();
        }
        if ("ViewSize".equalsIgnoreCase(string)) {
            return this.component.getViewSize();
        }
        return super.getPropertyImpl(string);
    }

    protected void addEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        if ("change".equalsIgnoreCase(string)) {
            this.component.addChangeListener((UIChangeListener)uIEventListener);
        } else {
            super.addEventListenerImpl(string, uIEventListener);
        }
    }

    protected void removeEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        if ("change".equalsIgnoreCase(string)) {
            this.component.removeChangeListener((UIChangeListener)uIEventListener);
        } else {
            super.removeEventListenerImpl(string, uIEventListener);
        }
    }

    protected Object performActionImpl(String string, Object[] objectArray) throws UIComponentException {
        if ("scrollRectToVisible".equalsIgnoreCase(string)) {
            this.assertArgs(string, objectArray, new Class[]{Rectangle.class});
            this.component.scrollRectToVisible((Rectangle)objectArray[0]);
            return null;
        }
        if ("toViewCoordinates".equalsIgnoreCase(string)) {
            if (objectArray.length == 1 && objectArray[0] instanceof Dimension) {
                return this.component.toViewCoordinates((Dimension)objectArray[0]);
            }
            this.assertArgs(string, objectArray, new Class[]{Point.class});
            return this.component.toViewCoordinates((Point)objectArray[0]);
        }
        return super.performActionImpl(string, objectArray);
    }
}

