/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.impl.component;

import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIComponentException;
import com.topcoder.client.ui.UIEventListener;
import com.topcoder.client.ui.event.UICaretListener;
import com.topcoder.client.ui.impl.component.UISwingComponent;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.plaf.TextUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;

public abstract class UITextComponent
extends UISwingComponent {
    private JTextComponent component;

    protected void initialize() throws UIComponentException {
        super.initialize();
        this.component = (JTextComponent)this.getEventSource();
    }

    protected void addChildImpl(UIComponent uIComponent, GridBagConstraints gridBagConstraints) throws UIComponentException {
        throw new UIComponentException("Text component is not a container.");
    }

    protected void setPropertyImpl(String string, Object object) throws UIComponentException {
        if ("caret".equalsIgnoreCase(string)) {
            this.component.setCaret((Caret)object);
        } else if ("caretcolor".equalsIgnoreCase(string)) {
            this.component.setCaretColor((Color)object);
        } else if ("caretposition".equalsIgnoreCase(string)) {
            this.component.setCaretPosition(((Number)object).intValue());
        } else if ("disabledtextcolor".equalsIgnoreCase(string)) {
            this.component.setDisabledTextColor((Color)object);
        } else if ("document".equalsIgnoreCase(string)) {
            this.component.setDocument((Document)object);
        } else if ("dragenabled".equalsIgnoreCase(string)) {
            this.component.setDragEnabled((Boolean)object);
        } else if ("editable".equalsIgnoreCase(string)) {
            this.component.setEditable((Boolean)object);
        } else if ("focusaccelerator".equalsIgnoreCase(string)) {
            this.component.setFocusAccelerator(((Character)object).charValue());
        } else if ("highlighter".equalsIgnoreCase(string)) {
            this.component.setHighlighter((Highlighter)object);
        } else if ("keymap".equalsIgnoreCase(string)) {
            this.component.setKeymap((Keymap)object);
        } else if ("margin".equalsIgnoreCase(string)) {
            this.component.setMargin((Insets)object);
        } else if ("navigationfilter".equalsIgnoreCase(string)) {
            this.component.setNavigationFilter((NavigationFilter)object);
        } else if ("selectedtextcolor".equalsIgnoreCase(string)) {
            this.component.setSelectedTextColor((Color)object);
        } else if ("selectioncolor".equalsIgnoreCase(string)) {
            this.component.setSelectionColor((Color)object);
        } else if ("selectionend".equalsIgnoreCase(string)) {
            this.component.setSelectionEnd(((Number)object).intValue());
        } else if ("selectionstart".equalsIgnoreCase(string)) {
            this.component.setSelectionStart(((Number)object).intValue());
        } else if ("text".equalsIgnoreCase(string)) {
            this.component.setText((String)object);
        } else if ("ui".equalsIgnoreCase(string)) {
            this.component.setUI((TextUI)object);
        } else {
            super.setPropertyImpl(string, object);
        }
    }

    protected Object getPropertyImpl(String string) throws UIComponentException {
        if ("actions".equalsIgnoreCase(string)) {
            return this.component.getActions();
        }
        if ("caret".equalsIgnoreCase(string)) {
            return this.component.getCaret();
        }
        if ("caretcolor".equalsIgnoreCase(string)) {
            return this.component.getCaretColor();
        }
        if ("caretposition".equalsIgnoreCase(string)) {
            return new Integer(this.component.getCaretPosition());
        }
        if ("disabledtextcolor".equalsIgnoreCase(string)) {
            return this.component.getDisabledTextColor();
        }
        if ("document".equalsIgnoreCase(string)) {
            return this.component.getDocument();
        }
        if ("dragenabled".equalsIgnoreCase(string)) {
            return this.component.getDragEnabled();
        }
        if ("focusaccelerator".equalsIgnoreCase(string)) {
            return Character.valueOf(this.component.getFocusAccelerator());
        }
        if ("highlighter".equalsIgnoreCase(string)) {
            return this.component.getHighlighter();
        }
        if ("keymap".equalsIgnoreCase(string)) {
            return this.component.getKeymap();
        }
        if ("margin".equalsIgnoreCase(string)) {
            return this.component.getMargin();
        }
        if ("navigationfilter".equalsIgnoreCase(string)) {
            return this.component.getNavigationFilter();
        }
        if ("selectedtext".equalsIgnoreCase(string)) {
            return this.component.getSelectedText();
        }
        if ("selectedtextcolor".equalsIgnoreCase(string)) {
            return this.component.getSelectedTextColor();
        }
        if ("selectioncolor".equalsIgnoreCase(string)) {
            return this.component.getSelectionColor();
        }
        if ("selectionstart".equalsIgnoreCase(string)) {
            return new Integer(this.component.getSelectionStart());
        }
        if ("selectionend".equalsIgnoreCase(string)) {
            return new Integer(this.component.getSelectionEnd());
        }
        if ("text".equalsIgnoreCase(string)) {
            return this.component.getText();
        }
        if ("ui".equalsIgnoreCase(string)) {
            return this.component.getUI();
        }
        if ("editable".equalsIgnoreCase(string)) {
            return this.component.isEditable();
        }
        return super.getPropertyImpl(string);
    }

    protected void addEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        if ("caret".equalsIgnoreCase(string)) {
            this.component.addCaretListener((UICaretListener)uIEventListener);
        } else {
            super.addEventListenerImpl(string, uIEventListener);
        }
    }

    protected void removeEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        if ("caret".equalsIgnoreCase(string)) {
            this.component.removeCaretListener((UICaretListener)uIEventListener);
        } else {
            super.removeEventListenerImpl(string, uIEventListener);
        }
    }

    protected Object performActionImpl(String string, Object[] objectArray) throws UIComponentException {
        if ("copy".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.copy();
            return null;
        }
        if ("cut".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.cut();
            return null;
        }
        if ("paste".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.paste();
            return null;
        }
        if ("selectall".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.selectAll();
            return null;
        }
        if ("movecaretposition".equalsIgnoreCase(string)) {
            this.assertArgs(string, objectArray, new Class[]{Number.class});
            this.component.moveCaretPosition(((Number)objectArray[0]).intValue());
            return null;
        }
        if ("read".equalsIgnoreCase(string)) {
            this.assertArgs(string, objectArray, new Class[]{Reader.class, Object.class});
            try {
                this.component.read((Reader)objectArray[0], objectArray[1]);
            }
            catch (IOException iOException) {
                throw new UIComponentException("I/O error occured.", iOException);
            }
            return null;
        }
        if ("replaceselection".equalsIgnoreCase(string)) {
            this.assertArgs(string, objectArray, new Class[]{String.class});
            this.component.replaceSelection((String)objectArray[0]);
            return null;
        }
        if ("select".equalsIgnoreCase(string)) {
            this.assertArgs(string, objectArray, new Class[]{Number.class, Number.class});
            this.component.select(((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue());
            return null;
        }
        if ("viewtomodel".equalsIgnoreCase(string)) {
            this.assertArgs(string, objectArray, new Class[]{Point.class});
            return new Integer(this.component.viewToModel((Point)objectArray[0]));
        }
        if ("write".equalsIgnoreCase(string)) {
            this.assertArgs(string, objectArray, new Class[]{Writer.class});
            try {
                this.component.write((Writer)objectArray[0]);
            }
            catch (IOException iOException) {
                throw new UIComponentException("I/O error occured.", iOException);
            }
            return null;
        }
        return super.performActionImpl(string, objectArray);
    }
}

