/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.impl;

import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIComponentException;
import com.topcoder.client.ui.UIManager;
import com.topcoder.client.ui.UIManagerConfigurationException;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.UIPageException;
import com.topcoder.client.ui.UIPageNotFoundException;
import com.topcoder.client.ui.UIPropertyValueParser;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUIManager
implements UIManager {
    private static final String SCHEME_ELEMENT = "scheme";
    private static final String PAGE_ELEMENT = "page";
    private static final String COMPONENT_ELEMENT = "component";
    private static final String CONSTRAINTS_ELEMENT = "constraints";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String ACTION_ELEMENT = "action";
    private static final String PARAM_ELEMENT = "param";
    private static final String COMPONENTREF_ELEMENT = "componentref";
    private static final String CALL_ELEMENT = "call";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String VALUE_ATTR = "value";
    private static final String VALUE_PARSER_ATTR = "parser";
    private static final String CLASSPATH_ATTR = "classpath";
    private static final String CLASS_NAME_ATTR = "class";
    private static final String METHOD_NAME_ATTR = "method";
    private static final String CONSTRAINTS_GRIDX_ATTR = "gridx";
    private static final String CONSTRAINTS_GRIDY_ATTR = "gridy";
    private static final String CONSTRAINTS_GRIDWIDTH_ATTR = "gridwidth";
    private static final String CONSTRAINTS_GRIDHEIGHT_ATTR = "gridheight";
    private static final String CONSTRAINTS_ANCHOR_ATTR = "anchor";
    private static final String CONSTRAINTS_FILL_ATTR = "fill";
    private static final String CONSTRAINTS_IPADX_ATTR = "ipadx";
    private static final String CONSTRAINTS_IPADY_ATTR = "ipady";
    private static final String CONSTRAINTS_INSETS_ATTR = "insets";
    private static final String CONSTRAINTS_WEIGHTX_ATTR = "weightx";
    private static final String CONSTRAINTS_WEIGHTY_ATTR = "weighty";
    private Map pages = new HashMap();
    private String name;
    private String description;
    private URL xmlConfig;
    private ClassLoader loader = null;
    private UIPage currentPage;
    static /* synthetic */ Class class$java$awt$GridBagConstraints;
    static /* synthetic */ Class class$com$topcoder$client$ui$UIManager;

    public XMLUIManager(URL uRL) throws UIManagerConfigurationException {
        this.xmlConfig = uRL;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){

                private String getMandatoryAttribute(Attributes attributes, String string) throws SAXException {
                    String string2 = attributes.getValue(string);
                    if (string2 == null) {
                        throw new SAXException("Attribute " + string + " must exist.");
                    }
                    return string2;
                }

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    if (XMLUIManager.SCHEME_ELEMENT.equals(string2)) {
                        XMLUIManager.this.name = this.getMandatoryAttribute(attributes, XMLUIManager.NAME_ATTR);
                        XMLUIManager.this.description = this.getMandatoryAttribute(attributes, XMLUIManager.DESCRIPTION_ATTR);
                    }
                }
            });
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            throw new UIManagerConfigurationException("The configuration file cannot be read.", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UIManagerConfigurationException("The SAX parser cannot be created.", parserConfigurationException);
        }
        catch (SAXParseException sAXParseException) {
            throw new UIManagerConfigurationException("The XML configuration for this UI is invalid at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ".", sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new UIManagerConfigurationException("The XML configuration for this UI is invalid.", sAXException);
        }
        finally {
            Locale.setDefault(locale);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void create() throws UIManagerConfigurationException {
        this.create(null);
    }

    public URL getXMLConfig() {
        return this.xmlConfig;
    }

    public UIPage getCurrentPage() {
        return this.currentPage;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private void create(String string) throws UIManagerConfigurationException {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        InputStream inputStream = null;
        try {
            inputStream = this.xmlConfig.openStream();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            ConfigurationContentHandler configurationContentHandler = new ConfigurationContentHandler(this.xmlConfig, string);
            xMLReader.setContentHandler(configurationContentHandler);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            throw new UIManagerConfigurationException("The configuration file cannot be read.", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UIManagerConfigurationException("The SAX parser cannot be created.", parserConfigurationException);
        }
        catch (SAXParseException sAXParseException) {
            throw new UIManagerConfigurationException("The XML configuration for this UI is invalid at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ".", sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new UIManagerConfigurationException("The XML configuration for this UI is invalid.", sAXException);
        }
        finally {
            Locale.setDefault(locale);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void destroy() {
        Iterator iterator = this.pages.values().iterator();
        while (iterator.hasNext()) {
            UIPage uIPage = (UIPage)iterator.next();
            uIPage.destroy();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public UIPage getUIPage(String string) throws UIPageNotFoundException {
        return this.getUIPage(string, false);
    }

    public UIPage getUIPage(String string, boolean bl) throws UIPageNotFoundException {
        UIPage uIPage = (UIPage)this.pages.get(string);
        if (uIPage == null) {
            throw new UIPageNotFoundException("The UI page " + string + " is not available.");
        }
        if (bl) {
            try {
                this.create(string);
            }
            catch (UIManagerConfigurationException uIManagerConfigurationException) {
                throw new UIPageNotFoundException("The UI page cannot be re-created.", uIManagerConfigurationException);
            }
            uIPage.destroy();
            uIPage = (UIPage)this.pages.get(string);
        }
        return uIPage;
    }

    private class ConfigurationContentHandler
    implements ContentHandler {
        private Stack elements = new Stack();
        private Stack constraints = new Stack();
        private URL dir;
        private String pageName;
        private boolean skipping = false;
        private Locator locator = null;

        private String getMandatoryAttribute(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                throw new SAXParseException("Attribute " + string + " must exist.", this.locator);
            }
            return string2;
        }

        private int parseConstraintsConstants(String string) {
            try {
                return (class$java$awt$GridBagConstraints == null ? (class$java$awt$GridBagConstraints = XMLUIManager.class$("java.awt.GridBagConstraints")) : class$java$awt$GridBagConstraints).getField(string.toUpperCase()).getInt(null);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("The value is not a valid GridBagConstraints constant.");
            }
        }

        private Insets parseIntsets(String string) {
            String[] stringArray = string.split(",");
            if (stringArray.length != 4) {
                throw new IllegalArgumentException("The value is not a valid inset value.");
            }
            return new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        }

        private ConfigurationContentHandler(URL uRL, String string) {
            this.dir = uRL;
            this.pageName = string;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (XMLUIManager.COMPONENT_ELEMENT.equals(string2) && !this.skipping) {
                UIComponent uIComponent = (UIComponent)this.elements.pop();
                GridBagConstraints gridBagConstraints = (GridBagConstraints)this.constraints.pop();
                Object e = this.elements.peek();
                if (e instanceof UIComponent) {
                    try {
                        ((UIComponent)e).addChild(uIComponent, gridBagConstraints);
                    }
                    catch (UIComponentException uIComponentException) {
                        throw new SAXParseException("The parent component cannot have child.", this.locator, uIComponentException);
                    }
                }
            } else if (XMLUIManager.ACTION_ELEMENT.equals(string2) && !this.skipping) {
                PerformAction performAction = (PerformAction)this.elements.pop();
                UIComponent uIComponent = (UIComponent)this.elements.peek();
                try {
                    uIComponent.performAction(performAction.name, performAction.params.toArray());
                }
                catch (UIComponentException uIComponentException) {
                    throw new SAXParseException("Performing action failed.", this.locator, uIComponentException);
                }
            } else if (!this.skipping) {
                this.elements.pop();
            } else if (XMLUIManager.PAGE_ELEMENT.equals(string2)) {
                this.skipping = false;
            }
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void startDocument() throws SAXException {
            if (this.pageName == null) {
                XMLUIManager.this.pages.clear();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XMLUIManager.SCHEME_ELEMENT.equals(string2)) {
                if (!this.elements.isEmpty()) {
                    throw new SAXParseException("scheme element must be the root.", this.locator);
                }
                XMLUIManager.this.name = this.getMandatoryAttribute(attributes, XMLUIManager.NAME_ATTR);
                XMLUIManager.this.description = this.getMandatoryAttribute(attributes, XMLUIManager.DESCRIPTION_ATTR);
                if (XMLUIManager.this.loader == null) {
                    URL[] uRLArray;
                    String[] stringArray;
                    String string4 = attributes.getValue(XMLUIManager.CLASSPATH_ATTR);
                    String[] stringArray2 = stringArray = string4 != null ? string4.split(";") : new String[]{};
                    if (this.dir.getProtocol().equalsIgnoreCase("jar")) {
                        uRLArray = new URL[stringArray.length + 1];
                        try {
                            uRLArray[stringArray.length] = ((JarURLConnection)this.dir.openConnection()).getJarFileURL();
                        }
                        catch (IOException iOException) {
                            throw new SAXParseException("The jar file is invalid.", this.locator, iOException);
                        }
                    } else {
                        uRLArray = new URL[stringArray.length];
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            uRLArray[i] = new URL(this.dir, stringArray[i]);
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new SAXParseException("The classpath is invalid.", this.locator, malformedURLException);
                        }
                    }
                    if (uRLArray.length == 0) {
                        XMLUIManager.this.loader = this.getClass().getClassLoader();
                    } else {
                        XMLUIManager.this.loader = URLClassLoader.newInstance(uRLArray, this.getClass().getClassLoader());
                    }
                }
                this.elements.push(string2);
                return;
            }
            if (XMLUIManager.CALL_ELEMENT.equals(string2)) {
                if (this.skipping) return;
                try {
                    String string5 = this.getMandatoryAttribute(attributes, XMLUIManager.CLASS_NAME_ATTR);
                    String string6 = this.getMandatoryAttribute(attributes, XMLUIManager.METHOD_NAME_ATTR);
                    Class.forName(string5, true, XMLUIManager.this.loader).getMethod(string6, class$com$topcoder$client$ui$UIManager == null ? (class$com$topcoder$client$ui$UIManager = XMLUIManager.class$("com.topcoder.client.ui.UIManager")) : class$com$topcoder$client$ui$UIManager).invoke(null, XMLUIManager.this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SAXParseException("The invocation class cannot be loaded.", this.locator, classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new SAXParseException("The invocation method cannot be found.", this.locator, noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXParseException("The invocation method cannot be accessed.", this.locator, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new SAXParseException("The invocation method causes an error.", this.locator, (Exception)invocationTargetException.getTargetException());
                }
                this.elements.push(string2);
                return;
            }
            if (XMLUIManager.PAGE_ELEMENT.equals(string2)) {
                if (this.elements.size() != 1) {
                    throw new SAXParseException("Page can only be defined under scheme.", this.locator);
                }
                this.skipping = this.pageName != null && !this.pageName.equals(this.getMandatoryAttribute(attributes, XMLUIManager.NAME_ATTR));
                try {
                    if (this.skipping) return;
                    String string7 = this.getMandatoryAttribute(attributes, XMLUIManager.CLASS_NAME_ATTR);
                    UIPage uIPage = (UIPage)Class.forName(string7, true, XMLUIManager.this.loader).newInstance();
                    XMLUIManager.this.pages.put(this.getMandatoryAttribute(attributes, XMLUIManager.NAME_ATTR), uIPage);
                    this.elements.push(uIPage);
                    XMLUIManager.this.currentPage = uIPage;
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXParseException("The page is not an UIPage.", this.locator, classCastException);
                }
                catch (InstantiationException instantiationException) {
                    throw new SAXParseException("The page does not have a default constructor.", this.locator, instantiationException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SAXParseException("The page class cannot be loaded.", this.locator, classNotFoundException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXParseException("The default constructor of the page class is not public.", this.locator, illegalAccessException);
                }
            }
            if (XMLUIManager.COMPONENTREF_ELEMENT.equals(string2)) {
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIPage)) {
                    throw new SAXParseException("Component reference can be only used under page.", this.locator);
                }
                try {
                    this.elements.push(XMLUIManager.this.currentPage.getComponent(this.getMandatoryAttribute(attributes, XMLUIManager.NAME_ATTR)));
                    return;
                }
                catch (UIPageException uIPageException) {
                    throw new SAXParseException("The component reference cannot be found in the page.", this.locator, uIPageException);
                }
            }
            if (XMLUIManager.COMPONENT_ELEMENT.equals(string2)) {
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIPage) && !(this.elements.peek() instanceof UIComponent)) {
                    throw new SAXParseException("Only page or component can be added with child components.", this.locator);
                }
                try {
                    UIComponent uIComponent = (UIComponent)Class.forName(this.getMandatoryAttribute(attributes, XMLUIManager.CLASS_NAME_ATTR), true, XMLUIManager.this.loader).newInstance();
                    this.constraints.push(new GridBagConstraints());
                    this.elements.push(uIComponent);
                    XMLUIManager.this.currentPage.addComponent(this.getMandatoryAttribute(attributes, XMLUIManager.NAME_ATTR), uIComponent);
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXParseException("The component is not an UIComponent.", this.locator, classCastException);
                }
                catch (InstantiationException instantiationException) {
                    throw new SAXParseException("The component does not have a default constructor.", this.locator, instantiationException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SAXParseException("The component class cannot be loaded.", this.locator, classNotFoundException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXParseException("The default constructor of the component class is not public.", this.locator, illegalAccessException);
                }
                catch (UIPageException uIPageException) {
                    throw new SAXParseException("Adding component to the page fails.", this.locator, uIPageException);
                }
            }
            if (XMLUIManager.CONSTRAINTS_ELEMENT.equals(string2)) {
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIComponent)) {
                    throw new SAXParseException("Only component can be set with constraints.", this.locator);
                }
                GridBagConstraints gridBagConstraints = (GridBagConstraints)this.constraints.peek();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string8 = attributes.getLocalName(i);
                    String string9 = attributes.getValue(i);
                    boolean bl = true;
                    int n = 0;
                    try {
                        n = this.parseConstraintsConstants(string9);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl = false;
                    }
                    try {
                        if (XMLUIManager.CONSTRAINTS_INSETS_ATTR.equals(string8)) {
                            gridBagConstraints.insets = this.parseIntsets(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_WEIGHTX_ATTR.equals(string8)) {
                            gridBagConstraints.weightx = Double.parseDouble(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_WEIGHTY_ATTR.equals(string8)) {
                            gridBagConstraints.weighty = Double.parseDouble(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_ANCHOR_ATTR.equals(string8)) {
                            gridBagConstraints.anchor = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_FILL_ATTR.equals(string8)) {
                            gridBagConstraints.fill = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_GRIDHEIGHT_ATTR.equals(string8)) {
                            gridBagConstraints.gridheight = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_GRIDWIDTH_ATTR.equals(string8)) {
                            gridBagConstraints.gridwidth = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_GRIDX_ATTR.equals(string8)) {
                            gridBagConstraints.gridx = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_GRIDY_ATTR.equals(string8)) {
                            gridBagConstraints.gridy = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if (XMLUIManager.CONSTRAINTS_IPADX_ATTR.equals(string8)) {
                            gridBagConstraints.ipadx = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if (!XMLUIManager.CONSTRAINTS_IPADY_ATTR.equals(string8)) throw new SAXParseException("Unknown constraints " + string8 + ".", this.locator);
                        gridBagConstraints.ipady = bl ? n : Integer.parseInt(string9);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SAXParseException("The value of the constraints is invalid.", this.locator, illegalArgumentException);
                    }
                }
                this.elements.push(string2);
                return;
            }
            if (XMLUIManager.PROPERTY_ELEMENT.equals(string2)) {
                Object object;
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIComponent)) {
                    throw new SAXParseException("Only component can be set with properties.", this.locator);
                }
                UIComponent uIComponent = (UIComponent)this.elements.peek();
                if (attributes.getValue(XMLUIManager.VALUE_PARSER_ATTR) != null) {
                    try {
                        UIPropertyValueParser uIPropertyValueParser = (UIPropertyValueParser)Class.forName(attributes.getValue(XMLUIManager.VALUE_PARSER_ATTR), true, XMLUIManager.this.loader).newInstance();
                        object = uIPropertyValueParser.parse(XMLUIManager.this.currentPage, this.getMandatoryAttribute(attributes, XMLUIManager.VALUE_ATTR), XMLUIManager.this.loader);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXParseException("The parser is not an UIPropertyValueParser.", this.locator, classCastException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new SAXParseException("The parser does not have a default constructor.", this.locator, instantiationException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SAXParseException("The parser class cannot be loaded.", this.locator, classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SAXParseException("The default constructor of the parser class is not public.", this.locator, illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SAXParseException("The property value is invalid for the parser.", this.locator, illegalArgumentException);
                    }
                    catch (Exception exception) {
                        throw new SAXParseException("Other error occurred when parsing the value.", this.locator, exception);
                    }
                } else {
                    object = this.getMandatoryAttribute(attributes, XMLUIManager.VALUE_ATTR);
                }
                try {
                    uIComponent.setProperty(this.getMandatoryAttribute(attributes, XMLUIManager.NAME_ATTR), object);
                }
                catch (UIComponentException uIComponentException) {
                    throw new SAXParseException("The property cannot be set.", this.locator, uIComponentException);
                }
                this.elements.push(string2);
                return;
            }
            if (XMLUIManager.ACTION_ELEMENT.equals(string2)) {
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIComponent)) {
                    throw new SAXParseException("Only components can perform actions.", this.locator);
                }
                PerformAction performAction = new PerformAction();
                performAction.name = this.getMandatoryAttribute(attributes, XMLUIManager.NAME_ATTR);
                this.elements.push(performAction);
                return;
            } else {
                Object object;
                if (!XMLUIManager.PARAM_ELEMENT.equals(string2)) throw new SAXParseException("Illegal element '" + string2 + "' in the configuration file.", this.locator);
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof PerformAction)) {
                    throw new SAXParseException("Only actions can have parameters.", this.locator);
                }
                PerformAction performAction = (PerformAction)this.elements.peek();
                if (attributes.getValue(XMLUIManager.VALUE_PARSER_ATTR) != null) {
                    try {
                        UIPropertyValueParser uIPropertyValueParser = (UIPropertyValueParser)Class.forName(attributes.getValue(XMLUIManager.VALUE_PARSER_ATTR), true, XMLUIManager.this.loader).newInstance();
                        object = uIPropertyValueParser.parse(XMLUIManager.this.currentPage, this.getMandatoryAttribute(attributes, XMLUIManager.VALUE_ATTR), XMLUIManager.this.loader);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXParseException("The parser is not an UIPropertyValueParser.", this.locator, classCastException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new SAXParseException("The parser does not have a default constructor.", this.locator, instantiationException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SAXParseException("The parser class cannot be loaded.", this.locator, classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SAXParseException("The default constructor of the parser class is not public.", this.locator, illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SAXParseException("The property value is invalid for the parser.", this.locator, illegalArgumentException);
                    }
                } else {
                    object = this.getMandatoryAttribute(attributes, XMLUIManager.VALUE_ATTR);
                }
                performAction.params.add(object);
                this.elements.push(string2);
            }
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        private class PerformAction {
            private String name;
            private List params = new ArrayList();

            private PerformAction() {
            }
        }
    }
}

