/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.impl.ProblemComponentModelImpl;
import com.topcoder.client.contestant.view.EventService;
import com.topcoder.shared.language.BaseLanguage;
import com.topcoder.shared.language.Language;
import java.util.LinkedList;
import java.util.List;

class CoderComponentImpl
implements CoderComponent {
    private EventService eventService;
    private ProblemComponentModelImpl component;
    private Integer points;
    private Integer status;
    private Integer language;
    private Integer passedSystemTests;
    private Coder coder;
    private String sourceCode;
    private final List listeners = new LinkedList();

    CoderComponentImpl() {
    }

    CoderComponentImpl(ProblemComponentModelImpl problemComponentModelImpl, int n, int n2, int n3, Coder coder, Integer n4, EventService eventService) {
        this.component = problemComponentModelImpl;
        this.points = new Integer(n2);
        this.status = new Integer(n3);
        this.coder = coder;
        this.eventService = eventService;
        this.language = new Integer(n);
        this.passedSystemTests = n4;
    }

    public ProblemComponentModel getComponent() {
        return this.component;
    }

    public synchronized Integer getPoints() {
        return this.points;
    }

    public synchronized Integer getStatus() {
        return this.status;
    }

    public synchronized Integer getLanguageID() {
        return this.language;
    }

    public Coder getCoder() {
        return this.coder;
    }

    synchronized void setPoints(Integer n) {
        this.points = n;
        this.notifyListeners();
    }

    public synchronized void setLanguage(Integer n) {
        this.language = n;
        this.notifyListeners();
    }

    synchronized void setStatus(Integer n) {
        this.status = n;
        this.notifyListeners();
    }

    public synchronized boolean hasSourceCode() {
        return this.getSourceCodeLanguage() != null && this.sourceCode != null;
    }

    public synchronized String getSourceCode() {
        return this.sourceCode;
    }

    synchronized void setSourceCode(int n, String string) {
        if (string != null && this.listeners.size() > 0 && string.length() > 0) {
            this.setSourceCodeLanguage(n);
            this.sourceCode = string;
            this.notifyListeners();
        } else {
            this.sourceCode = null;
        }
    }

    protected void setSourceCodeLanguage(int n) {
        this.language = new Integer(n);
    }

    public Language getSourceCodeLanguage() {
        return this.getLanguage();
    }

    public synchronized Language getLanguage() {
        if (this.language == null) {
            return null;
        }
        return BaseLanguage.getLanguage((int)this.language);
    }

    public synchronized void addListener(CoderComponent.Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(CoderComponent.Listener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.sourceCode = null;
        }
    }

    private synchronized void notifyListeners() {
        final CoderComponent.Listener[] listenerArray = this.cloneListeners();
        try {
            this.eventService.invokeLater(new Runnable(){

                public void run() {
                    for (int i = listenerArray.length - 1; i >= 0; --i) {
                        listenerArray[i].coderComponentEvent(CoderComponentImpl.this);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized CoderComponent.Listener[] cloneListeners() {
        return this.listeners.toArray(new CoderComponent.Listener[this.listeners.size()]);
    }

    public Integer getPassedSystemTests() {
        return this.passedSystemTests;
    }

    public void setPassedSystemTests(Integer n) {
        this.passedSystemTests = n;
    }
}

