/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant;

import com.topcoder.client.contestant.BroadcastListener;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.netCommon.contestantMessages.AdminBroadcast;
import com.topcoder.netCommon.contestantMessages.ComponentBroadcast;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BroadcastManager {
    private Contestant contestant;
    private Set broadcasts = new HashSet();
    private Set readBroadcasts = new HashSet();
    private ArrayList broadcastListeners = new ArrayList();

    public BroadcastManager(Contestant contestant) {
        this.contestant = contestant;
    }

    public synchronized void clearBroadcasts() {
        this.readBroadcasts.clear();
        this.broadcasts.clear();
    }

    public synchronized void newBroadcast(AdminBroadcast adminBroadcast) {
        if (this.checkBroadcastFilters(adminBroadcast)) {
            return;
        }
        this.broadcasts.add(adminBroadcast);
        this.fireNewBroadcastEvent(adminBroadcast);
    }

    private synchronized boolean checkBroadcastFilters(AdminBroadcast adminBroadcast) {
        if (this.contestant.getUserInfo().isAdmin()) {
            return false;
        }
        if (adminBroadcast instanceof ComponentBroadcast) {
            ComponentBroadcast componentBroadcast = (ComponentBroadcast)adminBroadcast;
            if (componentBroadcast.getDivision() == 1) {
                return this.contestant.getUserInfo().getRating() < 1200;
            }
            return this.contestant.getUserInfo().getRating() >= 1200;
        }
        return false;
    }

    public synchronized boolean hasRead(AdminBroadcast adminBroadcast) {
        return this.readBroadcasts.contains(adminBroadcast);
    }

    public synchronized void markBroadcastRead(AdminBroadcast adminBroadcast) {
        this.readBroadcasts.add(adminBroadcast);
        this.fireReadBroadcastEvent(adminBroadcast);
    }

    private synchronized void fireReadBroadcastEvent(AdminBroadcast adminBroadcast) {
        Iterator iterator = this.broadcastListeners.iterator();
        while (iterator.hasNext()) {
            ((BroadcastListener)iterator.next()).readBroadcast(adminBroadcast);
        }
    }

    public synchronized int getUnreadBroadcastCount() {
        return this.broadcasts.size() - this.readBroadcasts.size();
    }

    private synchronized void fireRefreshBroadcastsEvent() {
        Iterator iterator = this.broadcastListeners.iterator();
        while (iterator.hasNext()) {
            ((BroadcastListener)iterator.next()).refreshBroadcasts();
        }
    }

    private synchronized void fireNewBroadcastEvent(AdminBroadcast adminBroadcast) {
        Iterator iterator = this.broadcastListeners.iterator();
        while (iterator.hasNext()) {
            ((BroadcastListener)iterator.next()).newBroadcast(adminBroadcast);
        }
    }

    public synchronized void refresh(ArrayList arrayList) {
        this.broadcasts.clear();
        this.readBroadcasts.retainAll(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            AdminBroadcast adminBroadcast = (AdminBroadcast)arrayList.get(i);
            if (this.checkBroadcastFilters(adminBroadcast)) continue;
            this.broadcasts.add(adminBroadcast);
        }
        this.fireRefreshBroadcastsEvent();
    }

    public synchronized Collection getBroadcasts() {
        return new ArrayList(this.broadcasts);
    }

    public synchronized void addBroadcastListener(BroadcastListener broadcastListener, boolean bl) {
        this.cleanListeners();
        if (bl) {
            this.broadcastListeners.add(0, new WeakBroadcastListener(broadcastListener));
        } else {
            this.broadcastListeners.add(new WeakBroadcastListener(broadcastListener));
        }
    }

    public synchronized void removeBroadcastListener(BroadcastListener broadcastListener) {
        this.cleanListeners();
        this.broadcastListeners.remove(broadcastListener);
    }

    private void cleanListeners() {
        Iterator iterator = this.broadcastListeners.iterator();
        while (iterator.hasNext()) {
            WeakBroadcastListener weakBroadcastListener = (WeakBroadcastListener)iterator.next();
            if (weakBroadcastListener.isListening()) continue;
            iterator.remove();
        }
    }

    private static class WeakBroadcastListener
    implements BroadcastListener {
        private WeakReference ref;

        WeakBroadcastListener(BroadcastListener broadcastListener) {
            this.ref = new WeakReference<BroadcastListener>(broadcastListener);
        }

        public void newBroadcast(AdminBroadcast adminBroadcast) {
            BroadcastListener broadcastListener = (BroadcastListener)this.ref.get();
            if (broadcastListener != null) {
                broadcastListener.newBroadcast(adminBroadcast);
            }
        }

        public void readBroadcast(AdminBroadcast adminBroadcast) {
            BroadcastListener broadcastListener = (BroadcastListener)this.ref.get();
            if (broadcastListener != null) {
                broadcastListener.readBroadcast(adminBroadcast);
            }
        }

        public void refreshBroadcasts() {
            BroadcastListener broadcastListener = (BroadcastListener)this.ref.get();
            if (broadcastListener != null) {
                broadcastListener.refreshBroadcasts();
            }
        }

        public boolean isListening() {
            return this.ref.get() != null;
        }

        public boolean equals(Object object) {
            Object t = this.ref.get();
            if (object == null || t == null) {
                return false;
            }
            if (object instanceof WeakBroadcastListener) {
                return this == object;
            }
            return object.equals(t);
        }
    }
}

