/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LookupJLabelTextField
extends JTextField {
    private String unCommitted = "";
    private ComboBoxModel model;
    boolean appendEnding = true;
    private Color unCommittedColor = Color.gray;

    public LookupJLabelTextField(ComboBoxModel comboBoxModel, boolean bl) {
        this();
        this.model = comboBoxModel;
        this.appendEnding = bl;
    }

    public LookupJLabelTextField() {
        this.setDocument(new SpecialDocument());
        this.addKeyListener(new KeyHandler());
        this.addFocusListener(new FocusHandler());
        this.addCaretListener(new CaretHandler());
        this.addMouseListener(new MouseHandler());
        this.setRequestFocusEnabled(true);
    }

    public void removeCaretHandler() {
        CaretListener[] caretListenerArray = this.getCaretListeners();
        if (caretListenerArray != null) {
            for (int i = 0; i < caretListenerArray.length; ++i) {
                this.removeCaretListener(caretListenerArray[i]);
            }
        }
    }

    public void addCaretHandler() {
        CaretListener[] caretListenerArray = this.getCaretListeners();
        if (caretListenerArray == null || caretListenerArray.length == 0) {
            this.addCaretListener(new CaretHandler());
        }
    }

    public void setAppendEnding(boolean bl) {
        this.appendEnding = bl;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.model = comboBoxModel;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void setUnCommittedColor(Color color) {
        this.unCommittedColor = color;
    }

    protected void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            if (this.unCommitted.equals("") || this.getSelectionStart() != this.getSelectionEnd()) {
                return;
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Rectangle rectangle = this.modelToView(0);
            Rectangle rectangle2 = this.getBounds();
            if (rectangle == null || rectangle2 == null || fontMetrics == null) {
                return;
            }
            String string = this.getText();
            int[] nArray = this.getWordBoundry(string, this.getCaretPosition() - 1);
            if (nArray[0] == -1) {
                return;
            }
            String string2 = string.substring(0, nArray[1]);
            String string3 = string.substring(nArray[1]);
            int n = fontMetrics.stringWidth(string2);
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x + n + 1, rectangle.y, rectangle2.width, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(this.unCommittedColor);
            graphics.drawString(this.unCommitted, rectangle.x + n, rectangle.y + fontMetrics.getAscent());
            n += fontMetrics.stringWidth(this.unCommitted);
            if (nArray[0] == 0) {
                graphics.drawString(": ", rectangle.x + n, rectangle.y + fontMetrics.getAscent());
                n += fontMetrics.stringWidth(": ");
            }
            graphics.setColor(this.getForeground());
            graphics.drawString(string3, rectangle.x + n, rectangle.y + fontMetrics.getAscent());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private final int[] getWordBoundry(String string, int n) {
        if (n >= string.length()) {
            n = string.length() - 1;
        }
        if (n < 0 || string.charAt(n) == ' ') {
            return new int[]{-1, -1};
        }
        int[] nArray = new int[]{n, n};
        while (nArray[0] >= 0 && string.charAt(nArray[0]) != ' ') {
            nArray[0] = nArray[0] - 1;
        }
        nArray[0] = nArray[0] + 1;
        while (nArray[1] < string.length() && string.charAt(nArray[1]) != ' ') {
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] convertModelToString() {
        ComboBoxModel comboBoxModel = this.model;
        synchronized (comboBoxModel) {
            String[] stringArray = new String[this.model.getSize()];
            for (int i = this.model.getSize() - 1; i >= 0; --i) {
                stringArray[i] = ((JLabel)this.model.getElementAt(i)).getText();
            }
            return stringArray;
        }
    }

    private class SpecialDocument
    extends PlainDocument {
        private StringBuffer originalText = new StringBuffer(50);
        private StringBuffer temp = new StringBuffer(50);

        private SpecialDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            this.originalText.insert(n, string);
            this.update();
            LookupJLabelTextField.this.setCaretPosition(n + string.length());
        }

        public void remove(int n, int n2) throws BadLocationException {
            this.originalText.delete(n, n + n2);
            this.update();
            LookupJLabelTextField.this.setCaretPosition(n);
        }

        public void update() throws BadLocationException {
            this.temp.setLength(0);
            StringTokenizer stringTokenizer = new StringTokenizer(this.originalText.toString(), " :", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals(" ") || string.equals(":")) {
                    this.temp.append(string);
                    continue;
                }
                String[] stringArray = LookupJLabelTextField.this.convertModelToString();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!string.equalsIgnoreCase(stringArray[i])) continue;
                    string = stringArray[i];
                    break;
                }
                this.temp.append(string);
            }
            super.remove(0, this.getLength());
            super.insertString(0, this.temp.toString(), null);
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9 && !keyEvent.isShiftDown()) {
                this.useTab();
                keyEvent.consume();
            }
        }

        public boolean useTab() {
            String string = LookupJLabelTextField.this.getText();
            int[] nArray = LookupJLabelTextField.this.getWordBoundry(string, LookupJLabelTextField.this.getCaretPosition() - 1);
            if (nArray[0] == -1) {
                return false;
            }
            if (LookupJLabelTextField.this.unCommitted.equals("")) {
                LookupJLabelTextField.this.setCaretPosition(nArray[1]);
                return false;
            }
            String string2 = string.substring(nArray[0], nArray[1]);
            if (string2.trim().equals("")) {
                return false;
            }
            String string3 = string2.toLowerCase();
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = LookupJLabelTextField.this.convertModelToString();
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i].toLowerCase();
                if (!string4.startsWith(string3) || string4.equals(string3)) continue;
                char c = string4.charAt(string2.length());
                string3 = string3 + c;
                string2 = string2 + c;
                stringBuffer.append(c);
                String string5 = null;
                for (int j = i + 1; j < stringArray.length && stringArray[j].toLowerCase().startsWith(string3); ++j) {
                    string5 = stringArray[j];
                }
                if (string5 == null) {
                    stringBuffer.append(stringArray[i].substring(string3.length()));
                    stringBuffer.append(this.getEnding(string, nArray[0], nArray[1]));
                    break;
                }
                String string6 = string5.toLowerCase();
                for (int j = string2.length(); j < string4.length() && j < string6.length() && string4.charAt(j) == string6.charAt(j); ++j) {
                    stringBuffer.append(string4.charAt(j));
                }
                break;
            }
            if (stringBuffer.length() == 0) {
                LookupJLabelTextField.this.setCaretPosition(nArray[1]);
                return false;
            }
            Document document = LookupJLabelTextField.this.getDocument();
            try {
                document.insertString(nArray[1], stringBuffer.toString(), null);
            }
            catch (BadLocationException badLocationException) {
                System.out.println(badLocationException);
            }
            return true;
        }

        private final String getEnding(String string, int n, int n2) {
            if (!LookupJLabelTextField.this.appendEnding) {
                return "";
            }
            if (n == 0) {
                if (n2 >= string.length() || string.charAt(n2) != ':') {
                    return ": ";
                }
            } else if (n2 >= string.length() || string.charAt(n2) != ' ') {
                return " ";
            }
            return "";
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            LookupJLabelTextField.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            LookupJLabelTextField.this.unCommitted = "";
            LookupJLabelTextField.this.repaint();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            LookupJLabelTextField.this.repaint();
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void caretUpdate(CaretEvent caretEvent) {
            String string = LookupJLabelTextField.this.getText();
            int n = caretEvent.getDot() - 1;
            if (n < 0) {
                return;
            }
            try {
                if (string.charAt(n) == ' ') {
                    LookupJLabelTextField.this.unCommitted = "";
                    return;
                }
                int[] nArray = LookupJLabelTextField.this.getWordBoundry(string, n);
                if (nArray[0] == 32) {
                    LookupJLabelTextField.this.unCommitted = "";
                    return;
                }
                String string2 = string.substring(nArray[0], nArray[1]).toLowerCase();
                String[] stringArray = LookupJLabelTextField.this.convertModelToString();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].toLowerCase();
                    if (!string3.startsWith(string2) || string3.equals(string2)) continue;
                    LookupJLabelTextField.this.unCommitted = stringArray[i].substring(string2.length());
                    return;
                }
                LookupJLabelTextField.this.unCommitted = "";
            }
            finally {
                LookupJLabelTextField.this.repaint();
            }
        }
    }
}

