/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets;

import com.topcoder.client.contestApplet.common.LocalPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public abstract class LanguageAndStatusColoringDecoratorRenderer
implements TableCellRenderer,
Serializable {
    private TableCellRenderer renderer;
    private Color defaultForeground;

    public LanguageAndStatusColoringDecoratorRenderer(TableCellRenderer tableCellRenderer, Color color) {
        this.renderer = tableCellRenderer;
        this.defaultForeground = color != null ? color : Color.WHITE;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        Integer n3 = this.getLanguage(object, n, n2);
        int n4 = this.getStatus(object, n, n2);
        if (n3 == null) {
            component.setForeground(this.defaultForeground);
        } else {
            this.setupLook(LocalPreferences.resolveStatusPropertyFormat(n3, n4), component);
        }
        return component;
    }

    protected abstract Integer getLanguage(Object var1, int var2, int var3);

    protected abstract int getStatus(Object var1, int var2, int var3);

    public void setDefaultForeground(Color color) {
        this.defaultForeground = color;
    }

    private void setupLook(String string, Component component) {
        String string2 = LocalPreferences.getKeyAttribute(string, "color");
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        component.setForeground(localPreferences.getColor(string2, this.defaultForeground));
        boolean bl = localPreferences.isTrue(LocalPreferences.getKeyAttribute(string, "bold"));
        boolean bl2 = localPreferences.isTrue(LocalPreferences.getKeyAttribute(string, "italic"));
        Font font = component.getFont();
        if (bl == font.isBold() && bl2 == font.isItalic()) {
            return;
        }
        component.setFont(new Font(font.getFamily(), (bl ? 1 : 0) | (bl2 ? 2 : 0), font.getSize()));
    }
}

