/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.widgets.ValueTransformDecoratorCellRenderer;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class ComponentResultDisplayRenderer
extends ValueTransformDecoratorCellRenderer {
    private final NumberFormat fmt = new DecimalFormat("####0.00");
    private Map specificSets = Collections.synchronizedMap(new HashMap());
    private ResultDisplayType displayType;
    private String notChallengedString;
    private boolean canShowPoints;

    public ComponentResultDisplayRenderer(TableCellRenderer tableCellRenderer) {
        super(tableCellRenderer);
        this.canShowPoints = true;
        this.notChallengedString = "Not Challenged";
        this.displayType = ResultDisplayType.STATUS;
    }

    public ComponentResultDisplayRenderer(RoundModel roundModel, TableCellRenderer tableCellRenderer) {
        super(tableCellRenderer);
        this.setModel(roundModel);
    }

    public void setModel(RoundModel roundModel) {
        this.displayType = roundModel.getRoundProperties().getAllowedScoreTypesToShow()[0];
        this.canShowPoints = roundModel.getRoundProperties().usesScore();
        this.notChallengedString = roundModel.getRoundProperties().hasChallengePhase() ? "Not Challenged" : "Submitted";
    }

    protected Object transform(Object object, int n, int n2) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "0.00";
        if (!(object instanceof CoderComponent)) {
            if (object instanceof Integer) {
                return object.toString();
            }
            return Common.formatScore((Double)object);
        }
        CoderComponent coderComponent = (CoderComponent)object;
        switch (coderComponent.getStatus()) {
            case 110: {
                string = "Unopened";
                bl = true;
                break;
            }
            case 120: {
                string = "Opened";
                bl = true;
                break;
            }
            case 121: {
                string = "Compiled";
                bl = true;
                break;
            }
            case 130: {
                string2 = this.fmt.format(coderComponent.getPoints().doubleValue() / 100.0);
                string = this.notChallengedString;
                bl2 = this.canShowPoints;
                break;
            }
            case 131: {
                string2 = this.fmt.format(coderComponent.getPoints().doubleValue() / 100.0);
                string = this.notChallengedString;
                bl2 = this.canShowPoints;
                break;
            }
            case 140: {
                string = "Challenge Succeeded";
                break;
            }
            case 150: {
                string = "Passed System Test";
                string2 = this.fmt.format(coderComponent.getPoints().doubleValue() / 100.0);
                break;
            }
            case 160: {
                string = "Failed System Test";
                break;
            }
            default: {
                throw new IllegalStateException("Invalid component state: " + coderComponent);
            }
        }
        ResultDisplayType resultDisplayType = this.getTypeFor(coderComponent);
        if (resultDisplayType == null) {
            resultDisplayType = this.displayType;
        }
        if (ResultDisplayType.POINTS.equals((Object)resultDisplayType) && !bl || bl2) {
            return string2;
        }
        if (ResultDisplayType.STATUS.equals((Object)resultDisplayType) || bl || coderComponent.getStatus() < 150 || coderComponent.getPassedSystemTests() == null) {
            return string;
        }
        if (ResultDisplayType.PASSED_TESTS.equals((Object)resultDisplayType)) {
            return coderComponent.getPassedSystemTests().toString();
        }
        return this;
    }

    public ResultDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(ResultDisplayType resultDisplayType) {
        this.displayType = resultDisplayType;
        this.specificSets.clear();
    }

    public void toggleDisplayTypeForComponent(CoderComponent coderComponent, ResultDisplayType[] resultDisplayTypeArray) {
        ResultDisplayType resultDisplayType = this.getTypeFor(coderComponent);
        if (resultDisplayType == null) {
            resultDisplayType = this.displayType;
        }
        resultDisplayType = this.getNexTo(resultDisplayType, resultDisplayTypeArray);
        this.setTypeFor(coderComponent, resultDisplayType);
    }

    private ResultDisplayType getNexTo(ResultDisplayType resultDisplayType, ResultDisplayType[] resultDisplayTypeArray) {
        for (int i = 0; i < resultDisplayTypeArray.length; ++i) {
            if (!resultDisplayType.equals((Object)resultDisplayTypeArray[i])) continue;
            return resultDisplayTypeArray[(i + 1) % resultDisplayTypeArray.length];
        }
        return resultDisplayTypeArray[0];
    }

    private void setTypeFor(CoderComponent coderComponent, ResultDisplayType resultDisplayType) {
        this.specificSets.put(coderComponent, resultDisplayType);
    }

    private ResultDisplayType getTypeFor(CoderComponent coderComponent) {
        return (ResultDisplayType)this.specificSets.get(coderComponent);
    }
}

