/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.uilogic.panels.TablePanel;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyAdapter;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contestantMessages.response.CreateVisitedPracticeResponse;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class VisitedPracticePanel
extends TablePanel {
    private static final String[] headers = new String[]{"Room Name"};
    private boolean enabled = true;
    static /* synthetic */ Class class$com$topcoder$netCommon$contestantMessages$response$data$RoundData;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void update(CreateVisitedPracticeResponse createVisitedPracticeResponse) {
        int[] nArray = createVisitedPracticeResponse.getRoundIDs();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Integer(nArray[i]));
        }
        this.getTableModel().update(arrayList);
    }

    protected String getTableName() {
        return "practice_room_table";
    }

    protected String getMenuName() {
        return "practice_room_table_menu";
    }

    public VisitedPracticePanel(ContestApplet contestApplet, UIPage uIPage) {
        super(contestApplet, uIPage, new VisitedPracticeTableModel(contestApplet));
        this.table.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (VisitedPracticePanel.this.enabled) {
                    VisitedPracticePanel.this.mouseClickEvent(mouseEvent);
                }
            }
        });
        this.table.addEventListener("Key", new UIKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (VisitedPracticePanel.this.enabled && keyEvent.getKeyCode() == 10) {
                    VisitedPracticePanel.this.openMessageEvent();
                }
            }
        });
        uIPage.getComponent("practice_room_table_menu_open").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisitedPracticePanel.this.openMessageEvent();
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openMessageEvent();
        }
    }

    private synchronized void openMessageEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        if (n < 0) {
            return;
        }
        RoundModel roundModel = (RoundModel)this.getTableModel().getValueAt(n, 0);
        this.ca.getRoomManager().loadRoom(roundModel.getCoderRooms()[0].getType(), roundModel.getCoderRooms()[0].getRoomID(), 2);
    }

    static class VisitedPracticeTableModel
    extends SortedTableModel {
        private Contestant model;

        public VisitedPracticeTableModel(ContestApplet contestApplet) {
            super(headers, new Class[]{class$com$topcoder$netCommon$contestantMessages$response$data$RoundData == null ? (class$com$topcoder$netCommon$contestantMessages$response$data$RoundData = VisitedPracticePanel.class$("com.topcoder.netCommon.contestantMessages.response.data.RoundData")) : class$com$topcoder$netCommon$contestantMessages$response$data$RoundData});
            this.model = contestApplet.getModel();
            this.addSortElement(new SortElement(0, true));
        }

        public Object getValueAt(int n, int n2) {
            Integer n3 = (Integer)this.get(n);
            return this.model.getRound(n3.intValue());
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            RoundModel roundModel = this.model.getRound(n.longValue());
            RoundModel roundModel2 = this.model.getRound(n2.longValue());
            Iterator iterator = this.getSortListIterator();
            if (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n3 = sortElement.isOpposite() ? -1 : 1;
                int n4 = roundModel.getContestName().compareTo(roundModel2.getContestName());
                return n3 * n4;
            }
            throw new IllegalStateException("Problem sorting broadcasts: " + this.getItemList());
        }
    }
}

