/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.panels.TablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserTableModel;
import com.topcoder.client.contestant.view.UserListListener;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class UserTablePanel
extends TablePanel
implements UserListListener {
    protected UIComponent tablePanel;
    protected TitledBorder border;
    protected boolean enabled;
    protected UIPage page;
    protected String title;
    protected UserTableModel userTableModel;

    protected String getTablePanelName() {
        return "user_table_panel";
    }

    protected String getTableName() {
        return "user_table";
    }

    protected String getMenuName() {
        return "user_table_menu";
    }

    public boolean isPanelEnabled() {
        return this.enabled;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public UserTablePanel(ContestApplet contestApplet, UIPage uIPage) {
        super(contestApplet, uIPage, new UserTableModel(contestApplet.getModel(), CommonData.userHeader));
        this.page = uIPage;
        this.userTableModel = (UserTableModel)this.getTableModel();
        this.tablePanel = uIPage.getComponent(this.getTablePanelName());
        this.border = (TitledBorder)this.tablePanel.getProperty("border");
        this.title = this.border.getTitle();
        this.border.setTitle(this.title + " [0]");
        this.table.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (UserTablePanel.this.enabled) {
                    UserTablePanel.this.rightClickEvent(mouseEvent);
                    UserTablePanel.this.doubleClickEvent(mouseEvent);
                }
            }
        });
        this.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                UserTablePanel.this.tableCountEvent();
            }
        });
        uIPage.getComponent("user_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserTablePanel.this.infoPopupEvent();
            }
        });
        this.setupColumns("user_table_user_renderer");
        this.setupFonts("user_table_header_renderer");
    }

    protected UserTablePanel(ContestApplet contestApplet, UIPage uIPage, String string, String string2) {
        super(contestApplet, uIPage, new UserTableModel(contestApplet.getModel(), CommonData.userHeader));
        this.page = uIPage;
        this.userTableModel = (UserTableModel)this.getTableModel();
        this.tablePanel = uIPage.getComponent(this.getTablePanelName());
        this.border = (TitledBorder)this.tablePanel.getProperty("border");
        this.title = this.border.getTitle();
        this.border.setTitle(this.title + " [0]");
        this.table.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (UserTablePanel.this.enabled) {
                    UserTablePanel.this.rightClickEvent(mouseEvent);
                    UserTablePanel.this.doubleClickEvent(mouseEvent);
                }
            }
        });
        this.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                UserTablePanel.this.tableCountEvent();
            }
        });
        this.setupColumns(string);
        this.setupFonts(string2);
    }

    protected UserTablePanel(ContestApplet contestApplet, UIPage uIPage, UserTableModel userTableModel, String string, String string2) {
        super(contestApplet, uIPage, userTableModel);
        if (userTableModel.getColumnCount() < 2) {
            throw new IllegalArgumentException("Not enough headers in UserTablePanel()!");
        }
        this.page = uIPage;
        this.userTableModel = userTableModel;
        this.tablePanel = uIPage.getComponent(this.getTablePanelName());
        this.border = (TitledBorder)this.tablePanel.getProperty("border");
        this.title = this.border.getTitle();
        this.border.setTitle(this.title + " [0]");
        this.setupColumns(string);
        this.setupFonts(string2);
    }

    protected void tableCountEvent() {
        this.border.setTitle(this.title + " [" + this.table.getProperty("RowCount") + "]");
        this.tablePanel.performAction("revalidate");
        this.tablePanel.performAction("repaint");
    }

    protected void setupFonts(String string) {
        this.border.setTitleFont(new Font(LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont"), 1, LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize")));
        this.page.getComponent(string).setProperty("font", new Font(LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont"), 0, LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize")));
    }

    private void setupColumns(String string) {
        UIComponent uIComponent = this.page.getComponent(string);
        uIComponent.setProperty("font", new Font(LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont"), 0, LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize")));
        uIComponent.setProperty("model", this.ca.getModel());
        this.getTable().getTableHeader().addMouseListener(new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UserTablePanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.getTableModel().sort(1, false);
    }

    public void updateUserList(final UserListItem[] userListItemArray) {
        Runnable runnable = new Runnable(){

            public void run() {
                UserTablePanel.this.getTableModel().update(Arrays.asList(userListItemArray));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void doubleClickEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.infoPopupEvent();
        }
    }

    protected void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.getTable().getTableHeader().repaint();
        }
    }

    protected void infoPopupEvent() {
        int n = this.getTable().getSelectedRow();
        String string = ((UserNameEntry)this.getTable().getValueAt(n, 1)).getName();
        this.ca.setCurrentFrame(this.ca.getMainFrame());
        this.ca.requestCoderInfo(string, ((UserNameEntry)this.getTable().getValueAt(n, 1)).getUserType());
    }

    public String getSelectedUserHandle() {
        int n = this.getTable().getSelectedRow();
        if (0 > n || n >= this.getTable().getRowCount()) {
            return "";
        }
        return this.userTableModel.getUser(n).getUserName();
    }
}

