/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.AppletPreferencesDialog;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;

public class SummaryConfigurationPanel {
    private boolean changesPending = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private ActionHandler handler = new ActionHandler();
    private static int CTR = 0;
    private final int UNOPEN = CTR++;
    private final int OPENED = CTR++;
    private final int COMPILED = CTR++;
    private final int JAVAPOINTS = CTR++;
    private final int JAVACHLPASSED = CTR++;
    private final int JAVACHLFAILED = CTR++;
    private final int JAVASYSPASSED = CTR++;
    private final int JAVASYSFAILED = CTR++;
    private final int CPPPOINTS = CTR++;
    private final int CPPCHLPASSED = CTR++;
    private final int CPPCHLFAILED = CTR++;
    private final int CPPSYSPASSED = CTR++;
    private final int CPPSYSFAILED = CTR++;
    private final int CSHARPPOINTS = CTR++;
    private final int CSHARPCHLPASSED = CTR++;
    private final int CSHARPCHLFAILED = CTR++;
    private final int CSHARPSYSPASSED = CTR++;
    private final int CSHARPSYSFAILED = CTR++;
    private static final int VBPOINTS = CTR++;
    private static final int VBCHLPASSED = CTR++;
    private static final int VBCHLFAILED = CTR++;
    private static final int VBSYSPASSED = CTR++;
    private static final int VBSYSFAILED = CTR++;
    private static final int PYTHONPOINTS = CTR++;
    private static final int PYTHONCHLPASSED = CTR++;
    private static final int PYTHONCHLFAILED = CTR++;
    private static final int PYTHONSYSPASSED = CTR++;
    private static final int PYTHONSYSFAILED = CTR++;
    private UIComponent[] colors = new UIComponent[CTR];
    private UIComponent[] bold = new UIComponent[CTR];
    private UIComponent[] italics = new UIComponent[CTR];
    private AppletPreferencesDialog parentFrame;
    private UIPage page;

    public SummaryConfigurationPanel(FrameLogic frameLogic, UIPage uIPage) {
        this.page = uIPage;
        this.parentFrame = (AppletPreferencesDialog)frameLogic;
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryunopened", this.UNOPEN, "summary_general_unopened_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryopened", this.OPENED, "summary_general_opened_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycompiled", this.COMPILED, "summary_general_compiled_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavapoints", this.JAVAPOINTS, "summary_java_points_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlpassed", this.JAVACHLPASSED, "summary_java_challengesuccess_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlfailed", this.JAVACHLFAILED, "summary_java_challengefail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasyspassed", this.JAVASYSPASSED, "summary_java_testpass_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasysfailed", this.JAVASYSFAILED, "summary_java_testfail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycpppoints", this.CPPPOINTS, "summary_c++_points_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlpassed", this.CPPCHLPASSED, "summary_c++_challengesuccess_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlfailed", this.CPPCHLFAILED, "summary_c++_challengefail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsyspassed", this.CPPSYSPASSED, "summary_c++_testpass_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsysfailed", this.CPPSYSFAILED, "summary_c++_testfail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharppoints", this.CSHARPPOINTS, "summary_c#_points_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlpassed", this.CSHARPCHLPASSED, "summary_c#_challengesuccess_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlfailed", this.CSHARPCHLFAILED, "summary_c#_challengefail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsyspassed", this.CSHARPSYSPASSED, "summary_c#_testpass_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsysfailed", this.CSHARPSYSFAILED, "summary_c#_testfail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbpoints", VBPOINTS, "summary_vb_points_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlpassed", VBCHLPASSED, "summary_vb_challengesuccess_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlfailed", VBCHLFAILED, "summary_vb_challengefail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsyspassed", VBSYSPASSED, "summary_vb_testpass_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsysfailed", VBSYSFAILED, "summary_vb_testfail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonpoints", PYTHONPOINTS, "summary_python_points_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlpassed", PYTHONCHLPASSED, "summary_python_challengesuccess_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlfailed", PYTHONCHLFAILED, "summary_python_challengefail_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsyspassed", PYTHONSYSPASSED, "summary_python_testpass_");
        this.createRow("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsysfailed", PYTHONSYSFAILED, "summary_python_testfail_");
        if (!CommonData.allowsJava(this.parentFrame.getApplet().getCompanyName())) {
            uIPage.getComponent("summary_java_panel").setProperty("Visible", Boolean.FALSE);
        }
        if (!CommonData.allowsCPP(this.parentFrame.getApplet().getCompanyName())) {
            uIPage.getComponent("summary_c++_panel").setProperty("Visible", Boolean.FALSE);
        }
        if (!CommonData.allowsCS(this.parentFrame.getApplet().getCompanyName())) {
            uIPage.getComponent("summary_c#_panel").setProperty("Visible", Boolean.FALSE);
        }
        if (!CommonData.allowsVB(this.parentFrame.getApplet().getCompanyName())) {
            uIPage.getComponent("summary_vb_panel").setProperty("Visible", Boolean.FALSE);
        }
        if (!CommonData.allowsPython(this.parentFrame.getApplet().getCompanyName())) {
            uIPage.getComponent("summary_python_panel").setProperty("Visible", Boolean.FALSE);
        }
    }

    private void createRow(String string, int n, String string2) {
        this.colors[n] = this.createColorButton(LocalPreferences.getKeyAttribute(string, "color"), string2 + "color");
        this.bold[n] = this.createCheckBox(LocalPreferences.getKeyAttribute(string, "bold"), string2 + "bold");
        this.italics[n] = this.createCheckBox(LocalPreferences.getKeyAttribute(string, "italic"), string2 + "italic");
    }

    private UIComponent createColorButton(String string, String string2) {
        Color color = this.localPref.getColor(string);
        UIComponent uIComponent = this.page.getComponent(string2);
        uIComponent.setProperty("Background", color);
        uIComponent.addEventListener("Action", this.handler);
        return uIComponent;
    }

    private UIComponent createCheckBox(String string, String string2) {
        UIComponent uIComponent = this.page.getComponent(string2);
        uIComponent.setProperty("Selected", this.localPref.isTrue(string));
        uIComponent.addEventListener("Action", this.handler);
        return uIComponent;
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public void savePreferences() {
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryunopened", this.UNOPEN);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryopened", this.OPENED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycompiled", this.COMPILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavapoints", this.JAVAPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlpassed", this.JAVACHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlfailed", this.JAVACHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasyspassed", this.JAVASYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasysfailed", this.JAVASYSFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycpppoints", this.CPPPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlpassed", this.CPPCHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlfailed", this.CPPCHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsyspassed", this.CPPSYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsysfailed", this.CPPSYSFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharppoints", this.CSHARPPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlpassed", this.CSHARPCHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlfailed", this.CSHARPCHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsyspassed", this.CSHARPSYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsysfailed", this.CSHARPSYSFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbpoints", VBPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlpassed", VBCHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlfailed", VBCHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsyspassed", VBSYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsysfailed", VBSYSFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonpoints", PYTHONPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlpassed", PYTHONCHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlfailed", PYTHONCHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsyspassed", PYTHONSYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsysfailed", PYTHONSYSFAILED);
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changesPending = false;
    }

    public void saveType(String string, int n) {
        this.localPref.setColor(LocalPreferences.getKeyAttribute(string, "color"), (Color)this.colors[n].getProperty("Background"));
        this.localPref.setTrue(LocalPreferences.getKeyAttribute(string, "bold"), (Boolean)this.bold[n].getProperty("Selected"));
        this.localPref.setTrue(LocalPreferences.getKeyAttribute(string, "italic"), (Boolean)this.italics[n].getProperty("Selected"));
    }

    private class ActionHandler
    implements UIActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JCheckBox) {
                SummaryConfigurationPanel.this.changesPending = true;
                return;
            }
            Color color = ((JButton)actionEvent.getSource()).getBackground();
            Color color2 = JColorChooser.showDialog(null, "Choose color", color);
            if (color2 == null) {
                return;
            }
            if (!color.equals(color2)) {
                SummaryConfigurationPanel.this.changesPending = true;
            }
            ((JButton)actionEvent.getSource()).setBackground(color2);
        }
    }
}

