/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.uilogic.panels.ProblemInfoComponent;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.shared.problem.DataType;

public class ProblemInfoPanel
implements ProblemInfoComponent {
    private UIComponent className;
    private UIComponent methodName;
    private UIComponent returnType;
    private UIComponent argTypes;

    public ProblemInfoPanel(ContestApplet contestApplet, UIPage uIPage) {
        this.className = uIPage.getComponent("problem_info_class_name");
        this.methodName = uIPage.getComponent("problem_info_method_name");
        this.returnType = uIPage.getComponent("problem_info_return_type");
        this.argTypes = uIPage.getComponent("problem_info_arg_types");
    }

    public void updateComponentInfo(ProblemComponentModel problemComponentModel, int n) {
        this.className.setProperty("Text", problemComponentModel.getClassName());
        this.methodName.setProperty("Text", problemComponentModel.getMethodName());
        this.returnType.setProperty("Text", problemComponentModel.getReturnType().getDescriptor(n));
        String string = "(";
        DataType[] dataTypeArray = problemComponentModel.getParamTypes();
        if (dataTypeArray.length > 0) {
            string = string + dataTypeArray[0].getDescriptor(n);
            for (int i = 1; i < dataTypeArray.length; ++i) {
                string = string + "," + dataTypeArray[i].getDescriptor(n);
            }
        }
        this.argTypes.setProperty("Text", string + ")");
        this.argTypes.performAction("repaint");
    }

    public void clear() {
    }
}

